/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.el.VariableResolver;
import com.caucho.server.http.Application;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

class QServletConfig
implements ServletConfig {
    static L10N L = new L10N(class$com$caucho$server$http$QServletConfig == null ? (class$com$caucho$server$http$QServletConfig = QServletConfig.class$("com.caucho.server.http.QServletConfig")) : class$com$caucho$server$http$QServletConfig);
    private Application _application;
    private RegistryNode _registry;
    private RegistryNode _initRegistry;
    private String _name;
    private String _className;
    private String _jspFile;
    private String _displayName;
    private String _description;
    private int _loadOnStartup = Integer.MIN_VALUE;
    private HashMap _init;
    private String _outputFilter;
    private ArrayList _servletPool;
    private int _servletCount;
    private long _available;
    private ServletException _initException;
    private ArrayList _hourTimes;
    private ArrayList _minuteTimes;
    private long _runAtPeriod;
    private FilterChain _topFilterChain;
    private FilterChain _incFilterChain;
    private QDate _cal;
    static /* synthetic */ Class class$com$caucho$server$http$QServletConfig;

    QServletConfig(Application application, String name, String defaultClassName, RegistryNode registry) throws Exception {
        this._application = application;
        this._registry = registry;
        this._name = name;
        this._init = new HashMap();
        this._loadOnStartup = Integer.MIN_VALUE;
        VariableResolver env = application.getEnv();
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.equals("nvoker")) {
            throw new RuntimeException("nvoker bug");
        }
        if (registry == null) {
            if (name.endsWith(".jsp") || name.endsWith(".xtp")) {
                this._jspFile = name;
            } else {
                this._className = defaultClassName == null ? name : defaultClassName;
            }
            return;
        }
        this._className = registry.getELString("servlet-class", defaultClassName, env);
        this._jspFile = registry.getELString("jsp-file", null, env);
        if (this._className == null && this._jspFile == null) {
            if (name.endsWith(".jsp") || name.endsWith(".xtp")) {
                this._jspFile = name;
            } else {
                this._className = defaultClassName != null ? defaultClassName : name;
            }
        }
        Iterator iter = registry.iterator();
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            if (node.getName().equals("init-param")) {
                application.fillParam(node, this._init);
                continue;
            }
            if (node.getName().equals("run-at")) {
                this.configureRunAt(node);
                continue;
            }
            if (node.getName().equals("load-on-startup")) {
                this._loadOnStartup = registry.getInt("load-on-startup", 0);
                continue;
            }
            if (node.getName().equals("output-filter")) {
                this._outputFilter = node.getValue();
                continue;
            }
            if (node.getName().equals("display-name")) {
                this._displayName = node.getValue();
                continue;
            }
            if (node.getName().equals("description")) {
                this._description = node.getValue();
                continue;
            }
            if (node.getName().equals("servlet-name") || node.getName().equals("servlet-class") || node.getName().equals("jsp-file") || node.getName().equals("icon") || node.getName().equals("security-role-ref") || node.getName().equals("url-pattern") || node.getName().equals("case-sensitive") || node.getName().equals("url-regexp") || node.getName().equals("path-info") || node.getName().equals("strict-mapping")) continue;
            if (node.getName().equals("init")) {
                this._initRegistry = node;
                continue;
            }
            throw Application.error(node, L.l("unknown element `{0}' in {1}", (Object)node.getName(), "servlet"));
        }
    }

    public RegistryNode getNode() {
        return this._registry;
    }

    public RegistryNode getInitRegistry() {
        return this._initRegistry;
    }

    boolean isCron() {
        return this._runAtPeriod > 0L || this._hourTimes != null || this._minuteTimes != null;
    }

    public String getServletName() {
        return this._name;
    }

    public ServletContext getServletContext() {
        return this._application;
    }

    public String getInitParameter(String name) {
        return (String)this._init.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._init.keySet());
    }

    public void setInitParameter(String name, String value) {
        this._init.put(name, value);
    }

    public Path getPath() {
        return this._application.getAppDir();
    }

    String getClassName() {
        return this._className;
    }

    String getJspFile() {
        return this._jspFile;
    }

    int loadOnStartup() {
        return this._loadOnStartup;
    }

    String getChain(String mimeType) {
        return this._application.getChain(mimeType);
    }

    void setAvailable(long time) {
        this._available = time;
    }

    boolean isAvailable(long now) {
        return this._available <= now;
    }

    void setInitException(ServletException e) {
        if (e instanceof UnavailableException) {
            UnavailableException unavailableExn = (UnavailableException)e;
            if (unavailableExn.isPermanent()) {
                this.setAvailable(Long.MAX_VALUE);
            } else {
                this.setAvailable(Alarm.getCurrentTime() + 1000L * (long)unavailableExn.getUnavailableSeconds());
            }
        }
        this._initException = e;
    }

    ServletException getInitException() {
        return this._initException;
    }

    private void configureRunAt(RegistryNode node) throws Exception {
        try {
            this._runAtPeriod = node.getELPeriod("period", 0L, this._application.getEnv());
            if (this._loadOnStartup < 0) {
                this._loadOnStartup = 0;
            }
        }
        catch (RegistryException e) {
            throw new ServletException((Throwable)e);
        }
        if (this._runAtPeriod > 0L && this._runAtPeriod < 1000L) {
            this._runAtPeriod = 1000L;
        }
        if (this._runAtPeriod > 0L) {
            return;
        }
        String string = node.getELString(null, null, this._application.getEnv());
        if (string == null) {
            return;
        }
        int len = string.length();
        char ch = '\u0000';
        int i = 0;
        while (true) {
            Integer iMinute;
            if (i < len && (Character.isWhitespace(ch = string.charAt(i)) || ch == ',')) {
                ++i;
                continue;
            }
            if (i >= len) {
                return;
            }
            if ((ch < '0' || ch > '9') && ch != ':') {
                throw Application.error(node, L.l("illegal run-at time `{0}'.  Run-at values are either hour (0:00, 6:30, 12:15) or minute (:15, :30, :45).", string));
            }
            int hour = 0;
            int minute = 0;
            boolean hasHour = false;
            while (i < len && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                hasHour = true;
                hour = 10 * hour + ch - 48;
                ++i;
            }
            if (hour >= 24) {
                throw Application.error(node, L.l("illegal run-at time `{0}'", string));
            }
            if (ch == ':') {
                ++i;
                while (i < len && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                    minute = 10 * minute + ch - 48;
                    ++i;
                }
            }
            if (minute >= 60) {
                throw Application.error(node, L.l("illegal run-at time `{0}'", string));
            }
            if (this._loadOnStartup < 0) {
                this._loadOnStartup = 0;
            }
            if (hasHour) {
                int hourTime;
                Integer iHour;
                if (this._hourTimes == null) {
                    this._hourTimes = new ArrayList();
                }
                if (this._hourTimes.contains(iHour = new Integer(hourTime = 60 * hour + minute))) continue;
                this._hourTimes.add(iHour);
                continue;
            }
            if (this._minuteTimes == null) {
                this._minuteTimes = new ArrayList();
            }
            if (this._minuteTimes.contains(iMinute = new Integer(minute))) continue;
            this._minuteTimes.add(iMinute);
        }
    }

    long getNextTimeout(long now) {
        long delta;
        long nextTime;
        Integer iTime;
        int i;
        if (this._cal == null) {
            this._cal = new QDate();
        }
        this._cal.setTime(now);
        long zone = this._cal.getZoneOffset();
        if (this._runAtPeriod > 0L) {
            return RegistryNode.periodEnd(now + zone, this._runAtPeriod) - zone;
        }
        now -= now % 60000L;
        long local = now + this._cal.getZoneOffset();
        long dayMinutes = local / 60000L % 1440L;
        long hourMinutes = dayMinutes % 60L;
        long nextDelta = Long.MAX_VALUE;
        for (i = 0; this._hourTimes != null && i < this._hourTimes.size(); ++i) {
            iTime = (Integer)this._hourTimes.get(i);
            nextTime = iTime.intValue();
            delta = (nextTime - dayMinutes + 1440L) % 1440L;
            if (delta <= 0L) {
                delta = 1440L;
            }
            if (delta >= nextDelta) continue;
            nextDelta = delta;
        }
        for (i = 0; this._minuteTimes != null && i < this._minuteTimes.size(); ++i) {
            iTime = (Integer)this._minuteTimes.get(i);
            nextTime = iTime.intValue();
            delta = (nextTime - hourMinutes + 60L) % 60L;
            if (delta <= 0L) {
                delta = 60L;
            }
            if (delta >= nextDelta) continue;
            nextDelta = delta;
        }
        if (nextDelta < Integer.MAX_VALUE) {
            return now + nextDelta * 60000L;
        }
        return Long.MAX_VALUE;
    }

    Servlet getServlet() {
        if (this._servletPool == null || this._servletPool.size() == 0) {
            return null;
        }
        return (Servlet)this._servletPool.remove(this._servletPool.size() - 1);
    }

    Servlet loadServlet(boolean isTop) throws Exception {
        return this._application.loadServlet(this, isTop);
    }

    int getServletCount() {
        return this._servletCount;
    }

    void allocateServlet() {
        ++this._servletCount;
    }

    Application getApplication() {
        return this._application;
    }

    void freeServlet(Servlet servlet) {
        if (this._servletPool == null) {
            this._servletPool = new ArrayList();
        }
        this._servletPool.add(servlet);
    }

    FilterChain getTopFilterChain() {
        return this._topFilterChain;
    }

    void setTopFilterChain(FilterChain filterChain) {
        this._topFilterChain = filterChain;
    }

    FilterChain getIncFilterChain() {
        return this._incFilterChain;
    }

    void setIncFilterChain(FilterChain filterChain) {
        this._incFilterChain = filterChain;
    }

    public String toString() {
        return "ServletConfig[name=" + this._name + " class=" + this._className + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

