/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.el.SystemPropertiesResolver;
import com.caucho.el.VariableResolver;
import com.caucho.http.admin.AbstractServerListener;
import com.caucho.http.admin.PingThread;
import com.caucho.http.admin.ServerAdmin;
import com.caucho.http.admin.ServerEvent;
import com.caucho.jmx.MBeanServerFactoryImpl;
import com.caucho.server.RequestFactory;
import com.caucho.server.ShutdownListener;
import com.caucho.server.StreamConnection;
import com.caucho.server.TcpServer;
import com.caucho.server.http.Application;
import com.caucho.server.http.CompileRequest;
import com.caucho.server.http.ConfigException;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.OldSSLFactory;
import com.caucho.server.http.SSLFactory;
import com.caucho.server.http.ServletServer;
import com.caucho.util.Alarm;
import com.caucho.util.BeanUtil;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.ClassLoaderStream;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.QSSLFactory;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QServerSocketWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ResinServer
implements ShutdownListener {
    static L10N L = new L10N("com/caucho/server/http/messages");
    static final String COPYRIGHT = "Copyright (c) 1998-2002 Caucho Technology.  All rights reserved.";
    static final String HTTP_FACTORY = "com.caucho.server.http.HttpServer";
    static final String SRUN_FACTORY = "com.caucho.server.http.RunnerServer";
    static WriteStream dbg;
    static Class keyManagerClass;
    static HashMap pingElements;
    static HashMap serverElements;
    private String resinConf = CauchoSystem.getResinConfig();
    private boolean isHttp;
    private String httpHost;
    private int httpPort = 8080;
    private String srunHost;
    private int srunPort = 6802;
    private String pingHost;
    private int pingPort = 80;
    private boolean hasPort = false;
    private boolean compileShowOutput = false;
    private String compileHost = null;
    private ArrayList compileURLs = null;
    private String serverId = null;
    private long shutdownWaitTime = 15000L;
    private Thread mainThread;
    private InputStream waitIn;
    private boolean deadwait;
    protected volatile boolean isClosed;
    private boolean allowHttp;
    protected ArrayList tcpServers = new ArrayList();
    private ArrayList serverListeners = new ArrayList();
    protected ServletServer servletServer;
    private VariableResolver _env;
    static /* synthetic */ Class class$java$lang$SecurityManager;

    public ResinServer(String[] argv, boolean isHttp) throws Exception {
        this.isHttp = isHttp;
        this.parseCommandLine(argv);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void parseCommandLine(String[] argv) throws Exception {
        int len = argv.length;
        int i = 0;
        ClassLoaderStream.setStdout(System.out);
        ClassLoaderStream.setStderr(System.err);
        while (i < len) {
            RotateStream stream;
            if (i + 1 < len && (argv[i].equals("-stdout") || argv[i].equals("--stdout"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                ClassLoaderStream.setStdout(stream.getStream());
                i += 2;
                continue;
            }
            if (i + 1 < len && (argv[i].equals("-stderr") || argv[i].equals("--stderr"))) {
                Path path = Vfs.lookup(argv[i + 1]);
                stream = RotateStream.create(path);
                ClassLoaderStream.setStderr(stream.getStream());
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-conf")) {
                this.resinConf = argv[i + 1];
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-server")) {
                this.serverId = argv[i + 1];
                System.setProperty("serverId", this.serverId);
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-srun")) {
                this.serverId = argv[i + 1];
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-port")) {
                this.srunPort = this.httpPort = Integer.parseInt(argv[i + 1]);
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-http-port")) {
                this.httpPort = Integer.parseInt(argv[i + 1]);
                i += 2;
                continue;
            }
            if (i + 1 < len && argv[i].equals("-srun-port")) {
                this.srunPort = Integer.parseInt(argv[i + 1]);
                i += 2;
                continue;
            }
            if (argv[i].equals("-version")) {
                System.out.println(Version.FULL_VERSION);
                System.exit(66);
                continue;
            }
            if (i + 1 < len && argv[i].equals("-compile-host")) {
                this.compileHost = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-e")) {
                if (this.compileURLs == null) {
                    this.compileURLs = new ArrayList();
                }
                this.compileShowOutput = true;
                ++i;
                continue;
            }
            if (argv[i].equals("-compile")) {
                if (this.compileURLs == null) {
                    this.compileURLs = new ArrayList();
                }
                ++i;
                continue;
            }
            if (argv[i].equals("-socketwait")) {
                int socketport = Integer.parseInt(argv[i + 1]);
                Socket socket = null;
                for (int k = 0; k < 15 && socket == null; ++k) {
                    try {
                        socket = new Socket("127.0.0.1", socketport);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (socket != null) continue;
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                if (socket == null) {
                    System.err.println("can't connect to parent");
                    System.exit(66);
                }
                this.waitIn = socket.getInputStream();
                socket.setSoTimeout(10000);
                i += 2;
                continue;
            }
            if (this.compileURLs != null) {
                while (i < len) {
                    this.compileURLs.add(argv[i]);
                    ++i;
                }
                break;
            }
            System.out.println(L.l("unknown argument `{0}'", argv[i]));
            System.out.println();
            ResinServer.usage();
            System.exit(66);
        }
    }

    private VariableResolver getEnv() {
        return this._env;
    }

    public void init(ArrayList serverSockets) throws Exception {
        if (this.compileURLs == null) {
            System.out.println(Version.FULL_VERSION);
            System.out.println("Copyright(c) 1998-2003 Caucho Technology.  All rights reserved.");
            System.out.println();
            System.out.println("Starting Resin on " + QDate.formatLocal(Alarm.getCurrentTime()));
        }
        this.mainThread = Thread.currentThread();
        System.setProperty("java.naming.factory.initial", "com.caucho.naming.InitialContextFactoryImpl");
        System.setProperty("java.naming.factory.url.pkgs", "com.caucho.naming");
        if (System.getProperty("org.xml.sax.driver") == null) {
            System.setProperty("org.xml.sax.driver", "com.caucho.xml.Xml");
        }
        this._env = new SystemPropertiesResolver();
        Path conf = CauchoSystem.getResinHome().lookupNative(this.resinConf);
        MBeanServerFactoryImpl.addMBeanServer("urn/caucho/ROOT");
        ReadStream is = conf.openRead();
        Registry.setDefault(Registry.parse(is));
        is.close();
        dbg = LogStream.open("/caucho.com/httpd");
        if (dbg.canWrite()) {
            dbg.log("httpd startup: " + Version.FULL_VERSION);
        }
        ResinServer.setSystemProperties(Registry.lookup("/caucho.com"));
        ResinServer.addSecurityProviders(Registry.lookup("/caucho.com"));
        ResinServer.setSecurityManager(Registry.lookup("/caucho.com"));
        boolean insensitive = CauchoSystem.isCaseInsensitive();
        insensitive = !Registry.getBoolean("/caucho.com/case-sensitive", !insensitive);
        insensitive = Registry.getBoolean("/caucho.com/case-insensitive", insensitive);
        CauchoSystem.setCaseInsensitive(insensitive);
        RegistryNode node = Registry.lookup("/caucho.com/http-server");
        if (this.compileURLs != null) {
            this.servletServer = new ServletServer(conf, node, CauchoSystem.getResinHome(), this.serverId);
            if (!this.compileShowOutput) {
                this.servletServer.setCompileOnly(true);
            }
            this.servletServer.init();
            this.doCompile(this.servletServer, this.compileURLs);
            System.exit(66);
        }
        this.tcpServers = new ArrayList();
        String user = node.getString("user-name", null);
        user = Registry.getString("/caucho.com/user-name", user);
        String group = node.getString("group-name", null);
        group = Registry.getString("/caucho.com/group-name", group);
        if (user != null) {
            this.addServers(node, serverSockets);
            int uid = CauchoSystem.setUser(user, group);
            if (uid < 0) {
                throw new Exception(L.l("Use bin/resin to set the user.  user-name and group-name are not allowed when using bin/httpd.sh.  They are only allowed with bin/resin.  user-name and group-name are meaningless on Windows."));
            }
            System.out.println(L.l("running as {0} (uid={1})", (Object)user, String.valueOf(uid)));
        }
        Path pwd = CauchoSystem.getResinHome();
        if (user == null) {
            this.servletServer = new ServletServer(conf, node, pwd, this.serverId);
        }
        if (node.lookup("httpd-port") != null) {
            throw new ConfigException(L.l("httpd-port is no longer valid.  Use a <http ...> configuration instead."));
        }
        if (node.lookup("srun-port") != null) {
            throw new ConfigException(L.l("srun-port is no longer valid.  Use a <http ...> configuration instead."));
        }
        boolean port = false;
        this.shutdownWaitTime = node.getPeriod("shutdown-wait-time", 15000L);
        Iterator iter = node.select("server-listener");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            String className = subnode.getValue();
            Object listener = BeanUtil.createBean(subnode, null, null, className = subnode.getString("class-name", className));
            if (listener instanceof AbstractServerListener) {
                this.serverListeners.add(listener);
                continue;
            }
            throw new ConfigException(L.l("server-listener must extend AbstractServerListener."));
        }
        if (this.servletServer == null) {
            this.servletServer = new ServletServer(conf, node, pwd, this.serverId);
        }
        this.setServerData(node, this.servletServer);
        int srunIndex = this.servletServer.getSrunIndex();
        this.servletServer.addRandom(srunIndex);
        this.servletServer.addRandom(conf.getLastModified());
        this.servletServer.addRandom(conf.getParent().getLastModified());
        this.servletServer.addRandom(Version.FULL_VERSION);
        try {
            this.servletServer.addRandom(InetAddress.getLocalHost().toString());
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.servletServer.init();
        if (this.tcpServers.size() == 0) {
            this.addServers(node, serverSockets);
        }
        if (this.tcpServers.size() == 0) {
            if (this.serverId == null) {
                System.err.println(L.l("No default servers defined.  Use -server id to specify.\nAll <http>, <srun>, and <server> tags have an id, requiring a -server with a matching id."));
                System.exit(66);
            } else {
                System.err.println(L.l("No servers defined for -server `{0}'.\nNo <http>, <srun>, and <server> has a matching id.", this.serverId));
                System.exit(66);
            }
        }
        if (this.serverListeners != null) {
            ServerAdmin admin = this.servletServer.getServerAdmin();
            for (int i = 0; i < this.serverListeners.size(); ++i) {
                AbstractServerListener listener = (AbstractServerListener)this.serverListeners.get(i);
                listener.serverStart(new ServerEvent(admin));
            }
        }
        for (int i = 0; i < this.tcpServers.size(); ++i) {
            TcpServer tcpServer = (TcpServer)this.tcpServers.get(i);
            tcpServer.init(this.servletServer);
            this.servletServer.addTcpServer(tcpServer);
            try {
                QServerSocket ss = tcpServer.getServerSocket();
                this.servletServer.addRandom(ss.getLocalAddress().hashCode());
                this.servletServer.addRandom(ss.getLocalPort());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.initPing(node);
    }

    void setServerData(RegistryNode parentNode, ServletServer sockets) throws Exception {
        Iterator iter = parentNode.iterator();
        boolean portCount = false;
        int srunCount = 0;
        int srunIndex = -1;
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            if (node.getName().equals("srun") || node.getName().equals("srun-backup")) {
                ++srunCount;
            }
            if (this.serverId == null && node.getValue() != null || this.serverId != null && !this.serverId.equals(node.getValue())) continue;
            if (node.getName().equals("http") && node.lookup("ssl") == null) {
                int port = node.getELInt("port", 80, this.getEnv());
                String hostName = node.getELString("host", "localhost", this.getEnv());
                this.servletServer.setPort(port);
                this.servletServer.setHost(hostName);
                continue;
            }
            if (!node.getName().equals("srun") && !node.getName().equals("srun-backup")) continue;
            String serverName = node.getValue();
            if (srunIndex > 0) {
                throw Application.error(node, L.l("multiple <srun> need a -server id command-line argument"));
            }
            srunIndex = node.getInt("srun-index", srunCount) - 1;
            this.servletServer.setSrunIndex(srunIndex);
        }
    }

    int addServers(RegistryNode parentNode, ArrayList sockets) throws Exception {
        Iterator iter = parentNode.iterator();
        int portCount = 0;
        int srunCount = 0;
        int srunIndex = -1;
        while (iter.hasNext()) {
            QServerSocket ss;
            RegistryNode node = (RegistryNode)iter.next();
            if (this.serverId == null && node.getValue() != null || this.serverId != null && !this.serverId.equals(node.getValue())) continue;
            if (node.getName().equals("http")) {
                if (sockets != null) {
                    ss = (QServerSocket)sockets.get(portCount++);
                    this.addTcpServer("http", ss, node, HTTP_FACTORY);
                    continue;
                }
                this.addServer(this.tcpServers, node, this.serverId, HTTP_FACTORY, this.httpHost, this.httpPort, null);
                continue;
            }
            if (node.getName().equals("srun") || node.getName().equals("srun-backup")) {
                String serverName = node.getValue();
                if (srunIndex > 0) {
                    throw Application.error(node, L.l("multiple <srun> need a -server id command-line argument"));
                }
                srunIndex = node.getInt("srun-index", srunCount + 1) - 1;
                if (sockets != null) {
                    QServerSocket ss2 = (QServerSocket)sockets.get(portCount++);
                    this.addTcpServer("srun", ss2, node, SRUN_FACTORY);
                } else {
                    this.addServer(this.tcpServers, node, this.serverId, SRUN_FACTORY, this.srunHost, this.srunPort, null);
                }
                ++srunCount;
                continue;
            }
            if (!node.getName().equals("server")) continue;
            if (sockets != null) {
                ss = (QServerSocket)sockets.get(portCount++);
                this.addTcpServer("server", ss, node, null);
                continue;
            }
            this.addServer(this.tcpServers, node, this.serverId, null);
        }
        return srunIndex;
    }

    private void initPing(RegistryNode node) throws Exception {
        int count = 0;
        Iterator iter = node.select("ping");
        while (iter.hasNext()) {
            RegistryNode pingNode = (RegistryNode)iter.next();
            String className = "com.caucho.http.admin.PingThread";
            className = pingNode.getString("class-name", className);
            Object obj = BeanUtil.createBean(pingNode, this.servletServer.getPathVariableMap(), this.servletServer.getHome(), className);
            if (!(obj instanceof PingThread)) {
                throw Application.error(pingNode, L.l("`{0}' must extend PingThread.", className));
            }
            PingThread ping = (PingThread)obj;
            if (ping.getPingHost() == null) {
                ping.setPingHost(this.pingHost);
                ping.setPingPort(this.pingPort);
            }
            ping.setResinServer(this);
            ping.init();
            Thread thread = new Thread((Runnable)ping, "resin-ping-" + count++);
            thread.setDaemon(true);
            thread.start();
        }
    }

    void addServer(ArrayList tcpServers, RegistryNode node, String serverId, String factoryName) throws Exception {
        this.addServer(tcpServers, node, serverId, factoryName, null, 0, null);
    }

    void addServer(ArrayList tcpServers, RegistryNode node, String serverId, String factoryName, String defaultHost, int defaultPort, String name) throws Exception {
        QServerSocket qServerSocket;
        if (name == null) {
            name = node.getName();
        }
        name = node.getString("name", name);
        String serverName = node.getValue();
        RegistryNode parentNode = node.getParent();
        int listen = parentNode.getInt("listen", 100);
        listen = node.getInt("listen", listen);
        String host = node.getELString("host", defaultHost, this.getEnv());
        int port = node.getELInt("port", defaultPort, this.getEnv());
        if (name != null && name.equals("http") && this.pingHost == null) {
            this.pingHost = host;
            if (this.pingHost == null || this.pingHost.equals("*")) {
                this.pingHost = "localhost";
            }
            this.pingPort = port;
            if (this.pingPort <= 0) {
                this.pingPort = 80;
            }
        }
        if (port <= 0) {
            throw Application.error(node, L.l("`{0}' expects `{1}'", (Object)name, "port"));
        }
        String ssl = node.getString("ssl", null);
        if (ssl != null) {
            name = name + "s";
        }
        if (serverId != null) {
            name = name + " (" + serverId + ")";
        }
        if (ssl == null || ssl.equals("false")) {
            ServerSocket serverSocket = ResinServer.getServerSocket(name, node, host, port, listen);
            qServerSocket = new QServerSocketWrapper(serverSocket);
        } else if (ssl.equals("openssl")) {
            QSSLFactory factory = new QSSLFactory();
            factory.setCertificateFile(node.getString("certificate-file", null));
            factory.setKeyFile(node.getString("certificate-key-file", null));
            factory.setCertificateChainFile(node.getString("certificate-chain-file", null));
            factory.setCACertificatePath(node.getString("ca-certificate-path", null));
            factory.setCACertificateFile(node.getString("ca-certificate-file", null));
            factory.setCARevocationPath(node.getString("ca-revocation-path", null));
            factory.setCARevocationFile(node.getString("ca-revocation-file", null));
            String password = node.getString("key-store-password", null);
            password = node.getString("certificate-key-password", password);
            factory.setPassword(password);
            factory.setVerifyClient(node.getString("verify-client", null));
            if (host == null || host.equals("*")) {
                qServerSocket = factory.create(port);
                if (qServerSocket != null) {
                    System.out.println(name + " listening to *:" + port);
                }
            } else {
                InetAddress hostAddr = InetAddress.getByName(host);
                qServerSocket = factory.create(hostAddr, port);
                if (qServerSocket != null) {
                    System.out.println(name + " listening to " + host + ":" + port);
                }
            }
        } else {
            ServerSocket serverSocket = keyManagerClass != null ? SSLFactory.getServerSocket(name, node, host, port, listen) : OldSSLFactory.getServerSocket(name, node, host, port, listen);
            qServerSocket = new QServerSocketWrapper(serverSocket);
        }
        this.addTcpServer(name, qServerSocket, node, factoryName);
    }

    void addTcpServer(String name, QServerSocket ss, RegistryNode node, String factoryName) throws Exception {
        RegistryNode parentNode = node.getParent();
        if ((factoryName = node.getString("request-factory", factoryName)) == null) {
            throw Application.error(node, L.l("`{0}' expects `{1}'", (Object)name, "request-factory"));
        }
        Class<?> cl = Class.forName(factoryName);
        RequestFactory requestFactory = (RequestFactory)cl.newInstance();
        TcpServer tcpServer = new TcpServer(requestFactory, ss);
        tcpServer.setShutdownListener(this);
        String virtualHost = node.getString("virtual-host", null);
        tcpServer.setVirtualHost(virtualHost);
        int threadMax = parentNode.getInt("thread-max", 200);
        threadMax = node.getInt("thread-max", threadMax);
        tcpServer.setConnectionMax(threadMax);
        int threadAcceptMin = parentNode.getInt("thread-min", 5);
        threadAcceptMin = node.getInt("thread-min", threadAcceptMin);
        tcpServer.setThreadAcceptMin(threadAcceptMin);
        int threadAcceptMax = parentNode.getInt("thread-accept-max", 10);
        threadAcceptMax = node.getInt("thread-accept-max", threadAcceptMax);
        tcpServer.setThreadAcceptMax(threadAcceptMax);
        int threadKeepalive = parentNode.getInt("thread-keepalive", 100);
        threadKeepalive = node.getInt("thread-keepalive", threadKeepalive);
        tcpServer.setKeepaliveMax(threadKeepalive);
        boolean tcpNoDelay = parentNode.getBoolean("tcp-no-delay", true);
        tcpNoDelay = node.getBoolean("tcp-no-delay", tcpNoDelay);
        ss.setTcpNoDelay(tcpNoDelay);
        if (threadKeepalive + 1 > threadMax) {
            throw Application.error(node, "thread-max must exceed thread-keepalive");
        }
        long requestTimeout = parentNode.getPeriod("request-timeout", 65000L);
        if ((requestTimeout = node.getPeriod("request-timeout", requestTimeout)) >= 0L && requestTimeout < 2000L) {
            requestTimeout = 2000L;
        }
        tcpServer.setSocketTimeout(requestTimeout);
        long liveTime = parentNode.getPeriod("live-time", 10000L);
        liveTime = node.getPeriod("live-time", liveTime);
        if (liveTime >= 0L && liveTime < 1000L) {
            liveTime = 1000L;
        }
        if (liveTime + 1000L > requestTimeout) {
            RegistryNode timeoutNode = parentNode.lookup("request-timeout");
            RegistryNode liveNode = parentNode.lookup("live-time");
            if (liveNode != null) {
                throw Application.error(liveNode, L.l("live-time must be less than request-timeout"));
            }
            throw Application.error(timeoutNode, L.l("live-time must be less than request-timeout"));
        }
        boolean enableBusy = parentNode.getBoolean("enable-busy", true);
        enableBusy = node.getBoolean("enable-busy", enableBusy);
        tcpServer.setEnableBusy(enableBusy);
        int acceptBufferSize = parentNode.getInt("accept-buffer-size", 256);
        acceptBufferSize = node.getInt("accept-buffer-size", acceptBufferSize);
        tcpServer.setAcceptBufferSize(acceptBufferSize);
        long shutdownTime = parentNode.getPeriod("shutdown-wait-time", 15000L);
        shutdownTime = node.getPeriod("shutdown-wait-time", shutdownTime);
        tcpServer.setShutdownWaitTime(shutdownTime);
        this.tcpServers.add(tcpServer);
    }

    static void setSystemProperties(RegistryNode node) {
        Iterator iter = node.select("system-property");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            Iterator subiter = subnode.iterator();
            while (subiter.hasNext()) {
                RegistryNode prop = (RegistryNode)subiter.next();
                String key = prop.getName();
                String value = prop.getValue();
                if (dbg.canWrite()) {
                    dbg.log("-D" + key + "=" + value);
                }
                System.setProperty(key, value);
            }
        }
    }

    static void addSecurityProviders(RegistryNode node) throws Exception {
        Iterator iter = node.select("security-provider");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            Class<?> cl = Class.forName(subnode.getValue());
            Security.addProvider((Provider)cl.newInstance());
        }
    }

    static void setSecurityManager(RegistryNode node) throws Exception {
        if ((node = node.lookup("security-manager")) == null) {
            return;
        }
        String name = node.getValue();
        Class cl = name != null ? Class.forName(name) : (class$java$lang$SecurityManager == null ? (class$java$lang$SecurityManager = ResinServer.class$("java.lang.SecurityManager")) : class$java$lang$SecurityManager);
        CauchoSystem.getClassPath();
        SecurityManager manager = (SecurityManager)cl.newInstance();
        System.setSecurityManager(manager);
    }

    private static ServerSocket getServerSocket(String name, RegistryNode node, String host, int port, int listen) throws Exception {
        ServerSocket serverSocket = null;
        try {
            if (host == null || host.equals("*")) {
                serverSocket = new ServerSocket(port, listen);
                System.out.println(name + " listening to *:" + port);
            } else {
                InetAddress hostAddr = InetAddress.getByName(host);
                serverSocket = new ServerSocket(port, listen, hostAddr);
                System.out.println(name + " listening to " + host + ":" + port);
            }
        }
        catch (BindException e) {
            if (host == null) {
                System.out.println(name + " can't bind to *:" + port + ". Check for conflicting servers.");
            } else {
                InetAddress hostAddr = InetAddress.getByName(host);
                System.out.println(name + " can't bind to port " + host + ":" + port + ".");
                System.out.println("1) Check for conflicting servers.");
                System.out.println("2) Check that " + hostAddr + " is a valid interface for this machine.");
            }
            throw e;
        }
        return serverSocket;
    }

    public void waitForExit() {
        int socketExceptionCount = 0;
        while (!this.isClosed) {
            try {
                Thread.currentThread();
                Thread.sleep(10L);
                if (this.waitIn != null) {
                    int len;
                    while ((len = this.waitIn.read()) >= 0) {
                        socketExceptionCount = 0;
                    }
                    this.isClosed = true;
                } else {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedIOException e) {
                socketExceptionCount = 0;
            }
            catch (InterruptedException e) {
                socketExceptionCount = 0;
            }
            catch (SocketException e) {
                if (socketExceptionCount++ == 0) {
                    dbg.log(e);
                } else if (socketExceptionCount > 100) {
                    this.isClosed = true;
                }
            }
            catch (Throwable e) {
                dbg.log(e);
                this.isClosed = true;
            }
            for (int i = 0; i < this.tcpServers.size(); ++i) {
                TcpServer server = (TcpServer)this.tcpServers.get(i);
                if (!server.isDead()) continue;
                this.isClosed = true;
            }
        }
    }

    public void close() throws Exception {
        block17: {
            this.isClosed = true;
            if (this.tcpServers != null) {
                for (int i = 0; i < this.tcpServers.size(); ++i) {
                    TcpServer server = (TcpServer)this.tcpServers.get(i);
                    try {
                        server.close();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.tcpServers.clear();
            }
            try {
                ServletServer servletServer = this.servletServer;
                this.servletServer = null;
                if (servletServer == null) break block17;
                ServerAdmin admin = servletServer.getServerAdmin();
                try {
                    admin.closeTcp();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.serverListeners != null) {
                    for (int i = 0; i < this.serverListeners.size(); ++i) {
                        AbstractServerListener listener = (AbstractServerListener)this.serverListeners.get(i);
                        listener.beforeServerShutdown(new ServerEvent(admin));
                    }
                }
                int max = (int)(this.shutdownWaitTime / 1000L);
                if (this.shutdownWaitTime < 0L) {
                    max = Integer.MAX_VALUE;
                }
                for (int i = 0; i < max && admin.getActiveConnectionCount() != 0; ++i) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (servletServer != null) {
                    servletServer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.servletServer = null;
        if (dbg.canWrite()) {
            dbg.log("httpd shutdown");
        }
        if (this.mainThread != null) {
            this.mainThread.interrupt();
        }
        this.closeImpl();
    }

    protected void closeImpl() {
    }

    public void handleShutdown() {
        block2: {
            this.isClosed = true;
            try {
                this.close();
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block2;
                dbg.log(e);
            }
        }
    }

    private void doCompile(ServletServer server, ArrayList urls) throws Exception {
        HttpRequest request = this.compileShowOutput ? new HttpRequest(server) : new CompileRequest(server);
        for (int i = 0; i < urls.size(); ++i) {
            String line;
            String url = (String)urls.get(i);
            if (!url.startsWith("/") && url.indexOf(58) < 0) {
                url = "/" + url;
            }
            if (url.startsWith("/") && this.compileHost != null) {
                url = "http://" + this.compileHost + url;
            }
            if (!this.compileShowOutput && url.indexOf(63) < 0) {
                url = url + "?jsp_precompile";
            }
            System.out.println("compiling " + url);
            ReadStream rs = Vfs.openString("GET " + url + " HTTP/1.0");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            WriteStream ws = Vfs.openWrite(os);
            StreamConnection conn = new StreamConnection(rs, ws);
            conn.setLocalAddress(InetAddress.getByName("127.0.0.1"));
            conn.setRemoteAddress(InetAddress.getByName("127.0.0.1"));
            conn.setLocalPort(8080);
            conn.setRemotePort(32732);
            rs.setDisableClose(true);
            ws.setDisableClose(true);
            request.handleConnection(conn);
            rs.setDisableClose(false);
            ws.setDisableClose(false);
            ws.close();
            rs.close();
            rs = Vfs.openString(os.toString());
            String status = rs.readLine();
            while ((line = rs.readLine()) != null && line.length() > 0) {
            }
            boolean isOkay = status.startsWith("HTTP/1.0 200");
            if (this.compileShowOutput || !isOkay) {
                rs.writeToStream(System.out);
            }
            rs.close();
            if (isOkay) continue;
            System.out.println("bad response for " + url);
            server.close();
            System.exit(1);
        }
        System.out.println("successful compilation");
        server.close();
        System.exit(0);
    }

    private static void usage() {
        System.err.println(L.l("usage: HttpServer [-conf resin.conf]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv, boolean allowHttp) throws Exception {
        try {
            ResinServer server = new ResinServer(argv, allowHttp);
            server.init(null);
            server.waitForExit();
            System.err.println(L.l("closing server"));
            server.close();
            System.exit(0);
        }
        catch (BindException e) {
            System.exit(67);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace(System.err);
            }
            finally {
                System.exit(0);
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        ResinServer.main(argv, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        pingElements = new HashMap();
        pingElements.put("url", "url");
        pingElements.put("sleep-time", "sleep-time");
        pingElements.put("retry-count", "retry-count");
        pingElements.put("retry-time", "retry-time");
        pingElements.put("socket-timeout", "socket-timeout");
        try {
            keyManagerClass = Class.forName("javax.net.ssl.KeyManagerFactory");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

