/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.http.session.SessionManager;
import com.caucho.security.SecurityContext;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CacheInvocation;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletOutputStream;
import com.caucho.server.http.Request;
import com.caucho.server.http.ResponseStream;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.HTTPUtil;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.RuntimeExceptionWrapper;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public abstract class Response
implements CauchoResponse {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    static L10N L = new L10N("com/caucho/server/http/messages");
    static byte[] msiePadding;
    static HashMap errors;
    protected AbstractRequest originalRequest;
    protected AbstractRequest request;
    protected int statusCode;
    protected String statusMessage;
    protected String contentType;
    protected String contentPrefix;
    protected String charEncoding;
    protected String filter;
    protected ArrayList headerKeys = new ArrayList();
    protected ArrayList headerValues = new ArrayList();
    protected ArrayList cookiesOut = new ArrayList();
    private ResponseStream responseStream;
    private final WriteStream originalStream;
    protected WriteStream rawStream;
    private WriteStream s;
    private QServletOutputStream os;
    boolean headersWritten;
    protected QDate calendar = new QDate();
    protected CharBuffer cb = new CharBuffer();
    private String sessionId;
    protected boolean allowKeepalive;
    private Locale locale;
    protected boolean disableHeaders;
    protected boolean disableCaching;
    protected long contentLength;
    protected boolean isChaining;
    protected boolean isClosed;
    protected boolean hasSentLog;
    protected boolean hasWriter;
    protected boolean hasOutputStream;
    protected boolean hasMsieHack;
    private CacheInvocation cacheInvocation;
    private CacheInvocation.CacheEntry cacheEntry;
    private WriteStream cacheStream;
    protected boolean isNoCache;
    protected boolean allowCache;
    private boolean isPrivateCache;
    private boolean hasCacheControl;
    protected boolean isTopCache;
    protected boolean forbidForward;
    protected boolean hasError;
    private final TempBuffer tempBuffer = TempBuffer.allocate();

    protected Response() {
        this.os = new QServletOutputStream();
        this.responseStream = new ResponseStream();
        this.originalStream = this.s = new WriteStream();
        this.s.setReuseBuffer(true);
    }

    protected Response(AbstractRequest request) {
        this.request = request;
        this.originalRequest = request;
        this.os = new QServletOutputStream();
        this.responseStream = new ResponseStream();
        this.originalStream = this.s = new WriteStream();
        this.s.setReuseBuffer(true);
    }

    public void setIgnoreClientDisconnect(boolean ignore) {
        this.responseStream.setIgnoreClientDisconnect(ignore);
    }

    void init(WriteStream stream) {
        this.rawStream = stream;
        this.responseStream.init(this, stream);
        this.s = this.originalStream;
        this.s.init(this.responseStream);
        this.os.init(this.s);
    }

    protected void init(AbstractRequest request, WriteStream stream) {
        this.rawStream = stream;
        this.request = request;
        this.originalRequest = request;
        this.responseStream.init(this, stream);
        this.s.init(this.responseStream);
    }

    AbstractRequest getRequest() {
        return this.request;
    }

    void setRequest(AbstractRequest req) {
        this.request = req;
    }

    AbstractRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public void close() throws IOException {
    }

    void start() throws IOException {
        this.statusCode = 200;
        this.statusMessage = "OK";
        this.hasMsieHack = false;
        this.headerKeys.clear();
        this.headerValues.clear();
        this.cookiesOut.clear();
        this.headersWritten = false;
        this.charEncoding = null;
        this.contentType = null;
        this.filter = null;
        this.contentPrefix = null;
        this.locale = null;
        this.s.init(this.responseStream);
        this.s.setLocale(null);
        this.s.setEncoding(null);
        this.allowKeepalive = true;
        this.contentLength = -1L;
        this.disableHeaders = false;
        this.disableCaching = false;
        this.isChaining = false;
        this.isClosed = false;
        this.hasSentLog = false;
        this.hasWriter = false;
        this.hasOutputStream = false;
        this.cacheInvocation = null;
        this.cacheEntry = null;
        this.cacheStream = null;
        this.isNoCache = false;
        this.allowCache = true;
        this.isPrivateCache = false;
        this.hasCacheControl = false;
        this.isTopCache = false;
        this.sessionId = null;
        this.forbidForward = false;
        this.responseStream.start();
    }

    public void setHead() {
        this.responseStream.setHead();
    }

    public void setForbidForward(boolean forbid) {
        this.forbidForward = forbid;
    }

    public boolean getForbidForward() {
        return this.forbidForward;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public boolean hasError() {
        return this.hasError;
    }

    void setCacheEntry(CacheInvocation.CacheEntry entry) {
        this.cacheEntry = entry;
    }

    void setCacheInvocation(CacheInvocation cacheInvocation) {
        this.cacheInvocation = cacheInvocation;
    }

    void setTopCache(boolean isTopCache) {
        this.isTopCache = isTopCache;
    }

    protected final ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public String getChain() {
        if (this.contentPrefix == null || this.filter == "null") {
            return null;
        }
        if (this.filter != null) {
            return this.filter;
        }
        this.filter = this.request.getApplication().getChain(this.contentPrefix);
        if (this.filter == null) {
            this.filter = "null";
            return null;
        }
        return this.filter;
    }

    String getContentType() {
        return this.contentType;
    }

    void flushChaining() {
        this.responseStream.setFlush(true);
    }

    public TempBuffer startChaining() throws IOException {
        this.responseStream.setFlush(false);
        if (this.os != null) {
            this.os.flush();
        }
        if (this.s != null) {
            this.s.flush();
        }
        this.statusCode = 200;
        this.statusMessage = "OK";
        this.charEncoding = null;
        this.contentLength = -1L;
        this.contentType = null;
        this.filter = null;
        this.contentPrefix = null;
        this.locale = null;
        this.s.setLocale(null);
        this.s.setEncoding(null);
        TempBuffer head = this.responseStream.startChaining();
        this.disableHeaders = false;
        return head;
    }

    public void setStatus(int code, String message) {
        if (code < 0) {
            code = 500;
        }
        if (message == null) {
            if (code == 200) {
                message = "OK";
            } else if (code == 304) {
                message = "Not Modified";
            } else if (message == null && (message = (String)errors.get(String.valueOf(code))) == null) {
                message = L.l("Internal Server Error");
            }
        }
        this.statusCode = code;
        this.statusMessage = message;
    }

    public void setStatus(int code) {
        this.setStatus(code, null);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void sendError(int code, String value) throws IOException {
        if (code == 304 && this.cacheEntry != null) {
            this.setStatus(code, value);
            if (this.handleNotModified(this.isTopCache)) {
                return;
            }
        }
        this.clearBuffer();
        if (code != 304) {
            this.killCache();
        }
        this.setStatus(code, value);
        try {
            if (this.handleErrorStatus() || code == 304 || code == 204) {
                this.finish(false);
                return;
            }
            this.setContentType("text/html");
            WriteStream s = this.getStream();
            if (!this.isCommitted()) {
                s.print("<title>");
                s.print(code);
                s.print(" ");
                s.print(this.statusMessage);
                s.println("</title>");
            }
            s.print("<h1>");
            s.print(code);
            s.print(" ");
            s.print(this.statusMessage);
            s.println("</h1>");
            if (code == 404) {
                s.println(L.l("{0} was not found on this server.", HTTPUtil.encodeString(this.request.getPageURI())));
            }
            if (!CauchoSystem.isTesting()) {
                s.println("<p /><hr />");
                s.println("<small>");
                s.println(Version.FULL_VERSION);
                s.println("</small>");
            }
        }
        catch (Exception e) {
            try {
                if (this.request instanceof Request) {
                    ((Request)this.request).sendServletError(e);
                } else {
                    dbg.log(e);
                }
            }
            catch (Exception e1) {
                dbg.log(e1);
            }
        }
        this.closeConnection();
        this.finish(false);
    }

    private boolean handleErrorStatus() throws ServletException, IOException {
        if (this.statusCode == 200 || this.statusCode == 302 || this.statusCode == 304) {
            return false;
        }
        if (this.request.getRequestDepth(0) > 16) {
            return false;
        }
        Application app = this.request.getApplication();
        String location = app != null ? app.getErrorPage(this.statusCode) : null;
        this.killCache();
        if (location == null && app != null) {
            location = app.getErrorPage(0);
        }
        if (location != null && !location.equals(this.request.getRequestURI())) {
            if (!this.headersWritten) {
                this.contentLength = -1L;
            }
            this.responseStream.clearHeaders();
            this.request.setAttribute(AbstractRequest.STATUS_CODE, new Integer(this.statusCode));
            this.request.setAttribute(AbstractRequest.MESSAGE, this.statusMessage);
            this.request.setAttribute(AbstractRequest.ERROR_URI, this.request.getRequestURI());
            if (this.request.invocation != null) {
                this.request.setAttribute(AbstractRequest.SERVLET_NAME, this.request.invocation.getServletName());
            }
            QRequestDispatcher disp = (QRequestDispatcher)app.getRequestDispatcher(location);
            disp.forward(this.request, this, "GET", false);
            this.finish(false);
            return true;
        }
        return false;
    }

    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    public void sendRedirect(String url) throws IOException {
        if (url == null) {
            throw new NullPointerException();
        }
        this.resetBuffer();
        if (this.responseStream.isCommitted()) {
            throw new IllegalStateException(L.l("Can't sendRedirect() after data has committed to the client."));
        }
        this.setStatus(302);
        String path = this.getAbsolutePath(url);
        this.setHeader("Location", path);
        WriteStream os = this.getStream();
        os.println("The URL has moved <a href=\"" + path + "\">here</a>");
        this.finish(false);
    }

    public void switchToRaw() throws IOException {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    public WriteStream getRawOutput() throws IOException {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    private String getAbsolutePath(String path) {
        int slash = path.indexOf(47);
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (ch == ':') {
                return path;
            }
            if ((ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) break;
        }
        String host = this.request.getHeader("host");
        int port = this.request.getServerPort();
        Application app = this.request.getApplication();
        String hostPrefix = app.getVirtualHost().getCanonicalURL();
        if (hostPrefix == null) {
            if (host != null) {
                hostPrefix = this.request.getScheme() + "://" + host;
            } else {
                hostPrefix = this.request.getScheme() + "://" + this.request.getServerName();
                if (port != 0 && port != 80 && port != 443) {
                    hostPrefix = hostPrefix + ":" + port;
                }
            }
        }
        if (slash == 0) {
            return hostPrefix + path;
        }
        String uri = this.request.getRequestURI();
        String queryString = null;
        int p = path.indexOf(63);
        if (p > 0) {
            queryString = path.substring(p + 1);
            path = path.substring(0, p);
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = uri.substring(0, p + 1) + path;
        }
        try {
            if (queryString != null) {
                return hostPrefix + Invocation.normalizeUri(path) + '?' + queryString;
            }
            return hostPrefix + Invocation.normalizeUri(path);
        }
        catch (IOException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    public boolean containsHeader(String name) {
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            String oldKey = (String)this.headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return true;
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this.contentType != null;
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this.contentLength >= 0L;
        }
        return false;
    }

    public String getHeader(String name) {
        for (int i = 0; i < this.headerKeys.size(); ++i) {
            String oldKey = (String)this.headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return (String)this.headerValues.get(i);
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this.contentType;
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this.contentLength >= 0L ? String.valueOf(this.contentLength) : null;
        }
        return null;
    }

    public void setHeader(String key, String value) {
        String oldKey;
        int i;
        if (this.disableHeaders) {
            return;
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (key.equalsIgnoreCase("content-type")) {
            this.setContentType(value);
            return;
        }
        if (key.equalsIgnoreCase("date")) {
            return;
        }
        if (key.equalsIgnoreCase("content-length")) {
            this.contentLength = Long.parseLong(value);
            return;
        }
        if (key.equalsIgnoreCase("cache-control") && !value.equalsIgnoreCase("x-anonymous")) {
            this.hasCacheControl = true;
        }
        for (i = 0; i < this.headerKeys.size() && !(oldKey = (String)this.headerKeys.get(i)).equalsIgnoreCase(key); ++i) {
        }
        if (i == this.headerKeys.size()) {
            this.headerKeys.add(key);
            this.headerValues.add(value);
        } else {
            this.headerValues.set(i, value);
        }
    }

    public void addHeader(String key, String value) {
        if (this.disableHeaders) {
            return;
        }
        if (key.equalsIgnoreCase("date")) {
            return;
        }
        if (key.equalsIgnoreCase("content-length")) {
            this.contentLength = Long.parseLong(value);
            return;
        }
        this.headerKeys.add(key);
        this.headerValues.add(value);
    }

    public void removeHeader(String key) {
        if (this.disableHeaders) {
            return;
        }
        for (int i = this.headerKeys.size() - 1; i >= 0; --i) {
            String oldKey = (String)this.headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            this.headerKeys.remove(i);
            this.headerValues.remove(i);
            return;
        }
    }

    public void setIntHeader(String name, int value) {
        this.cb.clear();
        this.cb.append(value);
        this.setHeader(name, this.cb.toString());
    }

    public void addIntHeader(String key, int value) {
        this.cb.clear();
        this.cb.append(value);
        this.addHeader(key, this.cb.toString());
    }

    public void setDateHeader(String name, long value) {
        this.calendar.calculate(value, false);
        this.setHeader(name, this.calendar.toString());
    }

    public void addDateHeader(String key, long value) {
        this.calendar.calculate(value, false);
        this.addHeader(key, this.calendar.toString());
    }

    public void setContentLength(int length) {
        if (!this.headersWritten) {
            this.contentLength = length;
        }
    }

    public long getContentLengthHeader() {
        return this.contentLength;
    }

    public void setContentType(String value) {
        int i;
        if (this.disableHeaders || value == null) {
            return;
        }
        if (value == "text/html" || value.equals("text/html")) {
            this.contentPrefix = this.contentType = "text/html";
            if (this.charEncoding != null) {
                this.contentType = this.contentType + "; charset=" + this.charEncoding;
            }
            return;
        }
        if (this.charEncoding != null && value.indexOf("charset=") < 0) {
            this.contentType = this.contentType + "; charset=" + this.charEncoding;
        }
        this.contentType = value;
        int length = value.length();
        for (i = 0; i < length && value.charAt(i) != ';' && !Character.isWhitespace(value.charAt(i)); ++i) {
        }
        this.contentPrefix = i < length ? this.contentType.substring(0, i) : this.contentType;
        while ((i = value.indexOf(59, i)) > 0) {
            ++i;
            while (i < length && XmlChar.isWhitespace(value.charAt(i))) {
                ++i;
            }
            int j = value.indexOf(61, i);
            if (j < 0) break;
            if (value.substring(i, j).equals("charset")) {
                String encoding;
                ++j;
                while (j < length && XmlChar.isWhitespace(value.charAt(j))) {
                    ++j;
                }
                if (j < length && value.charAt(j) == '\"') {
                    int k = ++j;
                    while (j < length && value.charAt(j) != '\"') {
                        ++j;
                    }
                    encoding = value.substring(k, j);
                } else {
                    char ch;
                    int k = j;
                    k = j;
                    while (j < length && !XmlChar.isWhitespace(ch = value.charAt(j)) && ch != ';') {
                        ++j;
                    }
                    encoding = value.substring(k, j);
                }
                this.charEncoding = encoding;
                try {
                    if (this.charEncoding == null) break;
                    this.s.setEncoding(this.charEncoding);
                }
                catch (IOException e) {}
                break;
            }
            i = j;
        }
    }

    public String getCharacterEncoding() {
        return this.charEncoding == null ? "ISO-8859-1" : this.charEncoding;
    }

    String getRealCharacterEncoding() {
        return this.charEncoding;
    }

    public void addCookie(Cookie cookie) {
        this.request.setHasCookie();
        if (this.disableHeaders) {
            return;
        }
        if (cookie == null) {
            return;
        }
        this.cookiesOut.add(cookie);
    }

    public Cookie getCookie(String name) {
        if (this.cookiesOut == null) {
            return null;
        }
        for (int i = this.cookiesOut.size() - 1; i >= 0; --i) {
            Cookie cookie = (Cookie)this.cookiesOut.get(i);
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public ArrayList getCookies() {
        return this.cookiesOut;
    }

    public void setSessionId(String id) {
        this.sessionId = id;
    }

    public WriteStream getStream() {
        return this.s;
    }

    public void setStream(WriteStream os) {
        this.s = os;
        this.os.init(this.s);
    }

    public WriteStream getOriginalStream() {
        return this.originalStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.os.init(this.s);
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        return this.s.getPrintWriter();
    }

    public String encodeURL(String string) {
        if (this.request.isRequestedSessionIdFromCookie()) {
            return string;
        }
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return string;
        }
        Application app = this.request.getApplication();
        if (!app.getSessionManager().enableSessionUrls()) {
            return string;
        }
        this.cb.clear();
        ServletServer server = app.getServer();
        String altPrefix = server.getAlternateSessionPrefix();
        if (altPrefix == null) {
            int p = string.indexOf(63);
            if (p >= 0) {
                this.cb.append(string, 0, p);
                this.cb.append(app.getServer().getSessionPrefix());
                this.cb.append(session.getId());
                this.cb.append(string, p, string.length() - p);
            } else {
                p = string.indexOf(35);
                if (p >= 0) {
                    this.cb.append(string, 0, p);
                    this.cb.append(app.getServer().getSessionPrefix());
                    this.cb.append(session.getId());
                    this.cb.append(string, p, string.length() - p);
                } else {
                    this.cb.append(string);
                    this.cb.append(app.getServer().getSessionPrefix());
                    this.cb.append(session.getId());
                }
            }
        } else {
            int p = string.indexOf("://");
            if (p < 0) {
                this.cb.append(altPrefix);
                this.cb.append(session.getId());
                if (!string.startsWith("/")) {
                    this.cb.append(this.request.getContextPath());
                    this.cb.append('/');
                }
                this.cb.append(string);
            } else {
                Object queryString = null;
                int q = string.indexOf(47, p + 3);
                if (q < 0) {
                    this.cb.append(string);
                    this.cb.append(altPrefix);
                    this.cb.append(session.getId());
                } else {
                    this.cb.append(string.substring(0, q));
                    this.cb.append(altPrefix);
                    this.cb.append(session.getId());
                    this.cb.append(string.substring(q));
                }
            }
        }
        return this.cb.toString();
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void setBufferSize(int size) {
        this.responseStream.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.responseStream.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.s.flush();
        this.responseStream.flushBuffer(false);
    }

    public void setDisableAutoFlush(boolean disable) {
        this.responseStream.setDisableAutoFlush(disable);
    }

    public boolean isCommitted() {
        return this.responseStream.isCommitted();
    }

    public void reset() {
        this.reset(false);
    }

    public void resetBuffer() {
        this.s.clearWrite();
        this.responseStream.clearBuffer();
    }

    void reset(boolean force) {
        this.s.clearWrite();
        this.responseStream.clear();
        if (!force && this.responseStream.isCommitted()) {
            throw new IllegalStateException(L.l("response cannot be reset() after committed"));
        }
        this.statusCode = 200;
        this.statusMessage = "OK";
        this.headerKeys.clear();
        this.headerValues.clear();
        this.contentLength = -1L;
        this.isNoCache = false;
        this.isPrivateCache = false;
        this.charEncoding = null;
        this.locale = null;
        try {
            this.s.setLocale(null);
            this.s.setEncoding(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearBuffer() {
        this.s.clearWrite();
        this.responseStream.clearBuffer();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        try {
            this.s.setLocale(locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.charEncoding == null) {
            this.charEncoding = Encoding.getMimeName(locale);
            try {
                if (this.charEncoding != null) {
                    this.s.setEncoding(this.charEncoding);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.contentType != null && this.contentType.indexOf("charset=") < 0) {
                this.contentType = this.contentType + "; charset=" + this.charEncoding;
            }
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append(locale.getLanguage());
        if (locale.getCountry() != null && !"".equals(locale.getCountry())) {
            cb.append("-");
            cb.append(locale.getCountry());
            if (locale.getVariant() != null && !"".equals(locale.getVariant())) {
                cb.append("-");
                cb.append(locale.getVariant());
            }
        }
        this.setHeader("Content-Language", cb.close());
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public int getRemaining() {
        return this.responseStream.getRemaining() + this.s.getRemaining();
    }

    public int getContentLength() {
        return this.responseStream.getContentLength();
    }

    void closeConnection() {
        this.allowKeepalive = false;
    }

    boolean allowKeepalive() {
        return this.allowKeepalive;
    }

    public boolean disableHeaders(boolean disable) {
        boolean old = this.disableHeaders;
        this.disableHeaders = disable;
        return old;
    }

    public boolean disableCaching(boolean disable) {
        boolean old = this.disableCaching;
        this.disableCaching = disable;
        return old;
    }

    protected boolean writeHeaders(WriteStream os, int length) throws IOException {
        String userAgent;
        if (this.statusCode == 200 && this.getChain() != null) {
            this.initChaining();
            return false;
        }
        this.headersWritten = true;
        boolean canCache = false;
        if (this.statusCode == 200 && !this.disableCaching && this.getBufferSize() > 0) {
            canCache = this.startCaching(this.headerKeys, this.headerValues, this.contentType, this.charEncoding);
        } else if (this.statusCode != 200 && this.statusCode != 304 && this.statusCode != 302 && length < 512 && (this.contentType == null || this.contentType.startsWith("text/html")) && (userAgent = this.request.getHeader("User-Agent")) != null && userAgent.indexOf("MSIE") >= 0) {
            this.hasMsieHack = true;
            length = -1;
            this.contentLength = -1L;
        }
        if (!canCache && this.statusCode == 200 && this.request.getMethodBuffer() != null && this.request.getMethodBuffer().matches("HEAD")) {
            length = -1;
            this.responseStream.setHead();
        }
        if (this.sessionId != null) {
            long maxAge;
            Application app = this.request.getApplication();
            SessionManager manager = app.getSessionManager();
            Cookie cookie = new Cookie(manager.getCookieName(), this.sessionId);
            cookie.setVersion(manager.getCookieVersion());
            String domain = manager.getCookieDomain();
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if ((maxAge = manager.getCookieMaxAge()) > 1000L) {
                cookie.setMaxAge((int)(maxAge / 1000L));
            }
            cookie.setPath("/");
            this.addCookie(cookie);
        }
        return this.writeHeadersInt(os, length);
    }

    boolean startCaching(ArrayList keys, ArrayList values, String contentType, String charEncoding) {
        if (this.cacheInvocation == null) {
            return false;
        }
        this.cacheStream = this.cacheInvocation.startCaching(this.originalRequest, this, keys, values, contentType, charEncoding, this.contentLength);
        if (this.cacheStream != null) {
            this.responseStream.setCache(this.cacheStream);
        }
        return this.cacheStream != null;
    }

    private boolean handleNotModified(boolean isTop) throws IOException {
        if (this.statusCode == 304 && this.cacheEntry != null) {
            if (this.responseStream.isCommitted()) {
                return false;
            }
            this.responseStream.isClosed = false;
            this.isClosed = false;
            if (this.cacheInvocation != null && this.cacheInvocation.fillFromCache(this.originalRequest, this, this.cacheEntry, isTop)) {
                this.cacheEntry.updateExpiresDate();
                this.cacheInvocation = null;
                this.cacheEntry = null;
                this.finish(false);
                return true;
            }
        }
        return false;
    }

    protected abstract boolean writeHeadersInt(WriteStream var1, int var2) throws IOException;

    protected void writeHeadFinish(WriteStream os, int length) throws IOException {
    }

    void setPrivateCache(boolean isPrivate) {
        this.isPrivateCache = isPrivate;
    }

    protected boolean isPrivateCache() {
        return !this.hasCacheControl && this.isPrivateCache;
    }

    public void setNoCache(boolean isNoCache) {
        this.isNoCache = isNoCache;
    }

    boolean isNoCache() {
        return this.isNoCache;
    }

    public void killCache() {
        this.allowCache = false;
        this.setNoCache(true);
    }

    public boolean fillCookie(CharBuffer cb, Cookie cookie, long date, int version) {
        cb.clear();
        cb.append(cookie.getName());
        if (version > 0) {
            cb.append("=\"");
            cb.append(cookie.getValue());
            cb.append("\"");
        } else {
            cb.append("=");
            cb.append(cookie.getValue());
        }
        if (cookie.getDomain() != null && !cookie.getDomain().equals("")) {
            if (version > 0) {
                cb.append("; Domain=");
                cb.append('\"');
                cb.append(cookie.getDomain());
                cb.append('\"');
            } else {
                cb.append("; domain=");
                cb.append(cookie.getDomain());
            }
        }
        if (cookie.getPath() != null && !cookie.getPath().equals("")) {
            if (version > 0) {
                cb.append("; Path=");
                cb.append('\"');
                cb.append(cookie.getPath());
                cb.append('\"');
            } else {
                cb.append("; path=");
                cb.append(cookie.getPath());
            }
        }
        if (cookie.getSecure()) {
            if (version > 0) {
                cb.append("; Secure");
            } else {
                cb.append("; secure");
            }
        }
        if (version > 0) {
            if (cookie.getMaxAge() >= 0) {
                cb.append("; Max-Age=");
                cb.append(cookie.getMaxAge());
            }
            cb.append("; Version=");
            cb.append(version);
            if (cookie.getComment() != null) {
                cb.append("; Comment=\"");
                cb.append(cookie.getComment());
                cb.append("\"");
            }
        } else if (cookie.getMaxAge() == 0) {
            cb.append("; expires=Thu, 01-Dec-1994 16:00:00 GMT");
        } else if (cookie.getMaxAge() >= 0) {
            this.calendar.calculate(date + 1000L * (long)cookie.getMaxAge(), false);
            cb.append("; expires=");
            cb.append(this.calendar.format("%a, %d-%b-%Y %H:%M:%S GMT"));
        }
        return true;
    }

    protected void initChaining() {
        this.isChaining = true;
        this.contentLength = -1L;
        this.responseStream.setFlush(false);
    }

    void killChaining() {
        this.isChaining = false;
        this.responseStream.setFlush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish(boolean flush) throws IOException {
        block35: {
            block32: {
                block34: {
                    block31: {
                        block29: {
                            block30: {
                                invocation = this.request.getInvocation();
                                try {
                                    if (this.isClosed) {
                                        var5_3 = null;
                                        if (!this.request.isTop()) break block29;
                                        break block30;
                                    }
                                    this.isClosed = true;
                                    if (this.statusCode == 304 && this.cacheEntry != null && this.handleNotModified(this.isTopCache)) {
                                        break block31;
                                    }
                                    this.responseStream.setFlush(false);
                                    if (this.os != null) {
                                        this.os.flush();
                                    }
                                    if (this.s != null) {
                                        this.s.flush();
                                        this.s.close();
                                    }
                                    this.responseStream.setFlush(true);
                                    this.responseStream.finish(flush);
                                    if (this.contentLength < 0L && this.responseStream.isHead()) {
                                        this.writeHeadFinish(this.rawStream, this.responseStream.getContentLength());
                                    }
                                    if (this.request instanceof Request) {
                                        ((Request)this.request).skip();
                                    }
                                    if (this.cacheStream != null && this.cacheInvocation != null) {
                                        this.cacheStream = null;
                                        cache = this.cacheInvocation;
                                        this.cacheInvocation = null;
                                        cache.finishCaching(this.statusCode == 200 && this.allowCache != false);
                                    }
                                    break block32;
                                }
                                catch (Throwable var4_20) {
                                    block33: {
                                        var5_6 = null;
                                        if (this.request.isTop()) {
                                            SecurityContext.setProvider(null);
                                            if (!this.hasSentLog) {
                                                this.hasSentLog = true;
                                                req = (Request)this.request;
                                                if (invocation != null) {
                                                    app = invocation.getApplication();
                                                    try {
                                                        if (app != null) {
                                                            app.logAccess(req, this, app);
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        if (app == null) break block33;
                                                        app.log(String.valueOf(e), e);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    this.request.finish();
                                    throw var4_20;
                                }
                            }
                            SecurityContext.setProvider(null);
                            if (!this.hasSentLog) {
                                this.hasSentLog = true;
                                req = (Request)this.request;
                                if (invocation != null) {
                                    app = invocation.getApplication();
                                    ** try [egrp 1[TRYBLOCK] [4 : 285->303)] { 
lbl59:
                                    // 1 sources

                                    if (app != null) {
                                        app.logAccess(req, this, app);
                                    }
                                    break block29;
lbl62:
                                    // 1 sources

                                    catch (IOException e) {
                                        if (app == null) break block29;
                                        app.log(String.valueOf(e), e);
                                    }
                                }
                            }
                        }
                        this.request.finish();
                        return;
                    }
                    var5_4 = null;
                    if (this.request.isTop()) {
                        SecurityContext.setProvider(null);
                        if (!this.hasSentLog) {
                            this.hasSentLog = true;
                            req = (Request)this.request;
                            if (invocation != null) {
                                app = invocation.getApplication();
                                ** try [egrp 1[TRYBLOCK] [4 : 285->303)] { 
lbl78:
                                // 1 sources

                                if (app != null) {
                                    app.logAccess(req, this, app);
                                }
                                break block34;
lbl81:
                                // 1 sources

                                catch (IOException e) {
                                    if (app == null) break block34;
                                    app.log(String.valueOf(e), e);
                                }
                            }
                        }
                    }
                }
                this.request.finish();
                return;
            }
            var5_5 = null;
            if (this.request.isTop()) {
                SecurityContext.setProvider(null);
                if (!this.hasSentLog) {
                    this.hasSentLog = true;
                    req = (Request)this.request;
                    if (invocation != null) {
                        app = invocation.getApplication();
                        ** try [egrp 1[TRYBLOCK] [4 : 285->303)] { 
lbl97:
                        // 1 sources

                        if (app != null) {
                            app.logAccess(req, this, app);
                        }
                        break block35;
lbl100:
                        // 1 sources

                        catch (IOException e) {
                            if (app == null) break block35;
                            app.log(String.valueOf(e), e);
                        }
                    }
                }
            }
        }
        this.request.finish();
    }

    void free() {
        this.request = null;
        this.originalRequest = null;
        this.cacheInvocation = null;
        this.cacheEntry = null;
    }

    TempBuffer getBuffer() {
        return this.tempBuffer;
    }

    QDate getCalendar() {
        return this.calendar;
    }

    static {
        errors = new HashMap();
        errors.put("100", "Continue");
        errors.put("101", "Switching Protocols");
        errors.put("200", "OK");
        errors.put("201", "Created");
        errors.put("202", "Accepted");
        errors.put("203", "Non-Authoritative Information");
        errors.put("204", "No Content");
        errors.put("205", "Reset Content");
        errors.put("206", "Partial Content");
        errors.put("300", "Multiple Choices");
        errors.put("301", "Moved Permanently");
        errors.put("302", "Found");
        errors.put("303", "See Other");
        errors.put("304", "Not Modified");
        errors.put("305", "Use Proxy");
        errors.put("307", "Temporary Redirect");
        errors.put("400", "Bad Request");
        errors.put("401", "Unauthorized");
        errors.put("402", "Payment Required");
        errors.put("403", "Forbidden");
        errors.put("404", "Not Found");
        errors.put("405", "Method Not Allowed");
        errors.put("406", "Not Acceptable");
        errors.put("407", "Proxy Authentication Required");
        errors.put("408", "Request Timeout");
        errors.put("409", "Conflict");
        errors.put("410", "Gone");
        errors.put("411", "Length Required");
        errors.put("412", "Precondition Failed");
        errors.put("413", "Request Entity Too Large");
        errors.put("414", "Request-URI Too Long");
        errors.put("415", "Unsupported Media Type");
        errors.put("416", "Requested Range Not Satisfiable");
        errors.put("417", "Expectation Failed");
        errors.put("500", "Internal Server Error");
        errors.put("501", "Not Implemented");
        errors.put("502", "Bad Gateway");
        errors.put("503", "Service Unavailable");
        errors.put("504", "Gateway Timeout");
        errors.put("505", "Http Version Not Supported");
        msiePadding = "\n\n\n\n<!--\n   - Unfortunately, Microsoft has added a clever new\n   - \"feature\" to Internet Explorer.  If the text in\n   - an error's message is \"too small\", specifically\n   - less than 512 bytes, Internet Explorer returns\n   - its own error message.  Yes, you can turn that\n   - off, but *surprise* it's pretty tricky to find\n   - buried as a switch called \"smart error\n   - messages\"  That means, of course, that many of\n   - Resin's error messages are censored by default.\n   - And, of course, you'll be shocked to learn that\n   - IIS always returns error messages that are long\n   - enough to make Internet Explorer happy.  The\n   - workaround is pretty simple: pad the error\n   - message with a big comment to push it over the\n   - five hundred and twelve byte minimum.  Of course,\n   - that's exactly what you're reading right now.\n   -->\n".getBytes();
    }
}

