/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ClusterPoolDataSource
implements DataSource {
    private static WriteStream dbg = LogStream.open("/caucho.com/sql/pool/new");
    private static L10N L = new L10N("com/caucho/sql/messages");
    private String poolNames;
    private int roundRobin;
    private Item[] pools;

    public String getPoolNames() {
        return this.poolNames;
    }

    public void setPoolNames(String names) {
        this.poolNames = names;
    }

    public synchronized void init() throws SQLException {
        if (this.pools != null) {
            return;
        }
        if (this.poolNames == null) {
            throw new SQLException(L.l("pool names must be set"));
        }
        ArrayList<String> names = new ArrayList<String>();
        CharBuffer cb = new CharBuffer();
        int i = 0;
        int length = this.poolNames.length();
        while (true) {
            char ch;
            if (i < length && ((ch = this.poolNames.charAt(i)) == ' ' || ch == ',')) {
                ++i;
                continue;
            }
            if (i >= length) break;
            cb.clear();
            while (i < length && (ch = this.poolNames.charAt(i)) != ' ' && ch != ',') {
                cb.append(ch);
                ++i;
            }
            names.add(cb.toString());
        }
        if (names.size() == 0) {
            throw new SQLException(L.l("can't find any names"));
        }
        Item[] pools = new Item[names.size()];
        try {
            Context env = (Context)new InitialContext().lookup("java:comp/env");
            for (i = 0; i < pools.length; ++i) {
                DBPool pool;
                pools[i] = new Item();
                String name = (String)names.get(i);
                pools[i].pool = pool = (DBPool)env.lookup(name);
            }
        }
        catch (NamingException e) {
            throw new SQLExceptionWrapper(e);
        }
        this.pools = pools;
    }

    public Connection getConnection(String user, String password) throws SQLException {
        if (this.pools == null) {
            this.init();
        }
        SQLException exn = null;
        int best = this.getBestPool();
        for (int i = 0; i < this.pools.length; ++i) {
            int index = (best + i) % this.pools.length;
            try {
                return this.pools[index].getConnection(user, password);
            }
            catch (SQLException e) {
                exn = e;
                continue;
            }
        }
        throw exn;
    }

    public Connection getConnection() throws SQLException {
        if (this.pools == null) {
            this.init();
        }
        SQLException exn = null;
        int best = this.getBestPool();
        for (int i = 0; i < this.pools.length; ++i) {
            int index = (best + i) % this.pools.length;
            try {
                return this.pools[index].getConnection();
            }
            catch (SQLException e) {
                exn = e;
                continue;
            }
        }
        throw exn;
    }

    private int getBestPool() {
        int roundRobin;
        if ((roundRobin = this.roundRobin++ % this.pools.length) < 0) {
            this.roundRobin = 0;
            roundRobin = 0;
        }
        int bestPool = 0;
        int bestCost = Integer.MAX_VALUE;
        for (int i = this.pools.length - 1; i >= 0; --i) {
            int cost = this.pools[i].getActiveConnections();
            if (cost >= bestCost && (cost != bestCost || i != roundRobin)) continue;
            bestPool = i;
            bestCost = cost;
        }
        return bestPool;
    }

    public int getLoginTimeout() {
        return 0;
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLoginTimeout(int foo) {
    }

    public void setLogWriter(PrintWriter log) {
    }

    static class Item {
        DBPool pool;
        boolean isDead;
        long lastCheckTime;

        Item() {
        }

        int getActiveConnections() {
            if (this.isDead) {
                if (Alarm.getCurrentTime() < this.lastCheckTime + 5000L) {
                    return 0x7FFFFFFE;
                }
                this.isDead = false;
            }
            return this.pool.getActiveConnections();
        }

        void setLive() {
            this.isDead = false;
        }

        Connection getConnection() throws SQLException {
            this.isDead = false;
            try {
                return this.pool.getConnection();
            }
            catch (SQLException e) {
                this.isDead = true;
                this.lastCheckTime = Alarm.getCurrentTime();
                throw e;
            }
        }

        Connection getConnection(String user, String password) throws SQLException {
            this.isDead = false;
            try {
                return this.pool.getConnection(user, password);
            }
            catch (SQLException e) {
                this.isDead = true;
                this.lastCheckTime = Alarm.getCurrentTime();
                throw e;
            }
        }
    }
}

