/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.PoolItem;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.SpyDriver;
import com.caucho.sql.XADataSourceAdapter;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.BeanUtil;
import com.caucho.util.CauchoSystem;
import com.caucho.util.ClassLoaderListener;
import com.caucho.util.ClassLoaderLocal;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DBPool
implements AlarmListener,
ClassLoaderListener,
Driver,
DataSource,
Serializable {
    private static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    private static WriteStream dbgNew = LogStream.open("/caucho.com/sql/pool/new");
    private static L10N L = new L10N("com/caucho/sql/messages");
    private static ClassLoaderLocal contextPools = new ClassLoaderLocal("caucho.sql.db-pool");
    private static final String URL_PREFIX = "jdbc:caucho:";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    private static final long MAX_IDLE_TIME = 30000L;
    private String poolName;
    private String dataSourceName;
    private transient ConnectionPoolDataSource poolDataSource;
    private transient XADataSource xaDataSource;
    private String driverName;
    private transient Object driverObject;
    private transient Driver driver;
    private String url;
    private String user;
    private String password;
    private Properties info;
    private RegistryNode registry;
    private int maxConnections = 20;
    private long maxIdleTime = 30000L;
    private long maxActiveTime = 21600000L;
    private long maxPoolTime = 86400000L;
    private long connectionWaitTime = 600000L;
    private int connectionWaitCount = (int)(this.connectionWaitTime / 1000L);
    private int maxOverflowConnections = 0;
    private int _maxCloseStatements = 20;
    private boolean isClosed;
    private boolean forbidClose;
    private String pingTable;
    private String pingQuery;
    private boolean pingOnReuse;
    private boolean pingOnIdle;
    private long _pingInterval = 60000L;
    private boolean isTransactional;
    private transient TransactionManagerImpl tm;
    private long _transactionTimeout;
    private WriteStream _spyStream;
    transient ArrayList connections = new ArrayList();
    private int idCount;
    private transient Alarm alarm;
    static /* synthetic */ Class class$com$caucho$sql$DBPool;

    public DBPool() {
        this.info = new Properties();
        this.alarm = new Alarm("db-pool", this, this.maxIdleTime);
    }

    public DBPool(String poolName, String url, String user, String password, String driverName, ClassLoader loader, int maxConnections) throws SQLException {
        this();
        this.poolName = poolName;
        this.driverName = driverName;
        this.url = url.intern();
        this.user = user == null ? "" : user.intern();
        this.password = password == null ? "" : password.intern();
        this.info.put(PROPERTY_USER, this.user);
        this.info.put(PROPERTY_PASSWORD, this.password);
        if (maxConnections == 0) {
            maxConnections = 1;
        }
        this.maxConnections = maxConnections;
    }

    public String getName() {
        return this.poolName;
    }

    public void setName(String name) {
        Hashtable<String, DBPool> pools = (Hashtable<String, DBPool>)contextPools.getLevel();
        if (pools == null) {
            pools = new Hashtable<String, DBPool>();
            contextPools.set(pools);
        }
        if (this.poolName != null) {
            pools.remove(this.poolName);
        }
        pools.put(name, this);
        this.poolName = name;
    }

    public String getDataSource() {
        return this.dataSourceName;
    }

    public void setDataSource(String name) {
        this.dataSourceName = name;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String name) {
        this.driverName = name;
    }

    public void setDriver(String name) {
        this.driverName = name;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getTotalConnections() {
        return this.connections.size();
    }

    public void setConnectionWaitTime(long waitTime) {
        this.connectionWaitTime = waitTime;
        if (waitTime < 0L) {
            this.connectionWaitCount = 3600;
        } else {
            this.connectionWaitCount = (int)((waitTime + 999L) / 1000L);
            if (this.connectionWaitCount <= 0) {
                this.connectionWaitCount = 1;
            }
        }
    }

    public long getConnectionWaitTime() {
        return this.connectionWaitTime;
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this.maxOverflowConnections = maxOverflowConnections;
    }

    public int getMaxOverflowConnections() {
        return this.maxOverflowConnections;
    }

    public int getMaxCloseStatements() {
        return this._maxCloseStatements;
    }

    public void setMaxCloseStatements(int maxCloseStatements) {
        this._maxCloseStatements = maxCloseStatements;
    }

    public void setTransactionTimeout(long period) {
        this._transactionTimeout = period;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveConnections() {
        int activeCount = 0;
        if (this.connections == null) {
            return 0;
        }
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            for (int i = this.connections.size() - 1; i >= 0; --i) {
                PoolItem item = (PoolItem)this.connections.get(i);
                if (!item.isActive()) continue;
                ++activeCount;
            }
        }
        return activeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolItem getDelegatePoolItem(Xid xid) {
        if (this.connections == null) {
            return null;
        }
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            for (int i = this.connections.size() - 1; i >= 0; --i) {
                PoolItem item = (PoolItem)this.connections.get(i);
                if (!xid.equals(item.getXid())) continue;
                return item;
            }
        }
        return null;
    }

    public long getMaxIdleTime() {
        if (this.maxIdleTime > 0x3FFFFFFFFFFFFFFFL) {
            return -1L;
        }
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long idleTime) {
        this.maxIdleTime = idleTime < 0L ? 0x3FFFFFFFFFFFFFFFL : (idleTime < 1000L ? 1000L : idleTime);
        if (this.maxIdleTime > 60000L) {
            this.alarm.queue(60000L);
        } else {
            this.alarm.queue(this.maxIdleTime);
        }
    }

    public long getMaxPoolTime() {
        if (this.maxPoolTime > 0x3FFFFFFFFFFFFFFFL) {
            return -1L;
        }
        return this.maxPoolTime;
    }

    public void setMaxPoolTime(long maxPoolTime) {
        this.maxPoolTime = maxPoolTime < 0L ? 0x3FFFFFFFFFFFFFFFL : (maxPoolTime == 0L ? 1000L : maxPoolTime);
    }

    public long getMaxActiveTime() {
        if (this.maxActiveTime > 0x3FFFFFFFFFFFFFFFL) {
            return -1L;
        }
        return this.maxActiveTime;
    }

    public void setMaxActiveTime(long maxActiveTime) {
        this.maxActiveTime = maxActiveTime < 0L ? 0x3FFFFFFFFFFFFFFFL : (maxActiveTime == 0L ? 1000L : maxActiveTime);
    }

    public String getPingTable() {
        return this.pingTable;
    }

    public void setPingTable(String pingTable) {
        this.pingTable = pingTable;
        this.pingQuery = pingTable != null ? "select 1 from " + pingTable + " where 1=0" : null;
    }

    public boolean getPingOnReuse() {
        return this.pingOnReuse;
    }

    public void setPingOnReuse(boolean pingOnReuse) {
        this.pingOnReuse = pingOnReuse;
    }

    public boolean getPingOnIdle() {
        return this.pingOnIdle;
    }

    public void setPingOnIdle(boolean pingOnIdle) {
        this.pingOnIdle = pingOnIdle;
    }

    public void setPingInterval(long interval) {
        this._pingInterval = interval;
        this._pingInterval = interval < 0L ? 0x3FFFFFFFFFFFFFFFL : (interval < 1000L ? 1000L : interval);
        if (this._pingInterval > 0L && this._pingInterval < this.maxIdleTime && this._pingInterval < 60000L) {
            this.alarm.queue(this._pingInterval);
        }
    }

    public long getPingInterval() {
        return this._pingInterval;
    }

    public void setTransactionManager(TransactionManagerImpl tm) {
        this.isTransactional = tm != null;
        this.tm = tm;
    }

    public void setSpy(Path path) throws IOException {
        if (path.getURL().startsWith("log:")) {
            this._spyStream = dbg;
        } else {
            path.getParent().mkdirs();
            this._spyStream = path.openWrite();
        }
    }

    public TransactionManagerImpl getTransactionManager() {
        return this.tm;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public RegistryNode getRegistry() {
        return this.registry;
    }

    public void setRegistry(RegistryNode registry) {
        this.registry = registry;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getProperty(String name) {
        return (String)this.info.get(name);
    }

    public void setProperty(String name, String value) {
        this.info.put(name, value);
    }

    public synchronized Driver getDriver() throws SQLException {
        if (this.driver != null) {
            return this.driver;
        }
        Object driverObject = this.getDriverObject();
        if (driverObject instanceof Driver) {
            this.driver = (Driver)driverObject;
            if (this._spyStream != null) {
                this.driver = new SpyDriver(this.driver, this._spyStream);
            }
            return this.driver;
        }
        throw new SQLExceptionWrapper(L.l("driver-name `{0}' for resource-ref `{1}' does not implement java.sql.Driver (actual driver object `{2}').  Database drivers must implement java.sql.Driver.", this.driverName, this.poolName, driverObject));
    }

    Properties getInfo() {
        return (Properties)this.info.clone();
    }

    int createPoolId() {
        return this.idCount++;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        String poolName = url.substring(URL_PREFIX.length());
        DBPool pool = null;
        try {
            pool = DBPool.getPool(poolName);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
        if (pool == null) {
            return null;
        }
        Driver driver = pool.getDriver();
        if (driver == null) {
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        if (info.get(PROPERTY_USER) == null) {
            info.put(PROPERTY_USER, pool.getUser());
        }
        if (info.get(PROPERTY_PASSWORD) == null) {
            info.put(PROPERTY_PASSWORD, pool.getPassword());
        }
        return driver.getPropertyInfo(pool.getURL(), info);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String poolName = url.substring(URL_PREFIX.length());
        if (poolName == null || poolName.equals("")) {
            return null;
        }
        String username = null;
        String password = null;
        if (info != null) {
            username = info.getProperty(PROPERTY_USER);
            password = info.getProperty(PROPERTY_PASSWORD);
        }
        DBPool pool = null;
        try {
            pool = DBPool.getPool(poolName);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
        if (pool != null) {
            return pool.getConnection(username, password);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPool getPool(String name) throws SQLException {
        DBPool pool;
        InitialContext cxt;
        try {
            cxt = new InitialContext();
            pool = null;
            if (cxt != null) {
                pool = (DBPool)cxt.lookup(name);
            }
            if (pool != null) {
                return pool;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cxt = new InitialContext();
            pool = null;
            if (cxt != null) {
                pool = (DBPool)cxt.lookup("java:comp/env/" + name);
            }
            if (pool != null) {
                return pool;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cxt = new InitialContext();
            pool = null;
            if (cxt != null) {
                pool = (DBPool)cxt.lookup("java:comp/env/jdbc/" + name);
            }
            if (pool != null) {
                return pool;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Hashtable pools = (Hashtable)contextPools.get();
        pool = null;
        if (pools != null) {
            pool = (DBPool)pools.get(name);
        }
        if (pool != null) {
            return pool;
        }
        pools = (Hashtable)contextPools.getGlobal();
        if (pools != null) {
            pool = (DBPool)pools.get(name);
        }
        if (pool != null) {
            return pool;
        }
        Class clazz = class$com$caucho$sql$DBPool == null ? (class$com$caucho$sql$DBPool = DBPool.class$("com.caucho.sql.DBPool")) : class$com$caucho$sql$DBPool;
        synchronized (clazz) {
            try {
                if (pools != null) {
                    pool = (DBPool)pools.get(name);
                }
                if (pool != null) {
                    return pool;
                }
                RegistryNode node = DBPool.getPoolConfig(name);
                if (node == null) {
                    throw new SQLException("no such database pool `" + name + "'");
                }
                String url = node.getString("url", null);
                url = node.getString("init-param/url", url);
                String driver = node.getString("driver", null);
                driver = node.getString("driver-name", driver);
                driver = node.getString("init-param/driver-name", driver);
                driver = node.getString("data-source", driver);
                driver = node.getString("init-param/data-source", driver);
                String user = node.getString(PROPERTY_USER, null);
                user = node.getString("init-param/user", user);
                String password = node.getString(PROPERTY_PASSWORD, null);
                password = node.getString("init-param/password", password);
                int maxConnections = node.getInt("max-connections", 20);
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader loader = (class$com$caucho$sql$DBPool == null ? (class$com$caucho$sql$DBPool = DBPool.class$("com.caucho.sql.DBPool")) : class$com$caucho$sql$DBPool).getClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
                try {
                    pool = new DBPool(name, url, user, password, driver, loader, maxConnections);
                    pool.registry = node;
                    pool.forbidClose = true;
                    BeanUtil.configureOptional(pool, node);
                    pools = (Hashtable)contextPools.getGlobal();
                    if (pools == null) {
                        pools = new Hashtable();
                        contextPools.setGlobal(pools);
                    }
                    pools.put(name, pool);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
                return pool;
            }
            catch (RegistryException e) {
                throw new SQLExceptionWrapper(e);
            }
        }
    }

    private static RegistryNode getPoolConfig(String name) {
        RegistryNode top = Registry.lookup("/caucho.com");
        if (top == null) {
            return null;
        }
        RegistryNode deflt = null;
        Iterator iter = top.iterator();
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            String id = node.getValue();
            if (node.getName().equals("resource-ref") && node.getString("res-ref-name", "").equals(name)) {
                return node;
            }
            if (!node.getName().equals("dbpool.sql")) continue;
            if (name == null && (id == null || id.equals(""))) {
                return node;
            }
            if (id == null) {
                deflt = node;
                continue;
            }
            if (!name.equals(id)) continue;
            return node;
        }
        return deflt;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        boolean isPooled = false;
        PoolItem poolItem = null;
        int count = 5;
        Throwable exn = null;
        while (poolItem == null && count-- >= 0) {
            poolItem = user != null && !user.equals(this.user) ? this.createConnection(user, password) : (password != null && !password.equals(this.password) ? this.createConnection(user, password) : this.getPooledConnection());
            try {
                Transaction trans;
                if (this.tm == null || poolItem.getXid() != null || (trans = this.tm.getTransaction()) == null) continue;
                trans.enlistResource((XAResource)poolItem);
            }
            catch (Throwable e) {
                dbg.log(e);
                exn = e;
                try {
                    poolItem.connectionErrorOccurred(null);
                    poolItem.connectionClosed(null);
                }
                catch (Throwable e1) {
                    dbg.log(e1);
                }
                poolItem = null;
            }
        }
        try {
            if (poolItem != null) {
                return poolItem.getConnection();
            }
            if (exn != null) {
                throw exn;
            }
            return null;
        }
        catch (Throwable e) {
            throw SQLExceptionWrapper.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolItem getPooledConnection() throws SQLException {
        PoolItem poolItem = null;
        ArrayList connections = this.connections;
        if (connections == null) {
            throw new SQLException(L.l("can't get connection from closed pool `{0}'", this.poolName));
        }
        boolean createConnection = false;
        ArrayList arrayList = connections;
        synchronized (arrayList) {
            for (int i = 0; !this.isClosed && i < this.connectionWaitCount; ++i) {
                if (this.tm != null) {
                    try {
                        Xid xid;
                        TransactionImpl trans = (TransactionImpl)this.tm.getTransaction();
                        Xid xid2 = xid = trans == null ? null : trans.getXid();
                        if (xid != null) {
                            for (int j = connections.size() - 1; j >= 0; --j) {
                                poolItem = (PoolItem)connections.get(j);
                                if (poolItem.isDead()) {
                                    connections.remove(j);
                                    continue;
                                }
                                if (!poolItem.allocateXA(xid) || !this.isValid(poolItem)) continue;
                                if (dbg.canWrite()) {
                                    dbg.log("reusing connection " + poolItem);
                                }
                                return poolItem;
                            }
                        }
                    }
                    catch (Exception e) {
                        try {
                            if (poolItem != null) {
                                poolItem.close();
                            }
                        }
                        catch (Throwable e1) {
                            // empty catch block
                        }
                        dbg.log(e);
                    }
                }
                for (int j = connections.size() - 1; j >= 0; --j) {
                    poolItem = (PoolItem)connections.get(j);
                    if (poolItem.isDead()) {
                        connections.remove(j);
                        continue;
                    }
                    if (!poolItem.allocate()) continue;
                    if (this.isValid(poolItem)) {
                        return poolItem;
                    }
                    if (!poolItem.isDead()) continue;
                    connections.remove(j);
                }
                if (connections.size() < this.maxConnections) break;
                try {
                    if (dbg.canWrite()) {
                        dbg.log("wait for connection (" + this.getActiveConnections() + ", " + this.getTotalConnections() + ")");
                    }
                    connections.wait(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    dbg.log(e);
                }
            }
            if (connections.size() < this.maxConnections + this.maxOverflowConnections) {
                if (this.maxConnections <= connections.size()) {
                    dbgNew.log("creating an overflow connection [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "] url=" + this.url + " user=" + this.user);
                }
                createConnection = true;
            }
        }
        if (createConnection) {
            return this.createConnection(this.user, this.password);
        }
        dbgNew.log("can't connect with full pool [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "] url=" + this.url + " user=" + this.user);
        throw new SQLException(L.l("Can't open connection with full database pool ({0})", String.valueOf(this.getTotalConnections())));
    }

    private boolean isValid(PoolItem poolItem) {
        try {
            if (!poolItem.isValid()) {
                return false;
            }
            long now = Alarm.getCurrentTime();
            if (!(this.maxPoolTime > 0L && poolItem.getPoolStartTime() + this.maxPoolTime < 0L || this.pingOnReuse && !this.ping(poolItem.getConnection()))) {
                return true;
            }
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        if (dbgNew.canWrite()) {
            dbgNew.log("connection died in pool " + poolItem.getId() + ":" + this.getName() + " [total:" + this.getTotalConnections() + "]");
        }
        try {
            poolItem.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    private PoolItem createConnection(String user, String password) throws SQLException {
        PooledConnection conn = null;
        if (this.isClosed) {
            throw new SQLException(L.l("can't create connection from closed pool"));
        }
        if (this.xaDataSource != null) {
            conn = user == null && password == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(user, password);
        } else if (this.poolDataSource != null) {
            if (this.isTransactional) {
                throw new SQLExceptionWrapper(L.l("ConnectionPoolDataSource `{0}' can not be configured as transactional.  Either use the database's XADataSource driver or the old java.sql.Driver driver.", this.poolDataSource));
            }
            conn = user == null && password == null ? this.poolDataSource.getPooledConnection() : this.poolDataSource.getPooledConnection(user, password);
        }
        if (conn != null) {
            return this.createPoolItem(conn);
        }
        try {
            Object obj;
            if (this.isTransactional && this.tm == null && (obj = new InitialContext().lookup("java:comp/TransactionManager")) instanceof TransactionManagerImpl) {
                this.tm = (TransactionManagerImpl)obj;
            }
        }
        catch (NamingException e) {
            if (conn != null) {
                conn.close();
            }
            throw new SQLExceptionWrapper(e);
        }
        this.initDataSource();
        if (this.xaDataSource != null) {
            conn = user == null && password == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(user, password);
        } else if (this.poolDataSource != null) {
            if (this.isTransactional) {
                throw new SQLExceptionWrapper(L.l("ConnectionPoolDataSource `{0}' can not be configured as transactional.  Either use the database's XADataSource driver or the old java.sql.Driver driver.", this.poolDataSource));
            }
            conn = user == null && password == null ? this.poolDataSource.getPooledConnection() : this.poolDataSource.getPooledConnection(user, password);
        }
        return this.createPoolItem(conn);
    }

    private synchronized void initDataSource() throws SQLException {
        Object driverObject;
        block17: {
            block16: {
                if (this.dataSourceName != null) {
                    try {
                        Object obj = this.dataSourceName.startsWith("java:") ? new InitialContext().lookup(this.dataSourceName) : new InitialContext().lookup("java:comp/env/" + this.dataSourceName);
                        if (obj == null) {
                            throw new SQLExceptionWrapper(L.l("data-source `{0}' does not refer to a configured JNDI XADataSource or ConnectionPoolDataSource.", this.dataSourceName));
                        }
                        if (obj instanceof XADataSource) {
                            this.xaDataSource = (XADataSource)obj;
                            break block16;
                        }
                        if (obj instanceof ConnectionPoolDataSource) {
                            this.poolDataSource = (ConnectionPoolDataSource)obj;
                            break block16;
                        }
                        throw new SQLExceptionWrapper(L.l("data-source `{0}' is of type `{1}' which does not implement XADataSource or ConnectionPoolDataSource.", (Object)this.dataSourceName, obj.getClass().getName()));
                    }
                    catch (NamingException e) {
                        throw new SQLExceptionWrapper(e);
                    }
                }
            }
            if (this.xaDataSource != null || this.poolDataSource != null) {
                return;
            }
            driverObject = this.getDriverObject();
            if (driverObject == null) {
                throw new SQLExceptionWrapper(L.l("driver-name `{0}' has not been configured for pool {1}.", (Object)this.driverName, this.poolName));
            }
            try {
                BeanUtil.configureOptional(driverObject, this.registry);
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block17;
                dbg.log(e);
            }
        }
        if (driverObject instanceof XADataSource) {
            this.xaDataSource = (XADataSource)driverObject;
        } else if (driverObject instanceof ConnectionPoolDataSource) {
            this.poolDataSource = (ConnectionPoolDataSource)driverObject;
        } else if (this.tm != null) {
            this.xaDataSource = new XADataSourceAdapter(this);
        } else {
            this.poolDataSource = new XADataSourceAdapter(this);
        }
    }

    private synchronized Object getDriverObject() throws SQLException {
        if (this.driverObject != null) {
            return this.driverObject;
        }
        if (this.driverName == null) {
            return null;
        }
        if (dbg.canWrite()) {
            dbg.log("loading driver: " + this.driverName);
        }
        try {
            Class cl = CauchoSystem.loadClass(this.driverName);
            this.driverObject = cl.newInstance();
        }
        catch (Exception e) {
            throw new SQLExceptionWrapper(e);
        }
        return this.driverObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolItem createPoolItem(PooledConnection conn) {
        PoolItem poolItem = new PoolItem(this, conn);
        if (!poolItem.allocate()) {
            throw new IllegalStateException();
        }
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.add(poolItem);
        }
        if (dbgNew.canWrite()) {
            dbgNew.log("create " + poolItem.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItem(PoolItem item) {
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(item);
            if (this.connections.size() + 1 >= this.maxConnections) {
                this.connections.notifyAll();
            }
        }
        if (dbgNew.canWrite()) {
            dbgNew.log("close-on-error " + item.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (this.isClosed) {
            return;
        }
        if (this.pingOnIdle && this._pingInterval > 0L && this._pingInterval < this.maxIdleTime && this._pingInterval < 60000L) {
            alarm.queue(this._pingInterval);
        } else if (this.maxIdleTime > 0L && this.maxIdleTime < 60000L) {
            alarm.queue(this.maxIdleTime);
        } else {
            alarm.queue(60000L);
        }
        long now = Alarm.getCurrentTime();
        ArrayList<PoolItem> closeList = null;
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            for (int i = this.connections.size() - 1; i >= 0; --i) {
                PoolItem poolItem = (PoolItem)this.connections.get(i);
                try {
                    boolean closePool = false;
                    long poolStartTime = poolItem.getPoolStartTime();
                    long poolWaitTime = poolItem.getPoolEventTime();
                    if (poolItem.isDead()) {
                        closePool = true;
                        if (dbgNew.canWrite()) {
                            dbgNew.log("close-dead " + poolItem.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
                        }
                    } else if (poolItem.isActive()) {
                        if (this.maxActiveTime > 0L && poolWaitTime + this.maxActiveTime < now) {
                            closePool = true;
                            if (dbgNew.canWrite()) {
                                dbgNew.log("close-active-timeout(" + this.maxActiveTime + ") " + poolItem.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
                            }
                        }
                    } else if (this.maxPoolTime > 0L && poolStartTime + this.maxPoolTime < now) {
                        closePool = true;
                        if (dbgNew.canWrite()) {
                            dbgNew.log("close-pool-timeout " + poolItem.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
                        }
                    } else if (this.maxIdleTime > 0L && poolWaitTime + this.maxIdleTime < now) {
                        closePool = true;
                        if (dbgNew.canWrite()) {
                            dbgNew.log("close-idle " + poolItem.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
                        }
                    } else if (this.pingOnIdle && !this.ping(poolItem.getConnection())) {
                        closePool = true;
                        if (dbgNew.canWrite()) {
                            dbgNew.log("close-ping-on-idle-fail " + poolItem.getId() + ":" + this.getName() + " [active:" + this.getActiveConnections() + ", total:" + this.getTotalConnections() + "]");
                        }
                    }
                    if (!closePool) continue;
                    if (closeList == null) {
                        closeList = new ArrayList<PoolItem>();
                    }
                    this.connections.remove(i);
                    closeList.add(poolItem);
                    continue;
                }
                catch (SQLException e) {
                    dbg.log(e);
                }
            }
        }
        for (int i = 0; closeList != null && i < closeList.size(); ++i) {
            PoolItem poolItem = (PoolItem)closeList.get(i);
            try {
                poolItem.close();
                continue;
            }
            catch (Throwable e) {
                dbgNew.log(e);
            }
        }
        if (closeList != null) {
            ArrayList arrayList2 = this.connections;
            synchronized (arrayList2) {
                this.connections.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean ping(Connection conn) {
        boolean isValid;
        block22: {
            block20: {
                block18: {
                    if (conn == null) {
                        return false;
                    }
                    isValid = false;
                    if (this.pingQuery != null) break block18;
                    boolean bl = true;
                    Object var6_7 = null;
                    try {
                        if (!isValid) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        isValid = false;
                        dbg.log(e2);
                    }
                    return bl;
                }
                if (!conn.isClosed()) break block20;
                boolean bl = false;
                Object var6_8 = null;
                try {
                    if (!isValid) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    isValid = false;
                    dbg.log(e2);
                }
                return bl;
            }
            Statement stmt = conn.createStatement();
            ResultSet rs = null;
            rs = stmt.executeQuery(this.pingQuery);
            rs.next();
            isValid = true;
            rs.close();
            stmt.close();
            Object var6_9 = null;
            try {
                if (!isValid) {
                    conn.close();
                }
                break block22;
            }
            catch (SQLException e2) {
                isValid = false;
                dbg.log(e2);
            }
            break block22;
            {
                catch (SQLException e) {
                    isValid = false;
                    dbg.log(e);
                    Object var6_10 = null;
                    try {
                        if (!isValid) {
                            conn.close();
                        }
                        break block22;
                    }
                    catch (SQLException e2) {
                        isValid = false;
                        dbg.log(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (!isValid) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    isValid = false;
                    dbg.log(e2);
                }
                throw throwable;
            }
        }
        return isValid;
    }

    public static void closeLoaderPools() {
        Hashtable pools = (Hashtable)contextPools.getLevel();
        if (pools == null) {
            return;
        }
        contextPools.set(null);
        ArrayList values = new ArrayList();
        values.addAll(pools.values());
        for (int i = 0; i < values.size(); ++i) {
            DBPool pool = (DBPool)values.get(i);
            try {
                pool.close();
                continue;
            }
            catch (Exception e) {
                dbgNew.log(e);
            }
        }
    }

    public static void closeGlobalPools() {
        Hashtable pools = (Hashtable)contextPools.getGlobal();
        contextPools.setGlobal(null);
        if (pools == null) {
            return;
        }
        ArrayList values = new ArrayList();
        values.addAll(pools.values());
        for (int i = 0; i < values.size(); ++i) {
            DBPool pool = (DBPool)values.get(i);
            try {
                pool.forceClose();
                continue;
            }
            catch (Throwable e) {
                dbgNew.log(e);
            }
        }
    }

    public void handleUnload(DynamicClassLoader loader) {
        this.forceClose();
    }

    public void close() {
        if (this.forbidClose) {
            throw new IllegalStateException("illegal to call close() for this DBPool");
        }
        this.forceClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClose() {
        Hashtable pools;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (dbgNew.canWrite()) {
            dbgNew.log("closing pool " + this.getName());
        }
        if ((pools = (Hashtable)contextPools.get()) != null) {
            pools.remove(this.poolName);
        }
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            for (int i = 0; i < this.connections.size(); ++i) {
                PoolItem poolItem = (PoolItem)this.connections.get(i);
                try {
                    poolItem.close();
                    continue;
                }
                catch (Exception e) {
                    dbg.log(e);
                }
            }
            this.connections.clear();
        }
        Alarm alarm = this.alarm;
        this.alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        this.connections = null;
    }

    public String toString() {
        return "[DBPool " + this.poolName + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new DBPool());
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }
}

