/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.QPooledConnection;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.XAExceptionWrapper;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class QPooledConnectionImpl
implements Connection,
XAResource {
    protected static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    protected static L10N L = new L10N("com/caucho/sql/messages");
    private DBPool _pool;
    private Connection _conn;
    protected TransactionManagerImpl _tm;
    protected Xid _xid;
    private boolean _isClosed;
    private int _isolation = -1;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private String _catalog = null;
    private int _oldIsolation = -1;
    private Map _typeMap;
    private long _poolWaitTime;
    private boolean _isValid = true;
    private Statement _statement;
    private ArrayList _statements;
    private QPooledConnection _pconn;

    QPooledConnectionImpl(DBPool pool, Connection conn, QPooledConnection pconn) {
        this._pool = pool;
        this._conn = conn;
        this._pconn = pconn;
        this._tm = pool.getTransactionManager();
        this._isValid = true;
    }

    long getPoolWaitTime() {
        return this._poolWaitTime;
    }

    void setPoolWaitTime(long now) {
        this._poolWaitTime = now;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public Statement createStatement() throws SQLException {
        Statement stmt;
        if (this._conn == null) {
            this._isValid = false;
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this._conn.createStatement();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt;
        if (this._conn == null) {
            this._isValid = false;
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this._conn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public String getCatalog() throws SQLException {
        try {
            return this._conn.getCatalog();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            if (this._catalog == null) {
                this._catalog = this._conn.getCatalog();
            }
            this._conn.setCatalog(catalog);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this._conn.getMetaData();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this._conn.getTypeMap();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            if (this._typeMap == null) {
                this._typeMap = this._conn.getTypeMap();
            }
            this._conn.setTypeMap(map);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            return this._conn.nativeSQL(sql);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this._conn.getTransactionIsolation();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            this._pconn.setIsolation(isolation);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._conn.getWarnings();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this._conn.clearWarnings();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._readOnly = readOnly;
            this._conn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this._conn.isReadOnly();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        if (this._conn == null) {
            this._isValid = false;
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this._conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        if (this._conn == null) {
            this._isValid = false;
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this._conn.prepareCall(sql);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        if (this._conn == null) {
            this._isValid = false;
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this._conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        if (this._conn == null) {
            this._isValid = false;
            throw new SQLException(L.l("can't create statement from closed connection."));
        }
        try {
            stmt = this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
        this.addStatement(stmt);
        return stmt;
    }

    public boolean getAutoCommit() throws SQLException {
        return this._conn.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this._tm != null && this._xid != null) {
            throw new SQLException(L.l("can't set auto-commit when using transactions"));
        }
        this._conn.setAutoCommit(autoCommit);
        this._autoCommit = autoCommit;
    }

    public void commit() throws SQLException {
        if (this._tm != null && this._xid != null) {
            throw new SQLException(L.l("can't call commit() when using transactions"));
        }
        this._conn.commit();
    }

    public void rollback() throws SQLException {
        if (this._tm != null && this._xid != null) {
            throw new SQLException(L.l("can't call rollback() when using transactions"));
        }
        this._conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        try {
            return this._isClosed || this._conn == null || this._conn.isClosed();
        }
        catch (SQLException e) {
            this._isValid = false;
            throw e;
        }
    }

    public void close() throws SQLException {
        Connection freeConn = this._conn;
        this._conn = null;
        this._isClosed = true;
        if (freeConn == null) {
            return;
        }
        try {
            this.closeStatements();
            if (this._isValid) {
                this.resetConnection(freeConn);
            }
            if (!this._isValid) {
                this._pconn.fatalEvent(freeConn);
            }
        }
        catch (Throwable e) {
            this._pconn.fatalEvent(freeConn);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SQLExceptionWrapper(e);
        }
        finally {
            this._pconn.closeEvent(freeConn);
        }
    }

    boolean isValid() throws SQLException {
        return this._isValid && !this.isClosed();
    }

    private void addStatement(Statement stmt) {
        if (this._isValid && (this._statements == null || this._statements.size() < 20)) {
            if (this._statement == null) {
                this._statement = stmt;
            } else if (this._statements == null) {
                this._statements = new ArrayList();
                this._statements.add(stmt);
            } else {
                this._statements.add(stmt);
            }
        } else {
            this._isValid = false;
        }
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        return resource == this;
    }

    public void start(Xid xid, int flags) throws XAException {
        this._xid = xid;
        try {
            if (this._conn != null) {
                this._conn.setAutoCommit(false);
            }
            this._autoCommit = false;
        }
        catch (SQLException e) {
            throw new XAException(e.getLocalizedMessage());
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public void forget(Xid xid) throws XAException {
        this._xid = null;
    }

    public int prepare(Xid xid) throws XAException {
        if (!this._isValid) {
            throw new XAException("invalid or broken connection");
        }
        return 0;
    }

    public void rollback(Xid xid) throws XAException {
        this._xid = null;
        if (this._conn == null) {
            return;
        }
        XAExceptionWrapper xaExn = null;
        try {
            this._conn.rollback();
        }
        catch (SQLException e) {
            xaExn = new XAExceptionWrapper(e);
        }
        try {
            if (this._isClosed) {
                this._isClosed = false;
                this._conn.setAutoCommit(true);
                this._autoCommit = true;
                this.close();
            } else {
                this._conn.setAutoCommit(true);
                this._autoCommit = true;
            }
        }
        catch (SQLException e) {
            throw new XAExceptionWrapper(e);
        }
        if (xaExn != null) {
            throw xaExn;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this._xid = null;
        if (this._conn == null) {
            return;
        }
        XAExceptionWrapper xaExn = null;
        try {
            this._conn.commit();
        }
        catch (SQLException e) {
            dbg.log(e);
            xaExn = new XAExceptionWrapper(e);
        }
        try {
            this._conn.setAutoCommit(true);
            this._autoCommit = true;
            this.close();
        }
        catch (SQLException e) {
            throw new XAExceptionWrapper(e);
        }
        if (xaExn != null) {
            throw xaExn;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        this._xid = null;
        return null;
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void setHoldability(int hold) {
    }

    public int getHoldability() {
        return 0;
    }

    public Savepoint setSavepoint() {
        return null;
    }

    public Savepoint setSavepoint(String name) {
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) {
    }

    public void rollback(Savepoint savepoint) {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType) {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    private void resetConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        this.closeStatements();
        try {
            if (!this._autoCommit) {
                conn.rollback();
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this._isValid = false;
        }
        this._autoCommit = true;
        try {
            if (this._readOnly) {
                conn.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            this._isValid = false;
        }
        this._readOnly = false;
        try {
            if (this._catalog != null) {
                conn.setCatalog(this._catalog);
            }
        }
        catch (SQLException e) {
            this._isValid = false;
        }
        this._catalog = null;
        try {
            if (this._typeMap != null) {
                conn.setTypeMap(this._typeMap);
            }
        }
        catch (SQLException e) {
            this._isValid = false;
        }
        this._typeMap = null;
        try {
            conn.clearWarnings();
        }
        catch (SQLException e) {
            this._isValid = false;
        }
    }

    private void closeStatements() {
        ArrayList statements = this._statements;
        this._statements = null;
        Statement stmt = this._statement;
        this._statement = null;
        boolean isOkay = this._isValid;
        this._isValid = false;
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        for (int i = 0; statements != null && i < statements.size(); ++i) {
            try {
                stmt = (Statement)statements.get(i);
                stmt.close();
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this._isValid = isOkay;
    }

    public String toString() {
        return "[Pool " + this._conn + "]";
    }
}

