/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.XidImpl;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.QThreadLocal;
import java.io.Serializable;
import java.util.Random;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class TransactionManagerImpl
implements UserTransaction,
TransactionManager,
Serializable {
    private static L10N L = new L10N(class$com$caucho$transaction$TransactionManagerImpl == null ? (class$com$caucho$transaction$TransactionManagerImpl = TransactionManagerImpl.class$("com.caucho.transaction.TransactionManagerImpl")) : class$com$caucho$transaction$TransactionManagerImpl);
    private static TransactionManagerImpl _tm = new TransactionManagerImpl();
    private QThreadLocal _threadTransaction = new QThreadLocal();
    private Random _random = new Random(Alarm.getCurrentTime());
    private long _transactionTimeout;
    static /* synthetic */ Class class$com$caucho$transaction$TransactionManagerImpl;

    public void setRandomSeed(long seed) {
        this._random = new Random(seed);
    }

    public void setRandom(Random random) {
        this._random = random;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getCurrent().begin();
    }

    XidImpl createXID() {
        return new XidImpl(this._random.nextLong());
    }

    public int getTransactionTimeout() {
        return (int)(this._transactionTimeout / 1000L);
    }

    public long getTimeout() {
        return this._transactionTimeout;
    }

    public Transaction getTransaction() throws SystemException {
        TransactionImpl trans = (TransactionImpl)this._threadTransaction.get();
        if (trans == null || trans.getStatus() == 6 || trans.getStatus() == 5 || trans.isSuspended()) {
            return null;
        }
        return trans;
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl trans = (TransactionImpl)this._threadTransaction.get();
        if (trans == null || !trans.hasResources() && (trans.getStatus() == 6 || trans.getStatus() == 5)) {
            return null;
        }
        this._threadTransaction.set(null);
        trans.suspend();
        return trans;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, SystemException {
        Transaction old = (Transaction)this._threadTransaction.get();
        if (old != null && old.getStatus() != 6) {
            throw new SystemException(L.l("can't resume transaction with active transaction {0}", String.valueOf(old)));
        }
        TransactionImpl impl = (TransactionImpl)tobj;
        impl.resume();
        this._threadTransaction.set(tobj);
    }

    public void setRollbackOnly() throws SystemException {
        this.getCurrent().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.getCurrent().getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getCurrent().setTransactionTimeout(seconds);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.getCurrent().commit();
    }

    public void rollback() {
        this.getCurrent().rollback();
    }

    public UserTransaction getUserTransaction() {
        return this;
    }

    public TransactionImpl getCurrent() {
        TransactionImpl trans = (TransactionImpl)this._threadTransaction.get();
        if (trans == null || trans.isDead()) {
            trans = new TransactionImpl(this);
            this._threadTransaction.set(trans);
        }
        return trans;
    }

    public String toString() {
        return "TransactionManagerImpl[]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

