/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public final class FreeList {
    private Object[] _freeRing;
    private int _head;
    private int _tail;
    private int _mask;

    public FreeList(int initialSize) {
        int size;
        for (size = 2; size < initialSize; size *= 2) {
        }
        this._freeRing = new Object[size];
        this._mask = size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocate() {
        FreeList freeList = this;
        synchronized (freeList) {
            if (this._head != this._tail) {
                Object value = this._freeRing[this._head];
                this._head = this._head + 1 & this._mask;
                return value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Object obj) {
        FreeList freeList = this;
        synchronized (freeList) {
            int newTail = this._tail + 1 & this._mask;
            if (this._head != newTail) {
                this._freeRing[this._tail] = obj;
                this._tail = newTail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCareful(Object obj) {
        if (this.checkDuplicate(obj)) {
            throw new IllegalStateException("tried to free object twice: " + obj);
        }
        FreeList freeList = this;
        synchronized (freeList) {
            int newTail = this._tail + 1 & this._mask;
            if (this._head != newTail) {
                this._freeRing[this._tail] = obj;
                this._tail = newTail;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowFree(Object obj) {
        FreeList freeList = this;
        synchronized (freeList) {
            int newTail = this._tail + 1 & this._mask;
            if (this._head != newTail) {
                this._freeRing[this._tail] = obj;
                this._tail = newTail;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDuplicate(Object obj) {
        int count = this._freeRing.length;
        FreeList freeList = this;
        synchronized (freeList) {
            int head = this._head;
            while (head != this._tail && count-- >= 0) {
                if (this._freeRing[head] == obj) {
                    return true;
                }
                head = head + 1 & this._mask;
            }
        }
        return false;
    }
}

