/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;

public class SimpleClassLoader
extends DynamicClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/loader");
    private Path path;
    private String prefix;
    private String pathPrefix;

    protected SimpleClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static SimpleClassLoader create(ClassLoader parent, Path path, String prefix) {
        if (path == null) {
            throw new NullPointerException();
        }
        SimpleClassLoader loader = new SimpleClassLoader(parent);
        loader.path = path;
        loader.prefix = prefix;
        if (parent instanceof DynamicClassLoader) {
            loader.addPermissions(((DynamicClassLoader)parent).getPermissions());
        }
        return loader;
    }

    public Path getPath(String name) {
        if (this.prefix != null && this.pathPrefix == null) {
            this.pathPrefix = this.prefix.replace('.', '/');
        }
        if (this.pathPrefix != null && !name.startsWith(this.pathPrefix)) {
            return null;
        }
        return this.path.lookup(name);
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!head.equals("")) {
            cb.append(head);
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        if (this.path instanceof JarPath) {
            cb.append(((JarPath)this.path).getContainer().getNativePath());
        } else if (this.path.isDirectory()) {
            cb.append(this.path.getNativePath());
        }
        return cb.toString();
    }

    public String toString() {
        if (this.prefix != null) {
            return "[SimpleClassLoader " + this.path + " prefix:" + this.prefix + "]";
        }
        return "[SimpleClassLoader " + this.path + "]";
    }
}

