/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.BindPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.SchemeMap;
import java.util.Map;

public abstract class FilesystemPath
extends Path {
    protected FilesystemPath _root;
    protected BindPath _bindRoot;
    protected String _pathname;
    protected String _userPath;
    protected char _separatorChar;

    protected FilesystemPath(FilesystemPath root, String userPath, String pathname) {
        super(root);
        if (pathname == null) {
            throw new NullPointerException();
        }
        this._separatorChar = (char)47;
        this._pathname = pathname;
        this._userPath = userPath;
        if (root != null) {
            this._root = root;
            this._bindRoot = root._bindRoot;
            this._separatorChar = root._separatorChar;
            return;
        }
    }

    public Path getParent() {
        if (this._pathname.length() <= 1) {
            return this.fsWalk("/", null, "/");
        }
        int length = this._pathname.length();
        int lastSlash = this._pathname.lastIndexOf(47);
        if (lastSlash < 1) {
            return this.fsWalk("/", null, "/");
        }
        if (lastSlash == length - 1 && (lastSlash = this._pathname.lastIndexOf(47, length - 2)) < 1) {
            return this.fsWalk("/", null, "/");
        }
        return this.fsWalk("..", null, this._pathname.substring(0, lastSlash));
    }

    protected Path schemeWalk(String userPath, Map attributes, String filePath, int offset) {
        String canonicalPath = filePath.length() > offset && (filePath.charAt(offset) == '/' || filePath.charAt(offset) == this._separatorChar) ? FilesystemPath.normalizePath("/", filePath, offset, this._separatorChar) : FilesystemPath.normalizePath(this._pathname, filePath, offset, this._separatorChar);
        return this.fsWalk(userPath, attributes, canonicalPath);
    }

    protected abstract Path fsWalk(String var1, Map var2, String var3);

    protected static String normalizePath(String oldPath, String newPath, int offset, char separatorChar) {
        CharBuffer cb = CharBuffer.allocate();
        FilesystemPath.normalizePath(cb, oldPath, newPath, offset, separatorChar);
        return cb.close();
    }

    protected static void normalizePath(CharBuffer cb, String oldPath, String newPath, int offset, char separatorChar) {
        cb.clear();
        cb.append(oldPath);
        if (cb.getLastChar() != '/') {
            cb.append('/');
        }
        int length = newPath.length();
        int i = offset;
        block8: while (i < length) {
            char ch2;
            char ch = newPath.charAt(i);
            switch (ch) {
                default: {
                    if (ch != separatorChar) {
                        cb.append(ch);
                        ++i;
                        continue block8;
                    }
                }
                case '/': {
                    if (cb.getLastChar() != '/') {
                        cb.append('/');
                    }
                    ++i;
                    continue block8;
                }
                case '.': 
            }
            if (cb.getLastChar() != '/') {
                cb.append('.');
                ++i;
                continue;
            }
            if (i + 1 >= length) {
                i += 2;
                continue;
            }
            switch (newPath.charAt(i + 1)) {
                default: {
                    if (newPath.charAt(i + 1) != separatorChar) {
                        cb.append('.');
                        ++i;
                        continue block8;
                    }
                }
                case '/': {
                    i += 2;
                    continue block8;
                }
                case '.': 
            }
            if ((i + 2 >= length || (ch2 = newPath.charAt(i + 2)) == '/' || ch2 == separatorChar) && cb.getLastChar() == '/') {
                int segment = cb.lastIndexOf('/', cb.length() - 2);
                if (segment == -1) {
                    cb.clear();
                    cb.append('/');
                } else {
                    cb.setLength(segment + 1);
                }
                i += 3;
                continue;
            }
            cb.append('.');
            ++i;
        }
    }

    public String getURL() {
        return this.getScheme() + ":" + this.getPath();
    }

    public String getPath() {
        return this._pathname;
    }

    public String getUserPath() {
        return this._userPath == null ? this._pathname : this._userPath;
    }

    public void setUserPath(String path) {
        this._userPath = path;
    }

    public char getSeparatorChar() {
        return this._separatorChar;
    }

    public String getFullPath() {
        if (this._root == this) {
            return this.getPath();
        }
        String rootPath = this._root.getFullPath();
        String path = this.getPath();
        if (rootPath.length() <= 1) {
            return path;
        }
        if (path.length() <= 1) {
            return rootPath;
        }
        return rootPath + path;
    }

    public String getTail() {
        String path = this.getPath();
        int length = path.length();
        int p = path.lastIndexOf(47);
        if (p == -1) {
            return "";
        }
        if (p < length - 1) {
            return path.substring(p + 1);
        }
        p = path.lastIndexOf(47, length - 2);
        if (p < 0) {
            return "";
        }
        return path.substring(p + 1, length - 1);
    }

    public Path createRoot(SchemeMap schemeMap) {
        FilesystemPath restriction = (FilesystemPath)this.copy();
        restriction.schemeMap = schemeMap;
        restriction._root = this;
        restriction._pathname = "/";
        restriction._userPath = "/";
        return restriction;
    }

    public void bind(Path context) {
        if (this._bindRoot == null) {
            this._bindRoot = this._root._bindRoot;
        }
        if (this._bindRoot == null) {
            this._root._bindRoot = this._bindRoot = new BindPath(this._root);
        }
        this._bindRoot.bind(this.getPath(), context);
    }

    public Path copy() {
        return this._root.fsWalk(this._userPath, null, this._pathname);
    }

    public int hashCode() {
        return this.getURL().hashCode();
    }

    public boolean equals(Object b) {
        if (b == null || !this.getClass().equals(b.getClass())) {
            return false;
        }
        Path bPath = (Path)b;
        return this.getURL().equals(bPath.getURL());
    }

    public String toString() {
        return this.getPath();
    }
}

