/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;
import com.caucho.util.Registry;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Jar
implements CacheListener,
AlarmListener {
    private static WriteStream dbg = LogStream.open("/caucho.com/vfs/jar");
    private static LruCache jarCache;
    private Path backing;
    private long lastModified;
    private long length;
    private long lastTime;
    private JarFile zipFile;
    private long zipLastModified;

    private Jar(Path backing) {
        this.backing = backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Jar create(Path backing) {
        if (jarCache == null) {
            int size = 256;
            try {
                size = Registry.getInt("/caucho.com/vfs/jar-cache-size", 256);
            }
            catch (Exception e) {
                // empty catch block
            }
            jarCache = new LruCache(size);
        }
        LruCache lruCache = jarCache;
        synchronized (lruCache) {
            Jar jar = (Jar)jarCache.get(backing);
            if (jar == null) {
                jar = new Jar(backing);
                jarCache.put(backing, jar);
            }
            return jar;
        }
    }

    Path getBacking() {
        return this.backing;
    }

    public synchronized Manifest getManifest() throws IOException {
        JarFile jarFile = this.getZipFile();
        if (jarFile == null) {
            return null;
        }
        return jarFile.getManifest();
    }

    public synchronized boolean exists(String path) {
        ZipEntry entry = this.getSafeJarEntry(path);
        return entry != null;
    }

    public synchronized boolean isDirectory(String pathName) {
        ZipEntry entry;
        if (!pathName.endsWith("/")) {
            pathName = pathName + '/';
        }
        if ((entry = this.getSafeJarEntry(pathName)) == null) {
            return false;
        }
        if (pathName.equals("/") || pathName.equals("")) {
            return true;
        }
        return entry != null && entry.isDirectory();
    }

    public synchronized boolean isFile(String path) {
        ZipEntry entry = this.getSafeJarEntry(path);
        return entry != null && !entry.isDirectory();
    }

    public synchronized long getLength(Path path) {
        ZipEntry entry = this.getSafeJarEntry(path.getPath());
        if (entry == null) {
            return -1L;
        }
        return entry.getSize();
    }

    public synchronized long getLastModified(String path) {
        long now = Alarm.getCurrentTime();
        if (now != this.lastTime) {
            long oldLastModified = this.lastModified;
            long oldLength = this.length;
            this.lastTime = now;
            this.lastModified = this.backing.getLastModified();
            this.length = this.backing.getLength();
            if (this.lastModified != oldLastModified || this.length != oldLength) {
                JarFile oldFile = this.zipFile;
                this.zipFile = null;
                this.zipLastModified = 0L;
                if (oldFile != null) {
                    try {
                        oldFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.lastModified;
    }

    public synchronized boolean canRead(String path) {
        return this.backing.canRead() && this.isFile(path);
    }

    public synchronized boolean canWrite(String path) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] list(String pathName) throws IOException {
        if (pathName.length() > 0 && !pathName.endsWith("/")) {
            pathName = pathName + "/";
        }
        if (pathName.startsWith("/")) {
            pathName = pathName.substring(1);
        }
        ArrayList<String> list = new ArrayList<String>();
        JarFile zFile = this.getZipFile();
        if (zFile != null) {
            Enumeration<? extends ZipEntry> e = ((ZipFile)zFile).entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.startsWith(pathName) || name.equals(pathName)) continue;
                String subName = name.substring(pathName.length());
                int p = subName.indexOf(47);
                if (p < 0) {
                    list.add(subName);
                    continue;
                }
                if (list.contains(subName = subName.substring(0, p))) continue;
                list.add(subName);
            }
        } else {
            ReadStream backingIs = this.backing.openRead();
            ZipInputStream is = new ZipInputStream(backingIs);
            try {
                ZipEntry entry;
                while ((entry = is.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (!name.startsWith(pathName) || name.equals(pathName)) continue;
                    String subName = name.substring(pathName.length());
                    int p = subName.indexOf(47);
                    if (p < 0) {
                        list.add(subName);
                        continue;
                    }
                    if (list.contains(subName = subName.substring(0, p))) continue;
                    list.add(subName);
                }
            }
            finally {
                is.close();
                backingIs.close();
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public synchronized StreamImpl openReadImpl(Path path) throws IOException {
        ZipEntry entry;
        ZipFile zipFile;
        String pathName = path.getPath();
        if (pathName.length() > 0 && pathName.charAt(0) == '/') {
            pathName = pathName.substring(1);
        }
        if ((zipFile = new ZipFile(this.backing.getNativePath())) != null) {
            ZipEntry entry2 = zipFile.getEntry(pathName);
            if (entry2 != null) {
                InputStream is = zipFile.getInputStream(entry2);
                return new ZipStreamImpl(zipFile, is, null, path);
            }
            zipFile.close();
            throw new FileNotFoundException(path.toString());
        }
        ReadStream backingIs = this.backing.openRead();
        ZipInputStream is = new ZipInputStream(backingIs);
        while ((entry = is.getNextEntry()) != null) {
            if (!entry.getName().equals(pathName)) continue;
            return new ZipStreamImpl(null, is, backingIs, path);
        }
        is.close();
        backingIs.close();
        throw new FileNotFoundException(path.toString());
    }

    public String toString() {
        return this.backing.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJarCache() {
        if (jarCache == null) {
            return;
        }
        LruCache lruCache = jarCache;
        synchronized (lruCache) {
            Iterator iter = jarCache.values();
            while (iter.hasNext()) {
                Jar jar = (Jar)iter.next();
                if (jar == null) continue;
                jar.clearCache();
            }
        }
    }

    public synchronized void clearCache() {
        try {
            JarFile oldZip = this.zipFile;
            this.zipFile = null;
            if (oldZip != null) {
                oldZip.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ZipEntry getSafeJarEntry(String path) {
        try {
            return this.getJarEntry(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    private ZipEntry getJarEntry(String path) throws IOException {
        JarFile zipFile;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((zipFile = this.getZipFile()) != null) {
            return ((ZipFile)zipFile).getEntry(path);
        }
        return null;
    }

    private JarFile getZipFile() {
        if (this.getLastModified(null) == this.zipLastModified && this.zipFile != null) {
            return this.zipFile;
        }
        this.zipFile = null;
        if (this.backing.getScheme().equals("file") && this.backing.canRead()) {
            try {
                this.zipFile = new JarFile(this.backing.getNativePath());
                new Alarm(this, 5000L);
            }
            catch (IOException e) {
                dbg.log(e);
            }
            this.zipLastModified = this.getLastModified(null);
        }
        return this.zipFile;
    }

    public synchronized void removeEvent() {
        try {
            JarFile oldZip = this.zipFile;
            this.zipFile = null;
            if (oldZip != null) {
                oldZip.close();
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public synchronized void handleAlarm(Alarm alarm) {
        block3: {
            try {
                JarFile oldZip = this.zipFile;
                this.zipFile = null;
                if (oldZip != null) {
                    oldZip.close();
                }
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block3;
                dbg.log(e);
            }
        }
    }

    static class ZipStreamImpl
    extends StreamImpl {
        private ZipFile zfile;
        private InputStream zis;
        private InputStream is;
        private Path path;

        ZipStreamImpl(ZipFile file, InputStream zis, InputStream is, Path path) {
            this.zfile = file;
            this.zis = zis;
            this.is = is;
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() throws IOException {
            if (this.zis == null) {
                return -1;
            }
            return this.zis.available();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int readLen = this.zis.read(buf, off, len);
            return readLen;
        }

        public void close() throws IOException {
            if (this.zis != null) {
                this.zis.close();
            }
            if (this.zfile != null) {
                this.zfile.close();
            }
            if (this.is != null) {
                this.is.close();
            }
            this.zis = null;
            this.zfile = null;
            this.is = null;
        }
    }
}

