/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.ByteBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MemoryPath
extends FilesystemPath {
    private static L10N L = new L10N("/com/caucho/vfs/messages");
    private Node rootNode;

    protected MemoryPath(FilesystemPath root, String userPath, Map attributes, String path) {
        super(root, userPath, path);
        if (root instanceof MemoryPath) {
            this.rootNode = ((MemoryPath)root).rootNode;
        } else {
            this._root = this;
        }
    }

    public MemoryPath() {
        this(null, "/", null, "/");
        this._root = this;
        this.rootNode = new Node("", null, 0);
    }

    public Path fsWalk(String userPath, Map attributes, String path) {
        return new MemoryPath(this._root, userPath, attributes, path);
    }

    public String getScheme() {
        return "file";
    }

    public String getURL() {
        return this.getFullPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        Node node = this.rootNode;
        synchronized (node) {
            return this.lookupAll() != null;
        }
    }

    private Node lookupAll() {
        Node node = this.lookupAllButTail();
        if (node == null) {
            return null;
        }
        String tail = this.getTail();
        if (tail == null || tail.equals("")) {
            return node;
        }
        return node.lookup(tail);
    }

    private Node lookupAllButTail() {
        String fullPath = this.getFullPath();
        int head = 0;
        Node node = this.rootNode;
        while (node != null && head < fullPath.length()) {
            int tail = fullPath.indexOf(47, head);
            if (tail == -1 || tail == fullPath.length() - 1) {
                return node;
            }
            if (head != tail) {
                node = node.lookup(fullPath.substring(head, tail));
            }
            head = tail + 1;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDirectory() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null) return false;
            if (node2.type != 0) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFile() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null) return false;
            if (node2.type != 1) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isObject() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null) return false;
            if (node2.type != 2) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 != null) {
                if (node2.type == 1) {
                    return ((ByteBuffer)node2.data).length();
                }
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            return node2 == null ? 0L : node2.lastModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            return node2 != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            return node2 != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null || node2.data != null) {
                return new String[0];
            }
            ArrayList<String> a = new ArrayList<String>();
            Node child = node2.firstChild;
            while (child != null) {
                a.add(child.name);
                child = child.next;
            }
            return a.toArray(new String[a.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdir(boolean parent) {
        Node node = this.rootNode;
        synchronized (node) {
            String fullPath = this.getFullPath();
            int head = 0;
            Node node2 = this.rootNode;
            while (node2 != null && head < fullPath.length()) {
                Node next;
                int tail;
                block12: {
                    block11: {
                        String name;
                        tail = fullPath.indexOf(47, head);
                        if (tail == head) {
                            head = tail + 1;
                            continue;
                        }
                        if (tail == -1) {
                            name = fullPath.substring(head);
                            if (node2.lookup(name) != null) {
                                return false;
                            }
                            node2.createDir(name);
                            return true;
                        }
                        name = fullPath.substring(head, tail);
                        next = node2.lookup(name);
                        if (next == null && parent) {
                            next = node2.createDir(name);
                        }
                        if (next == null) break block11;
                        if (next.type == 0) break block12;
                    }
                    return false;
                }
                node2 = next;
                head = tail + 1;
            }
            return false;
        }
    }

    public boolean mkdir() {
        return this.mkdir(false);
    }

    public boolean mkdirs() {
        return this.mkdir(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAllButTail();
            String tail = this.getTail();
            if (node2 == null) {
                return false;
            }
            Node child = node2.lookup(tail);
            if (child == null || child.firstChild != null) {
                return false;
            }
            node2.remove(tail);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameTo(Path path) {
        Node node = this.rootNode;
        synchronized (node) {
            if (!(path instanceof MemoryPath)) {
                return false;
            }
            MemoryPath file = (MemoryPath)path;
            if (this.rootNode != file.rootNode) {
                return false;
            }
            Node oldParent = this.lookupAllButTail();
            if (oldParent == null) {
                return false;
            }
            Node child = oldParent.lookup(this.getTail());
            if (child == null) {
                return false;
            }
            Node newParent = file.lookupAllButTail();
            if (newParent == null || newParent.type != 0) {
                return false;
            }
            if (newParent.lookup(file.getTail()) != null) {
                return false;
            }
            oldParent.remove(this.getTail());
            child.name = file.getTail();
            newParent.create(child);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamImpl openReadImpl() throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAll();
            if (node2 == null) {
                throw new FileNotFoundException(this.getPath());
            }
            if (node2.type != 1) {
                throw new IOException("is directory: " + this.getPath());
            }
            return new MemoryStream(node2, (ByteBuffer)node2.data, false);
        }
    }

    protected StreamImpl openWriteImpl() throws IOException {
        return this.openWriteImpl(false);
    }

    protected StreamImpl openAppendImpl() throws IOException {
        return this.openWriteImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamImpl openWriteImpl(boolean append) throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAllButTail();
            String tail = this.getTail();
            if (node2 == null || node2.type != 0) {
                throw new IOException(L.l("can't create file {0}", this.getFullPath()));
            }
            Node child = node2.lookup(tail);
            if (child == null) {
                child = node2.createFile(tail, new ByteBuffer(256));
            } else if (!append) {
                node2.remove(tail);
                child = node2.createFile(tail, new ByteBuffer(256));
            } else if (child.type != 1) {
                throw new IOException(L.l("can't create file {0}", this.getFullPath()));
            }
            return new MemoryStream(child, (ByteBuffer)child.data, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2;
            block6: {
                block5: {
                    node2 = this.lookupAll();
                    if (node2 == null) break block5;
                    if (node2.type == 2) break block6;
                }
                throw new IOException("no such object: " + this.getFullPath().toString());
            }
            return node2.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValue(Object object) throws IOException {
        Node node = this.rootNode;
        synchronized (node) {
            Node node2 = this.lookupAllButTail();
            String tail = this.getTail();
            if (node2 == null || node2.type != 0) {
                throw new IOException(L.l("can't set object {0}", this.getFullPath()));
            }
            Node child = node2.lookup(tail);
            if (child == null) {
                child = node2.createObject(tail, object);
            } else if (child.type == 2) {
                child.data = object;
            } else {
                throw new IOException(L.l("can't set object {0}", this.getFullPath()));
            }
        }
    }

    public MemoryPath copyDeep() {
        MemoryPath path = new MemoryPath();
        path.rootNode = this.rootNode.copy();
        return path;
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        MemoryPath mp = (MemoryPath)o;
        return this.getURL().equals(mp.getURL()) && this._root == mp._root;
    }

    public class MemoryStream
    extends StreamImpl {
        Node node;
        ByteBuffer bb;
        int offset;
        boolean write;

        MemoryStream(Node node, ByteBuffer bb, boolean write) {
            this.setPath(MemoryPath.this);
            this.node = node;
            if (write) {
                node.lastModified = Alarm.getCurrentTime();
            }
            this.write = write;
            this.bb = bb;
        }

        public int getAvailable() {
            return this.bb.length() - this.offset;
        }

        public boolean canRead() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buf, int bufOffset, int length) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                int sublen = this.bb.length() - this.offset;
                if (length < sublen) {
                    sublen = length;
                }
                if (sublen <= 0) {
                    return 0;
                }
                System.arraycopy(this.bb.getBuffer(), this.offset, buf, bufOffset, sublen);
                this.offset += sublen;
                return sublen;
            }
        }

        public int getPosition() {
            return this.offset;
        }

        public void setPosition(int pos) {
            this.offset = pos;
            if (this.offset < 0) {
                this.offset = 0;
            }
            if (this.offset > this.bb.length()) {
                this.offset = this.bb.length();
            }
        }

        public boolean canWrite() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            ByteBuffer byteBuffer = this.bb;
            synchronized (byteBuffer) {
                this.bb.add(buf, offset, length);
            }
            this.node.lastModified = Alarm.getCurrentTime();
        }
    }

    private static class Node {
        static final int DIR = 0;
        static final int FILE = 1;
        static final int OBJECT = 2;
        String name;
        Node next;
        Node firstChild;
        long lastModified;
        int type;
        Object data;

        Node(String name, Object data, int type) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.data = data;
            this.type = type;
            this.lastModified = Alarm.getCurrentTime();
        }

        Node lookup(String name) {
            Node node = this.firstChild;
            while (node != null) {
                if (node.name.equals(name)) {
                    return node;
                }
                node = node.next;
            }
            return null;
        }

        private Node create(String name, Object data, int type) {
            Node node = this.firstChild;
            while (node != null) {
                if (node.name.equals(name)) {
                    return null;
                }
                node = node.next;
            }
            Node newNode = new Node(name, data, type);
            newNode.next = this.firstChild;
            this.firstChild = newNode;
            this.lastModified = Alarm.getCurrentTime();
            return newNode;
        }

        Node createDir(String name) {
            return this.create(name, null, 0);
        }

        Node createFile(String name, ByteBuffer data) {
            return this.create(name, data, 1);
        }

        Node createObject(String name, Object data) {
            return this.create(name, data, 2);
        }

        Node create(Node newNode) {
            newNode.next = this.firstChild;
            this.firstChild = newNode;
            return newNode;
        }

        boolean remove(String name) {
            Node last = null;
            Node node = this.firstChild;
            while (node != null) {
                if (node.name.equals(name)) {
                    if (node.firstChild != null) {
                        return false;
                    }
                    if (last != null) {
                        last.next = node.next;
                    } else {
                        this.firstChild = node.next;
                    }
                    return true;
                }
                last = node;
                node = node.next;
            }
            return false;
        }

        Node copy() {
            Node newNode = new Node(this.name, this.data, this.type);
            if (this.type == 0) {
                Node child = this.firstChild;
                while (child != null) {
                    Node newChild = child.copy();
                    newChild.next = newNode.firstChild;
                    newNode.firstChild = newChild;
                    child = child.next;
                }
            }
            return newNode;
        }
    }
}

