/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryStream
extends StreamImpl {
    private TempBuffer head;
    private TempBuffer tail;

    public Path getPath() {
        return new NullPath("temp:");
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        while (offset < length) {
            int sublen;
            if (this.tail == null || this.tail.length >= this.tail.buf.length) {
                this.addBuffer(TempBuffer.allocate());
            }
            if (length - offset < (sublen = this.tail.buf.length - this.tail.length)) {
                sublen = length - offset;
            }
            System.arraycopy(buf, offset, this.tail.buf, this.tail.length, sublen);
            offset += sublen;
            this.tail.length += sublen;
        }
    }

    private void addBuffer(TempBuffer buf) {
        buf.next = null;
        buf.length = 0;
        if (this.tail != null) {
            this.tail.next = buf;
            this.tail = buf;
        } else {
            this.tail = buf;
            this.head = buf;
        }
        ++this.head.bufferCount;
    }

    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer node = this.head;
        while (node != null) {
            os.write(node.buf, 0, node.length);
            node = node.next;
        }
    }

    public int getLength() {
        if (this.tail == null) {
            return 0;
        }
        return (this.head.bufferCount - 1) * this.head.length + this.tail.length;
    }

    public ReadStream openRead() throws IOException {
        this.close();
        TempReadStream read = new TempReadStream(this.head, this.getPath());
        read.setFreeWhenDone(false);
        return new ReadStream(read);
    }

    public void destroy() {
        while (this.head != null) {
            TempBuffer next = this.head.next;
            TempBuffer.free(this.head);
            this.head = next;
        }
        this.head = null;
        this.tail = null;
    }
}

