/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.NullIterator;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class SmtpStream
extends MemoryStream {
    static WriteStream dbg = LogStream.open("/caucho.com/smtp.vfs");
    ArrayList to;
    ArrayList cc;
    ArrayList bcc;
    private String from;
    private String sender;
    private HashMap attributes;
    boolean isClosed;

    SmtpStream(ArrayList to, HashMap attributes) throws IOException {
        if (to.size() <= 0) {
            throw new IOException("No recipients in mailto");
        }
        this.to = new ArrayList();
        for (int i = 0; i < to.size(); ++i) {
            this.to.add(to.get(i));
        }
        if (attributes != null) {
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    this.setAttribute(key, attributes.get(key));
                }
                catch (IOException e) {}
            }
        }
    }

    public Object getAttribute(String name) throws IOException {
        if (this.attributes != null) {
            return this.attributes.get(name.toLowerCase());
        }
        return null;
    }

    public Iterator getAttributeNames() {
        if (this.attributes != null) {
            return this.attributes.keySet().iterator();
        }
        return new NullIterator();
    }

    public void setAttribute(String name, Object value) throws IOException {
        if ((name = name.toLowerCase()).equals("date") || name.equals("received") || name.equals("return-path") || name.equals("message-id")) {
            throw new IOException("cannot set property `" + name + "'");
        }
        if (name.equals("to")) {
            this.addTo((String)value);
            return;
        }
        if (name.equals("cc")) {
            this.addCc((String)value);
            return;
        }
        if (name.equals("bcc")) {
            this.addBcc((String)value);
            return;
        }
        if (name.equals("from")) {
            this.from = (String)value;
            return;
        }
        if (name.equals("sender")) {
            this.sender = (String)value;
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public void addTo(String to) throws IOException {
        StringCharCursor cursor = new StringCharCursor(to);
        ArrayList list = MailtoPath.parseAddressList(cursor);
        for (int i = 0; i < list.size(); ++i) {
            this.to.add(list.get(i));
        }
    }

    public void addCc(String to) throws IOException {
        StringCharCursor cursor = new StringCharCursor(to);
        ArrayList list = MailtoPath.parseAddressList(cursor);
        if (this.cc == null) {
            this.cc = list;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.cc.add(list.get(i));
            }
        }
    }

    public void addBcc(String to) throws IOException {
        StringCharCursor cursor = new StringCharCursor(to);
        ArrayList list = MailtoPath.parseAddressList(cursor);
        if (this.bcc == null) {
            this.bcc = list;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                this.bcc.add(list.get(i));
            }
        }
    }

    public String getFrom() {
        if (this.from != null) {
            return this.from;
        }
        return Registry.getString("/caucho.com/smtp.vfs/sender", null);
    }

    public String getSender() {
        if (this.sender != null) {
            return this.sender;
        }
        return Registry.getString("/caucho.com/smtp.vfs/sender", null);
    }

    private int readResponse(InputStream is, CharBuffer msg) throws IOException {
        int value;
        do {
            msg.clear();
            value = 0;
            int ch = is.read();
            if (ch >= 48 && ch <= 57) {
                while (ch >= 48 && ch <= 57) {
                    msg.append((char)ch);
                    value = 10 * value + ch - 48;
                    ch = is.read();
                }
            }
            if (ch == 45) {
                value = 0;
            }
            while (ch != 13 && ch != 10) {
                msg.append((char)ch);
                ch = is.read();
            }
            if (ch != 13) continue;
            ch = is.read();
        } while (value == 0);
        if (dbg.canWrite()) {
            dbg.println(msg);
        }
        return value;
    }

    void sendRecipients(ReadStream is, WriteStream os, ArrayList to, CharBuffer msg) throws IOException {
        if (to == null) {
            return;
        }
        for (int i = 0; i < to.size(); ++i) {
            MailtoPath.Recipient rcpt = (MailtoPath.Recipient)to.get(i);
            os.print("RCPT TO: ");
            os.print(rcpt.user);
            if (rcpt.host != null) {
                os.print("@");
                os.print(rcpt.host);
            }
            os.print("\r\n");
            if (dbg.canWrite()) {
                dbg.log("RCPT TO: " + rcpt.user + "@" + rcpt.host);
            }
            if (this.readResponse(is, msg) / 100 == 2) continue;
            throw new IOException("Expected '221' from SMTP: " + msg);
        }
    }

    private void writeMessageBody(WriteStream os) throws IOException {
        ReadStream is = this.openRead();
        int ch = is.read();
        if (ch < 0) {
            os.print(".\r\n");
            return;
        }
        while (ch >= 0) {
            if (ch == 10) {
                ch = is.read();
                if (ch == 46) {
                    os.print("\r\n..");
                    ch = is.read();
                    continue;
                }
                if (ch <= 0) {
                    os.print("\r\n.\r\n");
                    return;
                }
                os.print("\r\n");
                continue;
            }
            os.write(ch);
            ch = is.read();
        }
        os.print("\r\n.\r\n");
    }

    private void writeMessage(WriteStream os) throws IOException {
        String from = this.getFrom();
        os.print("From: ");
        if (from != null) {
            os.print(from);
        } else {
            os.print(CauchoSystem.getUserName());
            os.print("@");
            os.print(CauchoSystem.getLocalHost());
        }
        os.print("\r\n");
        String date = QDate.formatLocal(Alarm.getCurrentTime(), "%a, %d %b %Y %H:%M:%S %z");
        os.print("Date: " + date + "\r\n");
        os.print("To: ");
        this.writeMessageRecipients(os, this.to);
        if (this.cc != null && this.cc.size() > 0) {
            os.print("Cc: ");
            this.writeMessageRecipients(os, this.cc);
        }
        Iterator iter = this.getAttributeNames();
        while (iter != null && iter.hasNext()) {
            String key = (String)iter.next();
            Object value = this.getAttribute(key);
            if (value == null) continue;
            os.print(key);
            os.print(": ");
            os.print(String.valueOf(value));
            os.print("\r\n");
        }
        String sender = this.getSender();
        if (from != sender && !from.equals(sender)) {
            os.print("Sender: ");
            if (sender != null) {
                os.print(sender);
            } else {
                os.print(CauchoSystem.getUserName());
                os.print("@");
                os.print(CauchoSystem.getLocalHost());
            }
            os.print("\r\n");
        }
        os.print("\r\n");
        this.writeMessageBody(os);
    }

    private void writeMessageRecipients(WriteStream os, ArrayList list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            MailtoPath.Recipient rcpt = (MailtoPath.Recipient)list.get(i);
            if (i != 0) {
                os.print(", ");
            }
            os.print(rcpt.user);
            if (rcpt.host == null) continue;
            os.print("@");
            os.print(rcpt.host);
        }
        os.print("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        host = Registry.getString("/caucho.com/smtp.vfs/host", "localhost");
        port = Registry.getInt("/caucho.com/smtp.vfs/port", 25);
        sock = new Socket(host, port);
        msg = new CharBuffer();
        is = null;
        os = null;
        try {
            s = VfsStream.openReadWrite(sock.getInputStream(), sock.getOutputStream());
            is = s.getReadStream();
            os = s.getWriteStream();
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '220' from SMTP");
            }
            os.print("HELO ");
            os.print(CauchoSystem.getLocalHost());
            os.print("\r\n");
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '220' from SMTP");
            }
            os.print("MAIL FROM: ");
            sender = this.getSender();
            if (sender != null) {
                os.print(sender);
            } else {
                os.print(CauchoSystem.getUserName());
                os.print("@");
                os.print(CauchoSystem.getLocalHost());
            }
            os.print("\r\n");
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '250' from SMTP: " + msg);
            }
            this.sendRecipients(is, os, this.to, msg);
            if (this.cc != null) {
                this.sendRecipients(is, os, this.cc, msg);
            }
            if (this.bcc != null) {
                this.sendRecipients(is, os, this.bcc, msg);
            }
            os.print("DATA\r\n");
            if (this.readResponse(is, msg) / 100 != 3) {
                throw new IOException("Expected '354' from SMTP: " + msg);
            }
            this.writeMessage(os);
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '200' from SMTP: " + msg);
            }
            os.print("QUIT\r\n");
            if (this.readResponse(is, msg) / 100 != 2) {
                throw new IOException("Expected '250' from SMTP: " + msg);
            }
            var10_9 = null;
        }
        catch (Throwable var9_13) {
            var10_10 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            finally {
                sock.close();
            }
            this.destroy();
            throw var9_13;
        }
        try {
            if (is != null) {
                is.close();
            }
            if (os == null) ** GOTO lbl71
            os.close();
        }
        finally {
            sock.close();
        }
lbl71:
        // 2 sources

        this.destroy();
    }
}

