/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.FreeList;
import com.caucho.vfs.ReadStream;
import java.io.IOException;

public class TempBuffer {
    private static FreeList freeList = new FreeList(32);
    public static int SIZE = 8192;
    TempBuffer next;
    byte[] buf;
    int offset;
    int length;
    int bufferCount;

    public TempBuffer(int size) {
        this.buf = new byte[size];
    }

    public static TempBuffer allocate() {
        TempBuffer next = (TempBuffer)freeList.allocate();
        if (next == null) {
            return new TempBuffer(SIZE);
        }
        next.next = null;
        next.offset = 0;
        next.length = 0;
        next.bufferCount = 0;
        return next;
    }

    public void clear() {
        this.next = null;
        this.offset = 0;
        this.length = 0;
        this.bufferCount = 0;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getCapacity() {
        return this.buf.length;
    }

    public int write(byte[] buf, int offset, int length) {
        byte[] thisBuf = this.buf;
        int thisLength = this.length;
        if (thisBuf.length - thisLength < length) {
            length = thisBuf.length - thisLength;
        }
        System.arraycopy(buf, offset, thisBuf, thisLength, length);
        this.length += length;
        return length;
    }

    public static TempBuffer copyFromStream(ReadStream is) throws IOException {
        TempBuffer head;
        TempBuffer tail = head = TempBuffer.allocate();
        int len = 0;
        while ((len = is.readAll(tail.buf, 0, tail.buf.length)) == tail.buf.length) {
            TempBuffer buf = TempBuffer.allocate();
            tail.length = len;
            tail.next = buf;
            tail = buf;
        }
        if (len == 0 && head == tail) {
            return null;
        }
        if (len == 0) {
            TempBuffer ptr = head;
            while (ptr.getNext() != null) {
                TempBuffer next = ptr.getNext();
                if (next.getNext() == null) {
                    TempBuffer.free(next);
                    ptr.next = null;
                }
                ptr = ptr.getNext();
            }
        } else {
            tail.length = len;
        }
        return head;
    }

    public int getAvailable() {
        return this.buf.length - this.length;
    }

    public TempBuffer getNext() {
        return this.next;
    }

    public void setNext(TempBuffer next) {
        this.next = next;
    }

    public static void free(TempBuffer buf) {
        buf.next = null;
        if (buf.buf.length == SIZE) {
            freeList.free(buf);
        }
    }

    public static void freeAll(TempBuffer buf) {
        while (buf != null) {
            TempBuffer next = buf.next;
            buf.next = null;
            if (buf.buf.length == SIZE) {
                freeList.free(buf);
            }
            buf = next;
        }
    }
}

