/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QElementDef;
import com.caucho.xml.QEntity;
import com.caucho.xml.QNamedNodeMap;
import com.caucho.xml.QNode;
import com.caucho.xml.QNotation;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QDocumentType
extends QNode
implements DocumentType {
    String name;
    HashMap elements = new HashMap();
    HashMap entities = new HashMap();
    HashMap notations = new HashMap();
    HashMap parameterEntities = new HashMap();
    HashMap ids = new HashMap();
    String systemId;
    String publicId;
    boolean hasAttributeDefaults;

    public QDocumentType(String name) {
        this.name = name;
        this.entities.put("amp", new QEntity("amp", "&"));
        this.entities.put("lt", new QEntity("lt", "<"));
        this.entities.put("gt", new QEntity("gt", ">"));
        this.entities.put("quot", new QEntity("quot", "\""));
        this.entities.put("apos", new QEntity("apos", "'"));
    }

    public String getNodeName() {
        return "#documenttype";
    }

    public String getTagName() {
        return "#documenttype";
    }

    public short getNodeType() {
        return 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NamedNodeMap getEntities() {
        return new QNamedNodeMap(this.entities);
    }

    public NamedNodeMap getNotations() {
        return new QNamedNodeMap(this.notations);
    }

    Node importNode(QDocument owner, boolean deep) {
        QDocumentType ref = new QDocumentType(this.name);
        return ref;
    }

    void addNotation(QNotation notation) {
        this.notations.put(notation.name, notation);
    }

    public String getElementId(String element) {
        return (String)this.ids.get(element);
    }

    public Iterator getElementIdNames() {
        return this.ids.keySet().iterator();
    }

    void setElementId(String element, String id) {
        this.ids.put(element, id);
    }

    void addEntity(QEntity entity) {
        if (this.entities.get(entity.name) == null) {
            this.entities.put(entity.name, entity);
        }
    }

    QEntity getEntity(String name) {
        return (QEntity)this.entities.get(name);
    }

    void addParameterEntity(QEntity entity) {
        if (this.parameterEntities.get(entity.name) == null) {
            this.parameterEntities.put(entity.name, entity);
        }
    }

    QEntity getParameterEntity(String name) {
        return (QEntity)this.parameterEntities.get(name);
    }

    String getEntityValue(String name) {
        QEntity entity = (QEntity)this.entities.get(name);
        if (entity == null) {
            return null;
        }
        return entity.value;
    }

    public String getSystemId() {
        return this.systemId;
    }

    void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getInternalSubset() {
        return null;
    }

    boolean isExternal() {
        return this.systemId != null || this.publicId != null;
    }

    public QElementDef getElement(String name) {
        return (QElementDef)this.elements.get(name);
    }

    QElementDef addElement(String name) {
        QElementDef def = (QElementDef)this.elements.get(name);
        if (def == null) {
            def = new QElementDef(name);
            def.dtd = this;
            def.owner = this.owner;
            this.elements.put(name, def);
            this.appendChild(def);
        }
        return def;
    }

    void setAttributeDefaults() {
        this.hasAttributeDefaults = true;
    }

    boolean hasAttributeDefaults() {
        return this.hasAttributeDefaults;
    }

    void fillDefaults(QElement element) {
        if (!this.hasAttributeDefaults) {
            return;
        }
        QElementDef def = this.getElement(element.getNodeName());
        if (def != null) {
            def.fillDefaults(element);
        }
    }

    void print(XmlPrinter os) throws IOException {
        if (this.getName() == null) {
            return;
        }
        os.print("<!DOCTYPE ");
        os.print(this.getName());
        if (this.publicId != null) {
            os.print(" PUBLIC \"");
            os.print(this.publicId);
            os.print("\" \"");
            os.print(this.systemId);
            os.print("\"");
        } else if (this.systemId != null) {
            os.print(" SYSTEM \"");
            os.print(this.systemId);
            os.print("\"");
        }
        if (this.firstChild != null) {
            os.println(" [");
            QAbstractNode node = this.firstChild;
            while (node != null) {
                node.print(os);
                node = node.next;
            }
            os.print("]>");
        } else {
            os.print(">");
        }
    }
}

