/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QAttributedNode;
import com.caucho.xml.QDeepNodeList;
import com.caucho.xml.QDocument;
import com.caucho.xml.QName;
import com.caucho.xml.QNodePredicate;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class QElement
extends QAttributedNode
implements CauchoElement {
    private QName name;

    QElement() {
    }

    QElement(QName name) {
        this.name = name;
    }

    QElement(QName name, HashMap attributes) {
        this.name = name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public String getNodeName() {
        return this.name.getName();
    }

    public String getTagName() {
        return this.name.getName();
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public String getCanonicalName() {
        return this.name.getCanonicalName();
    }

    public String getNamespaceURI() {
        String uri = this.name.getNamespace();
        if (uri == "") {
            return null;
        }
        return uri;
    }

    public String getNamespace(String prefix) {
        if (prefix == null) {
            return this.getNamespace("", "xmlns");
        }
        return this.getNamespace(prefix, "xmlns:" + prefix);
    }

    private String getNamespace(String prefix, String xmlns) {
        Attr namespace = this.getAttributeNode(xmlns);
        if (namespace != null) {
            return namespace.getNodeValue();
        }
        if (this.parent instanceof QElement) {
            return ((QElement)this.parent).getNamespace(prefix, xmlns);
        }
        return this.owner.getNamespace(prefix);
    }

    public short getNodeType() {
        return 1;
    }

    public NodeList getElementsByTagName(String tagName) {
        QAbstractNode child = (QAbstractNode)this.getFirstChild();
        if (child != null) {
            return new QDeepNodeList(this, child, new TagPredicate(tagName));
        }
        return new QDeepNodeList(this, null, new TagPredicate(tagName));
    }

    public NodeList getElementsByTagNameNS(String uri, String name) {
        QAbstractNode child = (QAbstractNode)this.getFirstChild();
        if (child != null) {
            return new QDeepNodeList(this, child, new NSTagPredicate(uri, name));
        }
        return new QDeepNodeList(this, null, new NSTagPredicate(uri, name));
    }

    public Node appendChild(Node child) throws DOMException {
        Node result = super.appendChild(child);
        if (child instanceof QElement) {
            QElement elt = (QElement)child;
            QName name = elt.name;
            if (name.getNamespace() != "") {
                this.addNamespace(name);
            }
        }
        return result;
    }

    void addNamespace(QName name) {
        this.owner.addNamespace(name.getPrefix(), name.getNamespace());
    }

    public void normalize() {
        Node node = this.firstChild;
        while (node != null) {
            if (node.getNodeType() == 3 && node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3) {
                Text text = (Text)node;
                Text next = (Text)node.getNextSibling();
                text.appendData(next.getData());
                this.removeChild(next);
                continue;
            }
            if (node.getNodeType() == 1) {
                Element elt = (Element)node;
                elt.normalize();
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
    }

    Node importNode(QDocument owner, boolean deep) {
        QElement element = new QElement(this.name);
        element.owner = owner == null ? this.owner : owner;
        element.filename = this.filename;
        element.line = this.line;
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            element.setAttribute(attr.name, ((QAbstractNode)attr).getNodeValue());
            attr = attr.next;
        }
        if (!deep) {
            return element;
        }
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            element.appendChild(((QAbstractNode)node).importNode(owner, true));
        }
        return element;
    }

    public boolean hasContent() {
        return true;
    }

    public boolean equals(Object arg) {
        return this == arg;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    public String getTextValue() {
        CharBuffer cb = CharBuffer.allocate();
        QAbstractNode node = this.firstChild;
        while (node != null) {
            cb.append(node.getTextValue());
            node = node.next;
        }
        return cb.close();
    }

    void print(XmlPrinter out) throws IOException {
        Node node;
        out.startElement(this.getNamespaceURI(), this.getLocalName(), this.getNodeName());
        for (node = (QAbstractNode)((Object)this.getFirstAttribute()); node != null; node = (QAbstractNode)((QAbstractNode)node).getNextSibling()) {
            out.attribute(((QAbstractNode)node).getNamespaceURI(), ((QAbstractNode)node).getLocalName(), node.getNodeName(), ((QAbstractNode)node).getNodeValue());
        }
        for (node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ((QAbstractNode)node).print(out);
        }
        out.endElement(this.getNamespaceURI(), this.getLocalName(), this.getNodeName());
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("[Element " + this.name);
        for (QAttr attr = (QAttr)this.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
            cb.append(" " + attr);
        }
        cb.append("]");
        return cb.close();
    }

    static class NSTagPredicate
    implements QNodePredicate {
        String uri;
        String local;

        public boolean isMatch(QAbstractNode node) {
            return node.getLocalName().equals(this.local) && node.getNamespaceURI().equals(this.uri);
        }

        NSTagPredicate(String uri, String local) {
            this.uri = uri;
            this.local = local;
        }
    }

    static class TagPredicate
    implements QNodePredicate {
        String name;

        public boolean isMatch(QAbstractNode node) {
            return node.getNodeName().equals(this.name) || this.name.equals("*") && node instanceof Element;
        }

        TagPredicate(String name) {
            if (name == null) {
                name = "*";
            }
            this.name = name;
        }
    }
}

