/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QDocument;
import com.caucho.xml.QEntity;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

class QEntityReference
extends QNode
implements EntityReference {
    String name;

    QEntityReference(String name) {
        this.name = name;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getTagName() {
        return this.name;
    }

    public short getNodeType() {
        return 5;
    }

    private void lazyEvaluateChild() {
        if (this.owner == null || this.owner.dtd == null) {
            return;
        }
        QEntity entity = this.owner.dtd.getEntity(this.name);
        if (entity == null || entity.firstChild == null) {
            return;
        }
        this.firstChild = entity.firstChild;
        this.lastChild = entity.lastChild;
    }

    public Node getFirstChild() {
        if (this.firstChild != null) {
            return this.firstChild;
        }
        this.lazyEvaluateChild();
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.lastChild != null) {
            return this.lastChild;
        }
        this.lazyEvaluateChild();
        return this.lastChild;
    }

    Node importNode(QDocument owner, boolean deep) {
        QEntityReference ref = new QEntityReference(this.name);
        ref.owner = owner;
        return ref;
    }

    public void print(XmlPrinter os) throws IOException {
        if (os.finishAttributes()) {
            os.print(">");
        }
        os.print("&");
        os.print(this.getNodeName());
        os.print(";");
    }

    public String toString() {
        return "[EntityRef " + this.getNodeName() + "]";
    }
}

