/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.QAttributes;
import com.caucho.xml.QName;
import com.caucho.xml.XMLWriter;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXBuilder
implements XMLWriter,
Locator {
    private XMLReader saxReader;
    private ContentHandler contentHandler;
    private QAttributes attributes;
    private CharBuffer text = new CharBuffer();
    private boolean escapeText;
    private boolean hasElement;
    private String elementUri;
    private String elementLocalName;
    private String elementQName;
    private String filename;
    private int line;

    public SAXBuilder() {
        this.attributes = new QAttributes();
    }

    public SAXBuilder(XMLReader saxReader) {
        this();
        this.init(saxReader);
    }

    public void init(XMLReader saxReader) {
        this.saxReader = saxReader;
        this.contentHandler = saxReader.getContentHandler();
        this.init();
    }

    public void init() {
        this.text.clear();
        this.attributes.clear();
        this.hasElement = false;
        this.filename = null;
        this.line = 0;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void startDocument() throws IOException, SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
    }

    public void endDocument() throws IOException, SAXException {
        this.pop();
        this.contentHandler.endDocument();
    }

    public void setLocation(String filename, int line, int column) {
        this.filename = filename;
        this.line = line;
    }

    public String getSystemId() {
        return this.filename;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return 0;
    }

    public void startPrefixMapping(String prefix, String uri) throws IOException, SAXException {
        this.pop();
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws IOException, SAXException {
        this.pop();
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName) throws IOException, SAXException {
        this.pop();
        this.elementUri = uri;
        this.elementLocalName = localName;
        this.elementQName = qName;
        this.hasElement = true;
    }

    public void attribute(String uri, String localName, String qName, String value) throws IOException, SAXException {
        int p = qName.lastIndexOf(58);
        QName name = p > 0 ? new QName(qName.substring(0, p), localName, uri) : new QName("", qName, uri);
        this.attributes.add(name, value);
    }

    public void endElement(String uri, String localName, String qName) throws IOException, SAXException {
        this.pop();
        this.contentHandler.endElement(uri, localName, qName);
    }

    public void processingInstruction(String name, String data) throws IOException, SAXException {
        this.pop();
        this.contentHandler.processingInstruction(name, data);
    }

    public void comment(String data) throws IOException, SAXException {
        this.pop();
    }

    public boolean getEscapeText() {
        return this.escapeText;
    }

    public void setEscapeText(boolean isEscaped) {
        this.escapeText = isEscaped;
    }

    public void text(String text) throws IOException, SAXException {
        this.popElement();
        this.text.append(text);
    }

    public void text(char[] buffer, int offset, int length) throws IOException, SAXException {
        this.popElement();
        this.text.append(buffer, offset, length);
    }

    public void cdata(String text) throws IOException, SAXException {
        this.popElement();
        this.text(text);
    }

    public void cdata(char[] buffer, int offset, int length) throws IOException, SAXException {
        this.popElement();
        this.text(buffer, offset, length);
    }

    private void pop() throws IOException, SAXException {
        this.popElement();
        if (this.text.length() == 0) {
            return;
        }
        this.contentHandler.characters(this.text.getBuffer(), 0, this.text.getLength());
        this.text.clear();
    }

    private void popElement() throws IOException, SAXException {
        if (this.hasElement) {
            this.contentHandler.startElement(this.elementUri, this.elementLocalName, this.elementQName, this.attributes);
            this.hasElement = false;
            this.attributes.clear();
        }
    }
}

