/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.EnclosedWriteStream;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Entities;
import com.caucho.xml.HtmlEntities;
import com.caucho.xml.Latin1Entities;
import com.caucho.xml.OtherEntities;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.XmlEntities;
import com.caucho.xml.XmlLatin1Entities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XmlPrinter
implements XMLWriter {
    static WriteStream dbg = LogStream.open("/caucho.com/xml/printer");
    static L10N L = new L10N("com/caucho/xml/messages");
    private static final int NO_PRETTY = 0;
    private static final int INLINE = 1;
    private static final int NO_INDENT = 2;
    private static final int PRE = 3;
    private static final char OMITTED_SPACE = '\u0000';
    private static final char OMITTED_NEWLINE = '\u0001';
    private static final char OMITTED = '\u0002';
    private static final char NULL_SPACE = '\u0003';
    private static final char SPACE = '\u0004';
    private static final char NEWLINE = '\u0005';
    private static final char WHITESPACE = '\u0006';
    private static final int ALWAYS_EMPTY = 1;
    private static final int EMPTY_IF_EMPTY = 2;
    private static IntMap empties = new IntMap();
    private static HashMap booleanAttrs;
    private static HashMap verbatimTags;
    private static IntMap prettyMap;
    private WriteStream os;
    private char[] buffer = new char[256];
    private int capacity = this.buffer.length;
    private int length;
    boolean isAutomaticMethod = true;
    boolean isTop = true;
    boolean isJsp = false;
    String encoding;
    String method;
    boolean isText;
    boolean isHtml;
    boolean inHead;
    String version;
    boolean isAutomaticPretty = true;
    boolean isPretty;
    int indent;
    int preCount;
    int lastTextChar = 3;
    boolean hasMetaContentType = false;
    boolean includeContentType = true;
    boolean printDeclaration;
    String standalone;
    String systemId;
    String publicId;
    boolean escapeText = true;
    boolean inVerbatim = false;
    private HashMap namespace;
    private HashMap cdataElements;
    private Entities entities;
    private String mimeType;
    private ArrayList prefixList;
    private ArrayList attributeNames = new ArrayList();
    private ArrayList attributeValues = new ArrayList();
    private char[] cbuf = new char[256];
    private char[] abuf = new char[256];
    private LineMap lineMap;
    private int line;
    private String srcFilename;
    private int srcLine;
    private String currentElement;
    private Document currentDocument;
    private boolean isEnclosedStream;

    public XmlPrinter() {
    }

    public XmlPrinter(OutputStream os) {
        if (os instanceof WriteStream) {
            this.init((WriteStream)os);
        } else if (os instanceof EnclosedWriteStream) {
            this.init(((EnclosedWriteStream)((Object)os)).getWriteStream());
        } else {
            this.isEnclosedStream = true;
            WriteStream ws = Vfs.openWrite(os);
            try {
                ws.setEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.init(ws);
        }
    }

    public XmlPrinter(Writer writer) {
        if (writer instanceof EnclosedWriteStream) {
            this.init(((EnclosedWriteStream)((Object)writer)).getWriteStream());
        } else {
            this.isEnclosedStream = true;
            WriteStream ws = Vfs.openWrite(writer);
            this.init(ws);
        }
    }

    public void init(WriteStream os) {
        this.os = os;
        this.init();
    }

    void init() {
        this.encoding = null;
        if (this.os != null) {
            this.encoding = this.os.getEncoding();
        }
        this.length = 0;
        String mimeName = Encoding.getMimeName(this.encoding);
        this.entities = mimeName == null || mimeName.equals("US-ASCII") || mimeName.equals("ISO-8859-1") ? XmlLatin1Entities.create() : XmlEntities.create();
        this.namespace = new HashMap();
        this.line = 1;
        this.isTop = true;
        this.hasMetaContentType = false;
        this.attributeNames.clear();
        this.attributeValues.clear();
    }

    public static void printXml(OutputStream os, Node node) throws IOException {
        new XmlPrinter(os).printXml(node);
    }

    public static void printHtml(OutputStream os, Node node) throws IOException {
        new XmlPrinter(os).printHtml(node);
    }

    public static void printPrettyXml(OutputStream os, Node node) throws IOException {
        new XmlPrinter(os).printPrettyXml(node);
    }

    public void printXml(Node node) throws IOException {
        this.isAutomaticMethod = false;
        ((QAbstractNode)node).print(this);
        this.flush();
    }

    public void printHtml(Node node) throws IOException {
        this.setMethod("html");
        this.setVersion("4.0");
        ((QAbstractNode)node).print(this);
        this.flush();
    }

    public void printPrettyXml(Node node) throws IOException {
        this.isAutomaticMethod = false;
        this.setPretty(true);
        ((QAbstractNode)node).print(this);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printString(Node node) throws IOException {
        CharBuffer cb = CharBuffer.allocate();
        this.os = Vfs.openWrite(cb);
        this.init(this.os);
        try {
            ((QAbstractNode)node).print(this);
        }
        finally {
            this.flush();
            this.os.close();
        }
        return cb.close();
    }

    public void setEscaping(boolean escapeText) {
        if (!this.isText) {
            this.escapeText = escapeText;
        }
    }

    public boolean getEscaping() {
        return this.escapeText;
    }

    public void setMethod(String method) {
        this.method = method;
        if (method == null) {
            this.isAutomaticMethod = true;
            this.isHtml = false;
        } else if (method.equals("html")) {
            this.isAutomaticMethod = false;
            this.isHtml = true;
            if (this.isAutomaticPretty) {
                this.isPretty = true;
            }
        } else if (method.equals("text")) {
            this.isAutomaticMethod = false;
            this.isText = true;
            this.escapeText = false;
        } else {
            this.isAutomaticMethod = false;
            this.isHtml = false;
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        try {
            if (encoding != null) {
                this.os.setEncoding(encoding);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        if (this.method == null && mimeType != null && mimeType.equals("text/html")) {
            this.setMethod("html");
        }
    }

    public void setJSP(boolean isJsp) {
        this.isJsp = isJsp;
    }

    public boolean isJSP() {
        return this.isJsp;
    }

    boolean isHtml() {
        return this.isHtml;
    }

    public void setPretty(boolean isPretty) {
        this.isPretty = isPretty;
        this.isAutomaticPretty = false;
    }

    public boolean isPretty() {
        return this.isPretty;
    }

    public void setPrintDeclaration(boolean printDeclaration) {
        this.printDeclaration = printDeclaration;
    }

    boolean getPrintDeclaration() {
        return this.printDeclaration;
    }

    public void setStandalone(String standalone) {
        this.standalone = standalone;
    }

    String getStandalone() {
        return this.standalone;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    String getSystemId() {
        return this.systemId;
    }

    public void setIncludeContentType(boolean include) {
        this.includeContentType = include;
    }

    public boolean getIncludeContentType() {
        return this.includeContentType;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    String getPublicId() {
        return this.publicId;
    }

    public Path getPath() {
        if (this.os instanceof WriteStream) {
            return this.os.getPath();
        }
        return null;
    }

    public void setLineMap(String filename) {
        this.lineMap = new LineMap(filename);
    }

    public LineMap getLineMap() {
        return this.lineMap;
    }

    public void addCdataElement(String elt) {
        if (this.cdataElements == null) {
            this.cdataElements = new HashMap();
        }
        this.cdataElements.put(elt, "");
    }

    public void print(Node node) throws IOException {
        if (node instanceof QAbstractNode) {
            ((QAbstractNode)node).print(this);
        } else {
            this.printNode(node);
        }
        if (this.isEnclosedStream) {
            this.os.flush();
        }
    }

    public void printNode(Node node) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                this.startDocument((Document)node);
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.printNode(child);
                }
                this.endDocument();
                break;
            }
            case 1: {
                Element elt = (Element)node;
                this.startElement(elt.getNamespaceURI(), elt.getLocalName(), elt.getNodeName());
                NamedNodeMap attrs = elt.getAttributes();
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    this.attribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getNodeValue());
                }
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.printNode(child);
                }
                this.endElement(elt.getNamespaceURI(), elt.getLocalName(), elt.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                CharacterData text = (CharacterData)node;
                this.text(text.getData());
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                this.comment(comment.getData());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                this.processingInstruction(pi.getNodeName(), pi.getData());
                break;
            }
        }
    }

    WriteStream getStream() {
        return this.os;
    }

    public void startDocument(Document document) throws IOException {
        this.currentDocument = document;
        this.startDocument();
    }

    public void startDocument() throws IOException {
        this.isTop = true;
    }

    public void endDocument() throws IOException {
        if (this.isPretty && this.lastTextChar < 4) {
            this.println();
        }
        this.flush();
    }

    public void setLocation(String filename, int line, int column) {
        this.srcFilename = filename;
        this.srcLine = line;
    }

    public void startPrefixMapping(String prefix, String url) throws IOException {
    }

    public void endPrefixMapping(String prefix) throws IOException {
    }

    public void startElement(String url, String localName, String qName) throws IOException {
        if (this.isText) {
            return;
        }
        if (this.isAutomaticMethod) {
            boolean bl = this.isHtml = qName.equalsIgnoreCase("html") && (url == null || url.equals(""));
            if (this.isAutomaticPretty) {
                this.isPretty = this.isHtml;
            }
            this.isAutomaticMethod = false;
        }
        if (this.isTop) {
            this.printHeader(qName);
        }
        if (this.currentElement != null) {
            this.completeOpenTag();
        }
        this.attributeNames.clear();
        this.attributeValues.clear();
        if (this.isHtml && verbatimTags.get(qName.toLowerCase()) != null) {
            this.inVerbatim = true;
        }
        if (this.isPretty && this.preCount <= 0) {
            this.printPrettyStart(qName);
        }
        if (this.lineMap != null && this.srcFilename != null) {
            this.lineMap.add(this.srcFilename, this.srcLine, this.line);
        }
        this.print('<');
        this.print(qName);
        this.currentElement = qName;
        this.lastTextChar = 3;
    }

    private void printHeader(String top) throws IOException {
        this.isTop = false;
        String encoding = this.encoding;
        if (encoding != null && encoding.equals("UTF-16")) {
            this.print('\ufeff');
        }
        if (this.isHtml) {
            double dVersion = 4.0;
            if (this.version != null && this.version.compareTo("4.0") < 0) {
                dVersion = 3.2;
            }
            if (this.systemId != null || this.publicId != null) {
                this.printDoctype("html");
            }
            String mimeName = Encoding.getMimeName(encoding);
            this.entities = encoding == null || encoding.equalsIgnoreCase("us-ascii") ? HtmlEntities.create(dVersion) : (mimeName == null || mimeName.equals("ISO-8859-1") ? Latin1Entities.create(dVersion) : (mimeName.equals("US-ASCII") ? HtmlEntities.create(dVersion) : OtherEntities.create(dVersion)));
        } else {
            String mimeName;
            if (this.printDeclaration) {
                this.print("<?xml version=\"1.0\"");
                if (!(encoding == null || encoding.equals("") || encoding.equals("UTF-16") || encoding.equals("US-ASCII"))) {
                    this.print(" encoding=\"" + encoding + "\"");
                }
                if (this.standalone != null && (this.standalone.equals("true") || this.standalone.equals("yes"))) {
                    this.print(" standalone=\"yes\"");
                }
                this.println("?>");
                this.printDoctype(top);
            }
            this.entities = (mimeName = Encoding.getMimeName(encoding)) == null || mimeName.equals("US-ASCII") || mimeName.equals("ISO-8859-1") ? XmlLatin1Entities.create() : XmlEntities.create();
        }
        this.lastTextChar = 5;
    }

    private void printDoctype(String topElt) throws IOException {
        QDocumentType dtd;
        if (this.publicId != null && this.systemId != null) {
            this.println("<!DOCTYPE " + topElt + " PUBLIC \"" + this.publicId + "\" \"" + this.systemId + "\">");
        } else if (this.publicId != null) {
            this.println("<!DOCTYPE " + topElt + " PUBLIC \"" + this.publicId + "\">");
        } else if (this.systemId != null) {
            this.println("<!DOCTYPE " + topElt + " SYSTEM \"" + this.systemId + "\">");
        } else if (this.currentDocument instanceof QDocument && (dtd = (QDocumentType)this.currentDocument.getDoctype()) != null && dtd.getName() != null) {
            dtd.print(this);
            this.println();
        }
    }

    private void printPrettyStart(String qName) throws IOException {
        int code;
        int n = code = this.isHtml ? prettyMap.get(qName.toLowerCase()) : -1;
        if (code == 0) {
            if (this.lastTextChar == 1) {
                this.println();
            } else if (this.lastTextChar == 0) {
                this.print(' ');
            }
        } else if (code != 1 && this.lastTextChar < 6) {
            if (this.lastTextChar != 5) {
                this.println();
            }
            for (int i = 0; i < this.indent; ++i) {
                this.print(' ');
            }
        } else if (code == 1 && this.lastTextChar < 6) {
            if (this.lastTextChar == 1) {
                this.println();
            } else if (this.lastTextChar == 0) {
                this.print(' ');
            }
        }
        if (!this.isHtml || code < 0) {
            this.indent += 2;
        }
        if (code == 3) {
            ++this.preCount;
            this.lastTextChar = 97;
        } else {
            this.lastTextChar = code == 0 || code == 1 ? 97 : 3;
        }
    }

    public void attribute(String uri, String localName, String qName, String value) throws IOException {
        if (this.isText) {
            return;
        }
        if (this.currentElement == null) {
            if (qName.equals("encoding")) {
                this.encoding = value;
                return;
            }
            if (!qName.startsWith("xmlns")) {
                throw new IOException(L.l("attribute `{0}' outside element.", qName));
            }
        }
        if ((qName = qName.intern()).startsWith("xmlns")) {
            if (localName == null) {
                localName = "";
            }
            if (this.isHtml && localName.equals("")) {
                return;
            }
            this.namespace.put(localName, value);
            if (this.prefixList == null) {
                this.prefixList = new ArrayList();
            }
            if (!this.prefixList.contains(localName)) {
                this.prefixList.add(localName);
            }
            return;
        }
        if (qName.equals("xtp:jsp-attribute")) {
            this.attributeNames.add("<%= " + value + "%>");
            this.attributeValues.add(null);
            return;
        }
        if (this.isHtml && !this.hasMetaContentType && this.currentElement.equals("meta") && qName.equalsIgnoreCase("http-equiv") && value.equalsIgnoreCase("content-type")) {
            this.hasMetaContentType = true;
        }
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            String oldName = (String)this.attributeNames.get(i);
            if (oldName != qName) continue;
            this.attributeValues.set(i, value);
            return;
        }
        if (qName == null || qName.equals("")) {
            throw new NullPointerException();
        }
        this.attributeNames.add(qName);
        this.attributeValues.add(value);
    }

    public boolean finishAttributes() throws IOException {
        int i;
        if (this.currentElement == null) {
            return false;
        }
        for (i = 0; i < this.attributeNames.size(); ++i) {
            String qName = (String)this.attributeNames.get(i);
            String value = (String)this.attributeValues.get(i);
            if (this.isHtml && booleanAttrs.get(qName.toLowerCase()) != null && (value == null || value.equals("") || value.equals(qName))) {
                this.print(' ');
                this.print(qName);
                continue;
            }
            this.print(' ');
            this.print(qName);
            if (value != null) {
                this.print("=\"");
                if (!this.escapeText || this.inVerbatim) {
                    this.print(value);
                } else {
                    int len = value.length();
                    int offset = 0;
                    while (len > this.abuf.length) {
                        value.getChars(offset, offset + this.abuf.length, this.abuf, 0);
                        this.entities.printText(this, this.abuf, 0, this.abuf.length, true);
                        len -= this.abuf.length;
                        offset += this.abuf.length;
                    }
                    value.getChars(offset, offset + len, this.abuf, 0);
                    this.entities.printText(this, this.abuf, 0, len, true);
                }
                this.print('\"');
                continue;
            }
            if (this.isHtml) continue;
            this.print("=\"\"");
        }
        if (this.prefixList != null && this.prefixList.size() > 0) {
            for (i = 0; i < this.prefixList.size(); ++i) {
                String prefix = (String)this.prefixList.get(i);
                String url = (String)this.namespace.get(prefix);
                if (prefix.equals("")) {
                    this.print(" xmlns=\"");
                    this.print(url);
                    this.print('\"');
                    continue;
                }
                if (prefix.startsWith("xmlns:")) {
                    this.println(" ");
                    this.print(prefix);
                    this.print("=\"");
                    this.print(url);
                    this.print('\"');
                    continue;
                }
                this.print(" xmlns:");
                this.print(prefix);
                this.print("=\"");
                this.print(url);
                this.print('\"');
            }
            this.prefixList.clear();
            this.namespace.clear();
        }
        this.currentElement = null;
        return true;
    }

    public void endElement(String uri, String localName, String qName) throws IOException {
        boolean isEmpty;
        String normalName;
        if (this.isText) {
            return;
        }
        String string = normalName = this.isHtml ? qName.toLowerCase() : qName;
        if (this.isHtml && verbatimTags.get(normalName) != null) {
            this.inVerbatim = false;
        }
        int prevTextChar = this.lastTextChar;
        boolean bl = isEmpty = this.currentElement != null;
        if (this.currentElement != null) {
            this.finishAttributes();
        }
        if (this.isHtml && !this.hasMetaContentType && normalName.equals("head")) {
            if (isEmpty) {
                this.print(">");
            }
            isEmpty = false;
            this.printMetaContentType();
            this.currentElement = null;
        }
        if (isEmpty) {
            int empty = empties.get(normalName);
            if (this.isHtml && empty >= 0) {
                this.print(">");
            } else {
                if (prevTextChar <= 2) {
                    this.print(">");
                    this.printPrettyEnd(qName);
                    this.print("</");
                    this.print(qName);
                    this.print(">");
                    return;
                }
                if (this.isHtml) {
                    this.print("></");
                    this.print(qName);
                    this.print(">");
                } else {
                    this.print("/>");
                }
            }
            if (this.isPretty) {
                this.closePretty(qName);
            }
        } else if (this.isHtml && empties.get(normalName) == 1 && !normalName.equals("p")) {
            if (this.isPretty) {
                this.closePretty(qName);
            }
        } else if (this.isPretty) {
            this.printPrettyEnd(qName);
            this.print("</");
            this.print(qName);
            this.print(">");
        } else {
            this.print("</");
            this.print(qName);
            this.print(">");
        }
        this.currentElement = null;
    }

    private void printPrettyEnd(String qName) throws IOException {
        int code;
        int n = code = this.isHtml ? prettyMap.get(qName.toLowerCase()) : -1;
        if (code == 3) {
            --this.preCount;
            this.lastTextChar = 3;
            return;
        }
        if (this.preCount > 0) {
            return;
        }
        if (code == 0) {
            if (this.lastTextChar <= 2) {
                this.println();
            }
            this.lastTextChar = 97;
            return;
        }
        if (code == 1) {
            this.lastTextChar = 3;
            return;
        }
        if (!this.isHtml || code < 0) {
            this.indent -= 2;
        }
        if (this.lastTextChar <= 6) {
            if (this.lastTextChar != 5) {
                this.println();
            }
            for (int i = 0; i < this.indent; ++i) {
                this.print(' ');
            }
        }
        this.lastTextChar = 3;
    }

    private void closePretty(String qName) {
        int code;
        int n = code = this.isHtml ? prettyMap.get(qName.toLowerCase()) : -1;
        if (code == 3) {
            --this.preCount;
            this.lastTextChar = 3;
            return;
        }
        if (this.preCount > 0) {
            return;
        }
        if (!this.isHtml || code < 0) {
            this.indent -= 2;
        }
        this.lastTextChar = code != 0 ? 3 : 97;
    }

    public void processingInstruction(String name, String data) throws IOException {
        if (this.isText) {
            return;
        }
        if (this.currentElement != null) {
            this.completeOpenTag();
        }
        if (this.isTop && !this.isHtml && !this.isAutomaticMethod) {
            this.printHeader(null);
            this.isTop = false;
        }
        this.print("<?");
        this.print(name);
        if (data != null && data.length() > 0) {
            this.print(" ");
            this.print(data);
        }
        if (this.isHtml()) {
            this.print(">");
        } else {
            this.print("?>");
        }
        this.lastTextChar = 3;
    }

    public void comment(String data) throws IOException {
        if (this.isText) {
            return;
        }
        int textChar = this.lastTextChar;
        if (this.currentElement != null) {
            this.completeOpenTag();
        }
        if (this.isPretty && this.preCount <= 0 && (textChar == 1 || textChar == 3)) {
            this.println();
            for (int i = 0; i < this.indent; ++i) {
                this.print(' ');
            }
        }
        this.print("<!--");
        this.print(data);
        this.print("-->");
        this.lastTextChar = 3;
    }

    public boolean getEscapeText() {
        return this.escapeText;
    }

    public void setEscapeText(boolean isEscaped) {
        this.escapeText = isEscaped;
    }

    public void text(String text) throws IOException {
        int length = text.length();
        for (int offset = 0; offset < length; offset += this.cbuf.length) {
            int sublen = length - offset;
            if (sublen > this.cbuf.length) {
                sublen = this.cbuf.length;
            }
            text.getChars(offset, offset + sublen, this.cbuf, 0);
            this.text(this.cbuf, 0, sublen);
        }
    }

    public void text(char[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int prevTextChar = this.lastTextChar;
        if ((this.isPretty && this.preCount <= 0 || this.isTop) && !this.isText && this.trimPrettyWhitespace(buffer, offset, length)) {
            if (prevTextChar <= 6) {
                return;
            }
            if (this.lastTextChar == 0) {
                this.lastTextChar = 4;
            }
            if (this.lastTextChar == 1) {
                this.lastTextChar = 5;
            }
        }
        int nextTextChar = this.lastTextChar;
        if (this.currentElement != null) {
            this.completeOpenTag();
            if (this.isPretty && this.preCount <= 0 && prevTextChar <= 2) {
                this.println();
            }
        }
        this.lastTextChar = nextTextChar;
        if (this.isTop) {
            if (!this.isJsp) {
                this.isTop = false;
            } else if (!this.isAutomaticMethod && !this.isHtml) {
                this.printHeader(null);
                this.isTop = false;
            }
        }
        if (this.isHtml && !this.hasMetaContentType && !this.inHead) {
            int textChar = this.lastTextChar;
            if (this.isPretty && this.preCount <= 0 && prevTextChar <= 2) {
                this.println();
            }
            this.lastTextChar = textChar;
            prevTextChar = 97;
        }
        if (this.isPretty && this.preCount <= 0) {
            char ch;
            if (prevTextChar == 1) {
                if (buffer[offset] != '\n') {
                    this.println();
                }
            } else if (prevTextChar == 0 && (ch = buffer[offset]) != ' ' && ch != '\n') {
                this.print(' ');
            }
        }
        if (this.lineMap != null && this.srcFilename != null) {
            this.lineMap.add(this.srcFilename, this.srcLine, this.line);
        }
        if (!this.escapeText || this.inVerbatim || this.entities == null) {
            this.print(buffer, offset, length);
        } else {
            this.entities.printText(this, buffer, offset, length, false);
        }
    }

    boolean trimPrettyWhitespace(char[] buffer, int offset, int length) {
        int i;
        int textChar = 97;
        for (i = length - 1; i >= 0; --i) {
            char ch = buffer[offset + i];
            if (ch == '\r' || ch == '\n') {
                if (textChar == 5) continue;
                textChar = 1;
                continue;
            }
            if (ch == ' ' || ch == '\t') {
                if (textChar != 97 && textChar != 3) continue;
                textChar = 0;
                continue;
            }
            if (textChar == 1) {
                textChar = 5;
                break;
            }
            if (textChar != 0) break;
            textChar = 4;
            break;
        }
        this.lastTextChar = textChar;
        return i < 0 && textChar <= 6;
    }

    public void cdata(String text) throws IOException {
        if (text.length() == 0) {
            return;
        }
        this.isTop = false;
        if (this.currentElement != null) {
            this.completeOpenTag();
        }
        if (this.lineMap != null && this.srcFilename != null) {
            this.lineMap.add(this.srcFilename, this.srcLine, this.line);
        }
        this.print("<![CDATA[");
        this.print(text);
        this.print("]]>");
        this.lastTextChar = 5;
    }

    private void completeOpenTag() throws IOException {
        boolean isHead = this.isHtml && !this.hasMetaContentType && this.currentElement.equalsIgnoreCase("head");
        this.finishAttributes();
        this.print(">");
        if (isHead) {
            this.printHeadContentType();
        }
    }

    public void cdata(char[] buffer, int offset, int length) throws IOException {
        this.cdata(new String(buffer, offset, length));
    }

    private void printHeadContentType() throws IOException {
        this.printMetaContentType();
    }

    private void printMetaContentType() throws IOException {
        String mimeType;
        if (!this.includeContentType) {
            return;
        }
        this.hasMetaContentType = true;
        if (this.lastTextChar != 5) {
            this.println();
        }
        if (this.encoding == null || this.encoding.equals("US-ASCII")) {
            this.encoding = "ISO-8859-1";
        }
        if ((mimeType = this.mimeType) == null) {
            mimeType = "text/html";
        }
        this.println("  <meta http-equiv=\"Content-Type\" content=\"" + mimeType + "; charset=" + this.encoding + "\">");
        this.lastTextChar = 5;
    }

    void printDecl(String text) throws IOException {
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '#') {
                        this.print("&#38;");
                        continue block6;
                    }
                    this.print(ch);
                    continue block6;
                }
                case '\"': {
                    this.print("&#34;");
                    continue block6;
                }
                case '\'': {
                    this.print("&#39;");
                    continue block6;
                }
                case '\n': {
                    this.print("\n");
                    continue block6;
                }
                default: {
                    this.print(ch);
                }
            }
        }
    }

    void println() throws IOException {
        this.print('\n');
    }

    void println(String text) throws IOException {
        this.print(text);
        this.println();
    }

    void print(char[] buf) throws IOException {
        this.print(buf, 0, buf.length);
    }

    void print(char[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.print(buf[off + i]);
        }
    }

    void print(String text) throws IOException {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            this.print(ch);
        }
    }

    void print(char ch) throws IOException {
        if (this.length >= this.capacity) {
            this.os.print(this.buffer, 0, this.length);
            this.length = 0;
        }
        this.buffer[this.length++] = ch;
        if (ch == '\n') {
            ++this.line;
        }
    }

    void print(int i) throws IOException {
        if (i >= 0) {
            if (i < 10) {
                this.print((char)(48 + i));
                return;
            }
            if (i < 100) {
                this.print((char)(48 + i / 10));
                this.print((char)(48 + i % 10));
                return;
            }
        }
        if (this.length >= 0) {
            this.os.print(this.buffer, 0, this.length);
            this.length = 0;
        }
        this.os.print(i);
    }

    private void flush() throws IOException {
        if (this.length >= 0) {
            this.os.print(this.buffer, 0, this.length);
            this.length = 0;
        }
        if (this.isEnclosedStream) {
            this.os.flush();
        }
    }

    private void close() throws IOException {
        this.flush();
        if (this.isEnclosedStream) {
            this.os.close();
        }
    }

    static void add(IntMap map, String name, int value) {
        map.put(name, value);
        map.put(name.toUpperCase(), value);
    }

    static void add(HashMap map, String name) {
        map.put(name, name);
        map.put(name.toUpperCase(), name);
    }

    static {
        XmlPrinter.add(empties, "basefont", 1);
        XmlPrinter.add(empties, "br", 1);
        XmlPrinter.add(empties, "area", 1);
        XmlPrinter.add(empties, "link", 1);
        XmlPrinter.add(empties, "img", 1);
        XmlPrinter.add(empties, "param", 1);
        XmlPrinter.add(empties, "hr", 1);
        XmlPrinter.add(empties, "input", 1);
        XmlPrinter.add(empties, "col", 1);
        XmlPrinter.add(empties, "frame", 1);
        XmlPrinter.add(empties, "isindex", 1);
        XmlPrinter.add(empties, "base", 1);
        XmlPrinter.add(empties, "meta", 1);
        XmlPrinter.add(empties, "li", 1);
        XmlPrinter.add(empties, "p", 2);
        XmlPrinter.add(empties, "option", 2);
        booleanAttrs = new HashMap();
        XmlPrinter.add(booleanAttrs, "checked");
        XmlPrinter.add(booleanAttrs, "compact");
        XmlPrinter.add(booleanAttrs, "declare");
        XmlPrinter.add(booleanAttrs, "defer");
        XmlPrinter.add(booleanAttrs, "disabled");
        XmlPrinter.add(booleanAttrs, "ismap");
        XmlPrinter.add(booleanAttrs, "multiple");
        XmlPrinter.add(booleanAttrs, "nohref");
        XmlPrinter.add(booleanAttrs, "noresize");
        XmlPrinter.add(booleanAttrs, "noshade");
        XmlPrinter.add(booleanAttrs, "nowrap");
        XmlPrinter.add(booleanAttrs, "readonly");
        XmlPrinter.add(booleanAttrs, "selected");
        prettyMap = new IntMap();
        XmlPrinter.add(prettyMap, "img", 0);
        XmlPrinter.add(prettyMap, "a", 0);
        XmlPrinter.add(prettyMap, "td", 0);
        XmlPrinter.add(prettyMap, "th", 0);
        XmlPrinter.add(prettyMap, "embed", 0);
        XmlPrinter.add(prettyMap, "tt", 1);
        XmlPrinter.add(prettyMap, "i", 1);
        XmlPrinter.add(prettyMap, "b", 1);
        XmlPrinter.add(prettyMap, "big", 1);
        XmlPrinter.add(prettyMap, "em", 1);
        XmlPrinter.add(prettyMap, "string", 1);
        XmlPrinter.add(prettyMap, "dfn", 1);
        XmlPrinter.add(prettyMap, "code", 1);
        XmlPrinter.add(prettyMap, "samp", 1);
        XmlPrinter.add(prettyMap, "kbd", 1);
        XmlPrinter.add(prettyMap, "var", 1);
        XmlPrinter.add(prettyMap, "cite", 1);
        XmlPrinter.add(prettyMap, "abbr", 1);
        XmlPrinter.add(prettyMap, "acronym", 1);
        XmlPrinter.add(prettyMap, "object", 1);
        XmlPrinter.add(prettyMap, "q", 1);
        XmlPrinter.add(prettyMap, "sub", 1);
        XmlPrinter.add(prettyMap, "sup", 1);
        XmlPrinter.add(prettyMap, "font", 1);
        XmlPrinter.add(prettyMap, "small", 1);
        XmlPrinter.add(prettyMap, "span", 1);
        XmlPrinter.add(prettyMap, "bdo", 1);
        XmlPrinter.add(prettyMap, "jsp:expression", 1);
        XmlPrinter.add(prettyMap, "textarea", 3);
        XmlPrinter.add(prettyMap, "pre", 3);
        XmlPrinter.add(prettyMap, "html", 2);
        XmlPrinter.add(prettyMap, "body", 2);
        XmlPrinter.add(prettyMap, "ul", 2);
        XmlPrinter.add(prettyMap, "table", 2);
        XmlPrinter.add(prettyMap, "frameset", 2);
        verbatimTags = new HashMap();
        XmlPrinter.add(verbatimTags, "script");
        XmlPrinter.add(verbatimTags, "style");
    }
}

