/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeListIterator
extends NodeIterator {
    protected NodeIterator parentIter;
    protected NamedNodeMap attributeMap;
    protected Node _node;
    protected int index;
    protected AbstractPattern match;

    protected AttributeListIterator(ExprEnvironment env) {
        super(env);
    }

    public AttributeListIterator(NodeIterator parentIter, ExprEnvironment env, AbstractPattern match) throws XPathException {
        super(env);
        this.parentIter = parentIter;
        this.match = match;
        this._node = this.findFirstMatchingNode();
    }

    public boolean hasNext() {
        return this._node != null;
    }

    public Node nextNode() throws XPathException {
        Node node = this._node;
        this._node = this.findFirstMatchingNode();
        return node;
    }

    private Node findFirstMatchingNode() throws XPathException {
        Node node = null;
        while (true) {
            Node parent;
            if (node != null && (this.match == null || this.match.match(node, this.env))) {
                ++this.position;
                return node;
            }
            if (this.attributeMap != null && this.index < this.attributeMap.getLength()) {
                node = this.attributeMap.item(this.index++);
                continue;
            }
            if (this.parentIter == null || (parent = this.parentIter.nextNode()) == null) {
                return null;
            }
            if (!(parent instanceof Element)) continue;
            this.position = 0;
            this.size = 0;
            this.index = 0;
            this.attributeMap = ((Element)parent).getAttributes();
        }
    }

    public int getContextSize() {
        if (this.attributeMap == null) {
            return 0;
        }
        return this.attributeMap.getLength();
    }

    public Object clone() {
        AttributeListIterator iter = new AttributeListIterator(this.env);
        iter.copy(this);
        if (this.parentIter != null) {
            iter.parentIter = (NodeIterator)this.parentIter.clone();
        }
        iter._node = this._node;
        iter.index = this.index;
        iter.attributeMap = this.attributeMap;
        iter.match = this.match;
        return iter;
    }

    public String toString() {
        return "[AttributeListIterator " + this.match + "]";
    }
}

