/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import org.w3c.dom.Node;

public class NSNamePattern
extends AbstractPattern {
    private NSNamePattern match;
    private String namespace;
    private String local;
    private int nodeType;

    public NSNamePattern(AbstractPattern parent, String namespace, String local, int nodeType) {
        super(parent);
        this.nodeType = nodeType;
        this.namespace = namespace != null ? namespace.intern() : null;
        this.local = local.intern();
    }

    public double getPriority() {
        return 0.0;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this.nodeType) {
            return false;
        }
        if (!node.getLocalName().equals(this.local)) {
            return false;
        }
        if (this.namespace != node.getNamespaceURI()) {
            if (this.namespace == null) {
                return false;
            }
            if (!this.namespace.equals(node.getNamespaceURI())) {
                return false;
            }
        }
        return this.parent == null || this.parent.match(node, env);
    }

    public AbstractPattern copyPosition() {
        if (this.match == null) {
            AbstractPattern parent = null;
            if (this.parent != null) {
                parent = this.parent.copyPosition();
            }
            this.match = new NSNamePattern(parent, this.namespace, this.local, this.nodeType);
        }
        return this.match;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NSNamePattern)) {
            return false;
        }
        NSNamePattern bPattern = (NSNamePattern)b;
        return this.nodeType == bPattern.nodeType && this.local.equals(bPattern.local) && this.namespace.equals(bPattern.namespace) && (this.parent == bPattern.parent || this.parent != null && this.parent.equals(bPattern.parent));
    }

    public String toString() {
        return this.parent + "{" + this.namespace + "}" + this.local;
    }
}

