/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import org.w3c.dom.Node;

public class SelectedNode {
    protected Node node;
    protected int depth;
    protected int level;

    public SelectedNode(Node node) {
        Node ptr;
        this.node = node;
        this.depth = 0;
        for (ptr = node; ptr != null; ptr = ptr.getParentNode()) {
            ++this.depth;
        }
        this.level = 0;
        for (ptr = node; ptr != null; ptr = ptr.getPreviousSibling()) {
            ++this.level;
        }
    }

    public Node getNode() {
        return this.node;
    }

    public int compareTo(SelectedNode b) {
        int aDepth = this.depth;
        int bDepth = b.depth;
        Node aPtr = this.getNode();
        Node bPtr = b.getNode();
        if (aDepth == bDepth && aPtr.getParentNode() == bPtr.getParentNode()) {
            return this.level - b.level;
        }
        return SelectedNode.compareTo(aPtr, aDepth, bPtr, bDepth);
    }

    static int compareTo(Node aPtr, int aDepth, Node bPtr, int bDepth) {
        Node bParent;
        Node aParent;
        int depth;
        for (depth = aDepth; depth > bDepth; --depth) {
            aPtr = aPtr.getParentNode();
        }
        for (depth = bDepth; depth > aDepth; --depth) {
            bPtr = bPtr.getParentNode();
        }
        while ((aParent = aPtr.getParentNode()) != (bParent = bPtr.getParentNode())) {
            aPtr = aParent;
            bPtr = bParent;
        }
        if (aPtr == bPtr) {
            return aDepth - bDepth;
        }
        while (aPtr != null) {
            if (aPtr == bPtr) {
                return 1;
            }
            aPtr = aPtr.getPreviousSibling();
        }
        return -1;
    }
}

