/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.fun;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.LooseHtml;
import com.caucho.xml.QDocument;
import com.caucho.xml.Xml;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xsl.TransformerImpl;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class DocumentFun
extends XPathFun {
    static WriteStream dbg = LogStream.open("/caucho.com/xsl/document");
    TransformerImpl transformer;
    boolean isHtml;

    public DocumentFun(TransformerImpl transformer) {
        this.transformer = transformer;
    }

    public void setHtml(boolean isHtml) {
        this.isHtml = isHtml;
    }

    public Object eval(Node node, ExprEnvironment env, AbstractPattern pattern, ArrayList args) throws XPathException {
        Path path;
        if (args.size() < 1) {
            return null;
        }
        Node basenode = Expr.toNode(args.get(0));
        String name = Expr.toString(args.get(0));
        if (args.size() > 1) {
            basenode = Expr.toNode(args.get(1));
        }
        Path stylesheetPath = env.getStylesheetEnv().getPath();
        URIResolver resolver = this.transformer.getURIResolver();
        if (name == null || name.equals("")) {
            name = stylesheetPath.getTail();
        }
        String systemId = null;
        DocumentType dtd = null;
        Document owner = null;
        if (basenode != null) {
            if (basenode.getOwnerDocument() != null) {
                owner = basenode.getOwnerDocument();
                dtd = owner.getDoctype();
            } else if (basenode instanceof Document) {
                owner = (Document)basenode;
                dtd = owner.getDoctype();
            }
        }
        Path pwd = stylesheetPath.getParent();
        if (owner instanceof QDocument) {
            systemId = ((QDocument)owner).getFilename();
        }
        if (systemId == null && dtd != null) {
            systemId = dtd.getSystemId();
        }
        if (systemId == null && basenode instanceof CauchoNode) {
            systemId = ((CauchoNode)basenode).getFilename();
        }
        if (systemId == null) {
            systemId = env.getStylesheetEnv().getPath().getURL();
        }
        Node doc = null;
        Source source = null;
        if (resolver != null) {
            try {
                source = resolver.resolve(name, systemId);
            }
            catch (TransformerException e) {
                throw new XPathException(e);
            }
        }
        if (source != null) {
            systemId = source.getSystemId();
            path = pwd.lookup(systemId);
        } else if (systemId != null) {
            pwd = pwd.lookup(systemId).getParent();
            path = pwd.lookup(name);
        } else {
            path = pwd.lookup(name);
        }
        this.transformer.addCacheDepend(path);
        if (env instanceof Env) {
            doc = (Node)((Env)env).getCache(path);
        }
        if (doc != null) {
            return doc;
        }
        try {
            doc = this.isHtml ? new LooseHtml().parseDocument(path) : new Xml().parseDocument(path);
        }
        catch (Exception e) {
            dbg.log(e);
        }
        if (env instanceof Env && source == null) {
            ((Env)env).setCache(path, doc);
        }
        return doc;
    }
}

