/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlLinkedList
extends BaseList
implements HsqlList {
    private Node first;
    private Node last;

    public HsqlLinkedList() {
        this.last = this.first = new Node(null, null);
        this.elementCount = 0;
    }

    public void add(int n, Object object) {
        if (n == this.size()) {
            this.add(object);
        } else {
            if (n > this.size()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + n + " > " + this.size());
            }
            Node node = this.getInternal(n);
            Node node2 = new Node(node.data, node.next);
            node.data = object;
            node.next = node2;
            ++this.elementCount;
            if (this.last == node) {
                this.last = node2;
            }
        }
    }

    public boolean add(Object object) {
        this.last = this.last.next = new Node(object, null);
        ++this.elementCount;
        return true;
    }

    public Object get(int n) {
        return this.getInternal((int)n).data;
    }

    public Object remove(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.size());
        }
        Node node = n == 0 ? this.first : this.getInternal(n - 1);
        Node node2 = node.next;
        node.next = node2.next;
        --this.elementCount;
        if (this.last == node2) {
            this.last = node;
        }
        return node2.data;
    }

    public Object set(int n, Object object) {
        Node node = this.getInternal(n);
        Object object2 = node.data;
        node.data = object;
        return object2;
    }

    public final int size() {
        return this.elementCount;
    }

    protected final Node getInternal(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.size());
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        if (n == 0) {
            return this.first.next;
        }
        if (n == this.size() - 1) {
            return this.last;
        }
        Node node = this.first.next;
        for (int i = 0; i < n; ++i) {
            node = node.next;
        }
        return node;
    }

    private static class Node {
        public Node next;
        public Object data;

        public Node() {
            this.next = null;
            this.data = null;
        }

        public Node(Object object) {
            this.next = null;
            this.data = object;
        }

        public Node(Object object, Node node) {
            this.next = node;
            this.data = object;
        }
    }
}

