/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.CollectionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultReader;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.NumberUtils;

public class JdbcTemplate
extends JdbcAccessor
implements JdbcOperations,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NativeJdbcExtractor nativeJdbcExtractor;
    private boolean ignoreWarnings = true;
    private int fetchSize = 0;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor extractor) {
        this.nativeJdbcExtractor = extractor;
    }

    public NativeJdbcExtractor getNativeJdbcExtractor() {
        return this.nativeJdbcExtractor;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public boolean getIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Object execute(ConnectionCallback action) throws DataAccessException {
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            Object object = action.doInConnection(conToUse);
            return object;
        }
        catch (SQLException ex) {
            throw this.getExceptionTranslator().translate("executing ConnectionCallback", this.getSql(action), ex);
        }
        finally {
            DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        }
    }

    public Object execute(StatementCallback action) throws DataAccessException {
        Object object;
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        Statement stmt = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            stmt = conToUse.createStatement();
            DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
            Statement stmtToUse = stmt;
            if (this.nativeJdbcExtractor != null) {
                stmtToUse = this.nativeJdbcExtractor.getNativeStatement(stmt);
            }
            Object result = action.doInStatement(stmtToUse);
            SQLWarning warning = stmt.getWarnings();
            this.throwExceptionOnWarningIfNotIgnoringWarnings(warning);
            object = result;
        }
        catch (SQLException ex) {
            try {
                throw this.getExceptionTranslator().translate("executing StatementCallback", this.getSql(action), ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        return object;
    }

    public void execute(String sql) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
        }
        class ExecuteStatementCallback
        implements StatementCallback,
        SqlProvider {
            private final /* synthetic */ String val$sql;

            ExecuteStatementCallback(String val$sql) {
                this.val$sql = val$sql;
            }

            public Object doInStatement(Statement stmt) throws SQLException {
                stmt.execute(this.val$sql);
                return null;
            }

            public String getSql() {
                return this.val$sql;
            }
        }
        this.execute(new ExecuteStatementCallback(sql));
    }

    public Object query(String sql, ResultSetExtractor rse) throws DataAccessException {
        if (sql == null) {
            throw new InvalidDataAccessApiUsageException("SQL must not be null");
        }
        if (JdbcUtils.countParameterPlaceholders(sql, '?', "'\"") > 0) {
            throw new InvalidDataAccessApiUsageException("Cannot execute [" + sql + "] as a static query: it contains bind variables");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL query [" + sql + "]"));
        }
        class QueryStatementCallback
        implements StatementCallback,
        SqlProvider {
            private final /* synthetic */ String val$sql;
            private final /* synthetic */ ResultSetExtractor val$rse;

            QueryStatementCallback(String val$sql, ResultSetExtractor val$rse) {
                this.val$sql = val$sql;
                this.val$rse = val$rse;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInStatement(Statement stmt) throws SQLException {
                Object object;
                ResultSet rs = null;
                try {
                    if (JdbcTemplate.this.getFetchSize() > 0) {
                        stmt.setFetchSize(JdbcTemplate.this.getFetchSize());
                    }
                    ResultSet rsToUse = rs = stmt.executeQuery(this.val$sql);
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        rsToUse = JdbcTemplate.this.nativeJdbcExtractor.getNativeResultSet(rs);
                    }
                    object = this.val$rse.extractData(rsToUse);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                return object;
            }

            public String getSql() {
                return this.val$sql;
            }
        }
        return this.execute(new QueryStatementCallback(sql, rse));
    }

    public List query(String sql, RowCallbackHandler rch) throws DataAccessException {
        return (List)this.query(sql, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rch));
    }

    public List query(String sql, RowMapper rowMapper) throws DataAccessException {
        return this.query(sql, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    public List queryForList(String sql) throws DataAccessException {
        return (List)this.query(sql, (ResultSetExtractor)new ListResultSetExtractor());
    }

    public Object queryForObject(String sql, Class requiredType) throws DataAccessException {
        return this.query(sql, (ResultSetExtractor)new ObjectResultSetExtractor(requiredType));
    }

    public long queryForLong(String sql) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.longValue() : 0L;
    }

    public int queryForInt(String sql) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.intValue() : 0;
    }

    public int update(String sql) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL update [" + sql + "]"));
        }
        class UpdateStatementCallback
        implements StatementCallback,
        SqlProvider {
            private final /* synthetic */ String val$sql;

            UpdateStatementCallback(String val$sql) {
                this.val$sql = val$sql;
            }

            public Object doInStatement(Statement stmt) throws SQLException {
                int rows = stmt.executeUpdate(this.val$sql);
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("SQL update affected " + rows + " rows"));
                }
                return new Integer(rows);
            }

            public String getSql() {
                return this.val$sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(sql));
    }

    public Object execute(PreparedStatementCreator psc, PreparedStatementCallback action) throws DataAccessException {
        Object object;
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        PreparedStatement ps = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativePreparedStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            ps = psc.createPreparedStatement(conToUse);
            DataSourceUtils.applyTransactionTimeout(ps, this.getDataSource());
            PreparedStatement psToUse = ps;
            if (this.nativeJdbcExtractor != null) {
                psToUse = this.nativeJdbcExtractor.getNativePreparedStatement(ps);
            }
            Object result = action.doInPreparedStatement(psToUse);
            SQLWarning warning = ps.getWarnings();
            this.throwExceptionOnWarningIfNotIgnoringWarnings(warning);
            object = result;
            Object var11_11 = null;
        }
        catch (SQLException ex) {
            try {
                throw this.getExceptionTranslator().translate("executing PreparedStatementCallback [" + psc + "]", this.getSql(psc), ex);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (psc instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)psc)).cleanupParameters();
                }
                JdbcUtils.closeStatement(ps);
                DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
                throw throwable;
            }
        }
        if (psc instanceof ParameterDisposer) {
            ((ParameterDisposer)((Object)psc)).cleanupParameters();
        }
        JdbcUtils.closeStatement(ps);
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        return object;
    }

    public Object execute(String sql, PreparedStatementCallback action) throws DataAccessException {
        return this.execute(new SimplePreparedStatementCreator(sql), action);
    }

    protected Object query(PreparedStatementCreator psc, final PreparedStatementSetter pss, final ResultSetExtractor rse) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            String sql = this.getSql(psc);
            this.logger.debug((Object)("Executing SQL query" + (sql != null ? " [" + sql + "]" : "")));
        }
        return this.execute(psc, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                Object object;
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    if (JdbcTemplate.this.getFetchSize() > 0) {
                        ps.setFetchSize(JdbcTemplate.this.getFetchSize());
                    }
                    ResultSet rsToUse = rs = ps.executeQuery();
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        rsToUse = JdbcTemplate.this.nativeJdbcExtractor.getNativeResultSet(rs);
                    }
                    object = rse.extractData(rsToUse);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var6_6 = null;
                        JdbcUtils.closeResultSet(rs);
                        if (!(pss instanceof ParameterDisposer)) break block6;
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
                return object;
            }
        });
    }

    public Object query(PreparedStatementCreator psc, ResultSetExtractor rse) throws DataAccessException {
        return this.query(psc, null, rse);
    }

    public Object query(String sql, PreparedStatementSetter pss, ResultSetExtractor rse) throws DataAccessException {
        if (sql == null) {
            throw new InvalidDataAccessApiUsageException("SQL may not be null");
        }
        return this.query(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    public Object query(String sql, Object[] args, int[] argTypes, ResultSetExtractor rse) throws DataAccessException {
        return this.query(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes), rse);
    }

    public Object query(String sql, Object[] args, ResultSetExtractor rse) throws DataAccessException {
        return this.query(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args), rse);
    }

    public List query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException {
        return (List)this.query(psc, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rch));
    }

    public List query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws DataAccessException {
        return (List)this.query(sql, pss, (ResultSetExtractor)new RowCallbackHandlerResultSetExtractor(rch));
    }

    public List query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) throws DataAccessException {
        return this.query(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes), rch);
    }

    public List query(String sql, Object[] args, RowCallbackHandler rch) throws DataAccessException {
        return this.query(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args), rch);
    }

    public List query(PreparedStatementCreator psc, RowMapper rowMapper) throws DataAccessException {
        return this.query(psc, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    public List query(String sql, PreparedStatementSetter pss, RowMapper rowMapper) throws DataAccessException {
        return this.query(sql, pss, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    public List query(String sql, Object[] args, int[] argTypes, RowMapper rowMapper) throws DataAccessException {
        return this.query(sql, args, argTypes, new RowMapperResultReader(rowMapper));
    }

    public List query(String sql, Object[] args, RowMapper rowMapper) throws DataAccessException {
        return this.query(sql, args, (RowCallbackHandler)new RowMapperResultReader(rowMapper));
    }

    public List queryForList(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return (List)this.query(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes), (ResultSetExtractor)new ListResultSetExtractor());
    }

    public List queryForList(String sql, Object[] args) throws DataAccessException {
        return (List)this.query(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args), (ResultSetExtractor)new ListResultSetExtractor());
    }

    public Object queryForObject(String sql, Object[] args, int[] argTypes, Class requiredType) throws DataAccessException {
        return this.query(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes), (ResultSetExtractor)new ObjectResultSetExtractor(requiredType));
    }

    public Object queryForObject(String sql, Object[] args, Class requiredType) throws DataAccessException {
        return this.query(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args), (ResultSetExtractor)new ObjectResultSetExtractor(requiredType));
    }

    public long queryForLong(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, args, argTypes, class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.longValue() : 0L;
    }

    public long queryForLong(String sql, Object[] args) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, args, class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.longValue() : 0L;
    }

    public int queryForInt(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, args, argTypes, class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.intValue() : 0;
    }

    public int queryForInt(String sql, Object[] args) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, args, class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number);
        return number != null ? number.intValue() : 0;
    }

    protected int update(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            String sql = this.getSql(psc);
            this.logger.debug((Object)("Executing SQL update" + (sql != null ? " [" + sql + "]" : "")));
        }
        Integer result = (Integer)this.execute(psc, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (JdbcTemplate.this.logger.isDebugEnabled()) {
                        JdbcTemplate.this.logger.debug((Object)("SQL update affected " + rows + " rows"));
                    }
                    Integer n = new Integer(rows);
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
        return result;
    }

    public int update(PreparedStatementCreator psc) throws DataAccessException {
        return this.update(psc, (PreparedStatementSetter)null);
    }

    public int update(PreparedStatementCreator psc, final KeyHolder generatedKeyHolder) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            String sql = this.getSql(psc);
            this.logger.debug((Object)("Executing SQL update and returning generated keys" + (sql != null ? " [" + sql + "]" : "")));
        }
        Integer result = (Integer)this.execute(psc, new PreparedStatementCallback(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int rows = ps.executeUpdate();
                List generatedKeys = generatedKeyHolder.getKeyList();
                generatedKeys.clear();
                ResultSet keys = ps.getGeneratedKeys();
                if (keys != null) {
                    ListResultSetExtractor lrse = new ListResultSetExtractor();
                    generatedKeys.addAll((List)lrse.extractData(keys));
                }
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("SQL update affected " + rows + " rows and returned " + generatedKeys.size() + " keys"));
                }
                return new Integer(rows);
            }
        });
        return result;
    }

    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        return this.update((PreparedStatementCreator)new SimplePreparedStatementCreator(sql), pss);
    }

    public int update(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.update(sql, (PreparedStatementSetter)new ArgTypePreparedStatementSetter(args, argTypes));
    }

    public int update(String sql, Object[] args) throws DataAccessException {
        return this.update(sql, (PreparedStatementSetter)new ArgPreparedStatementSetter(args));
    }

    public int[] batchUpdate(String sql, final BatchPreparedStatementSetter pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL batch update [" + sql + "]"));
        }
        return (int[])this.execute(sql, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int batchSize = pss.getBatchSize();
                DatabaseMetaData dbmd = ps.getConnection().getMetaData();
                try {
                    boolean supportsBatchUpdates = false;
                    try {
                        if (dbmd != null) {
                            if (dbmd.supportsBatchUpdates()) {
                                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                                    JdbcTemplate.this.logger.debug((Object)"JDBC driver supports batch updates");
                                }
                                supportsBatchUpdates = true;
                            } else if (JdbcTemplate.this.logger.isDebugEnabled()) {
                                JdbcTemplate.this.logger.debug((Object)"JDBC driver does not support batch updates");
                            }
                        }
                    }
                    catch (AbstractMethodError ame) {
                        JdbcTemplate.this.logger.warn((Object)"JDBC driver does not support JDBC 2.0 'supportsBatchUpdates' method");
                    }
                    if (supportsBatchUpdates) {
                        for (int i = 0; i < batchSize; ++i) {
                            pss.setValues(ps, i);
                            ps.addBatch();
                        }
                        int[] i = ps.executeBatch();
                        return i;
                    }
                    int[] rowsAffected = new int[batchSize];
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        rowsAffected[i] = ps.executeUpdate();
                    }
                    int[] nArray = rowsAffected;
                    return nArray;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    public Object execute(CallableStatementCreator csc, CallableStatementCallback action) throws DataAccessException {
        Object object;
        if (this.logger.isDebugEnabled()) {
            String sql = this.getSql(csc);
            this.logger.debug((Object)("Calling stored procedure" + (sql != null ? " [" + sql + "]" : "")));
        }
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        CallableStatement cs = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeCallableStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            cs = csc.createCallableStatement(conToUse);
            DataSourceUtils.applyTransactionTimeout(cs, this.getDataSource());
            CallableStatement csToUse = cs;
            if (this.nativeJdbcExtractor != null) {
                csToUse = this.nativeJdbcExtractor.getNativeCallableStatement(cs);
            }
            Object result = action.doInCallableStatement(csToUse);
            SQLWarning warning = cs.getWarnings();
            this.throwExceptionOnWarningIfNotIgnoringWarnings(warning);
            object = result;
            Object var11_11 = null;
        }
        catch (SQLException ex) {
            try {
                throw this.getExceptionTranslator().translate("executing CallableStatementCallback [" + csc + "]", this.getSql(csc), ex);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (csc instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)csc)).cleanupParameters();
                }
                JdbcUtils.closeStatement(cs);
                DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
                throw throwable;
            }
        }
        if (csc instanceof ParameterDisposer) {
            ((ParameterDisposer)((Object)csc)).cleanupParameters();
        }
        JdbcUtils.closeStatement(cs);
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        return object;
    }

    public Object execute(String callString, CallableStatementCallback action) throws DataAccessException {
        return this.execute(new SimpleCallableStatementCreator(callString), action);
    }

    public Map call(CallableStatementCreator csc, final List declaredParameters) throws DataAccessException {
        return (Map)this.execute(csc, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException {
                boolean retVal = cs.execute();
                int updateCount = cs.getUpdateCount();
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug((Object)("CallableStatement.execute() returned '" + retVal + "'"));
                    JdbcTemplate.this.logger.debug((Object)("CallableStatement.getUpdateCount() returned " + updateCount));
                }
                HashMap returnedResults = new HashMap();
                if (retVal || updateCount != -1) {
                    returnedResults.putAll(JdbcTemplate.this.extractReturnedResultSets(cs, declaredParameters, updateCount));
                }
                returnedResults.putAll(JdbcTemplate.this.extractOutputParameters(cs, declaredParameters));
                return returnedResults;
            }
        });
    }

    protected Map extractReturnedResultSets(CallableStatement cs, List parameters, int updateCount) throws SQLException {
        boolean moreResults;
        HashMap returnedResults = new HashMap();
        int rsIndex = 0;
        do {
            if (updateCount == -1) {
                Object param = null;
                if (parameters != null && parameters.size() > rsIndex) {
                    param = parameters.get(rsIndex);
                }
                if (param instanceof SqlReturnResultSet) {
                    SqlReturnResultSet rsParam = param;
                    returnedResults.putAll(this.processResultSet(cs.getResultSet(), rsParam));
                } else {
                    this.logger.warn((Object)"ResultSet returned from stored procedure but a corresponding SqlReturnResultSet parameter was not declared");
                }
                ++rsIndex;
            }
            moreResults = cs.getMoreResults();
            updateCount = cs.getUpdateCount();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("CallableStatement.getUpdateCount() returned " + updateCount));
        } while (moreResults || updateCount != -1);
        return returnedResults;
    }

    protected Map extractOutputParameters(CallableStatement cs, List parameters) throws SQLException {
        HashMap<String, Object> returnedResults = new HashMap<String, Object>();
        int sqlColIndex = 1;
        for (int i = 0; i < parameters.size(); ++i) {
            Object param = parameters.get(i);
            if (param instanceof SqlOutParameter) {
                Object out;
                SqlOutParameter outParam = (SqlOutParameter)param;
                if (outParam.isReturnTypeSupported()) {
                    out = outParam.getSqlReturnType().getTypeValue(cs, sqlColIndex, outParam.getSqlType(), outParam.getTypeName());
                    returnedResults.put(outParam.getName(), out);
                } else {
                    out = cs.getObject(sqlColIndex);
                    if (out instanceof ResultSet) {
                        if (outParam.isResultSetSupported()) {
                            returnedResults.putAll(this.processResultSet((ResultSet)out, outParam));
                        } else {
                            this.logger.warn((Object)"ResultSet returned from stored procedure but a corresponding SqlOutParameter with a RowCallbackHandler was not declared");
                            returnedResults.put(outParam.getName(), "ResultSet was returned but not processed");
                        }
                    } else {
                        returnedResults.put(outParam.getName(), out);
                    }
                }
            }
            if (param instanceof SqlReturnResultSet) continue;
            ++sqlColIndex;
        }
        return returnedResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processResultSet(ResultSet rs, ResultSetSupportingSqlParameter param) throws SQLException {
        HashMap<String, Object> returnedResults = new HashMap<String, Object>();
        try {
            ResultSet rsToUse = rs;
            if (this.nativeJdbcExtractor != null) {
                rsToUse = this.nativeJdbcExtractor.getNativeResultSet(rs);
            }
            if (param.isRowCallbackHandlerSupported()) {
                RowCallbackHandler rch = param.getRowCallbackHandler();
                new RowCallbackHandlerResultSetExtractor(rch).extractData(rsToUse);
                if (rch instanceof ResultReader) {
                    returnedResults.put(param.getName(), ((ResultReader)rch).getResults());
                } else {
                    returnedResults.put(param.getName(), "ResultSet returned from stored procedure was processed.");
                }
            } else {
                Object result = param.getResultSetExtractor().extractData(rsToUse);
                returnedResults.put(param.getName(), result);
            }
        }
        finally {
            JdbcUtils.closeResultSet(rs);
        }
        return returnedResults;
    }

    private void throwExceptionOnWarningIfNotIgnoringWarnings(SQLWarning warning) throws SQLWarningException {
        if (warning != null) {
            if (this.ignoreWarnings) {
                this.logger.warn((Object)("SQLWarning ignored: " + warning));
            } else {
                throw new SQLWarningException("Warning not ignored", warning);
            }
        }
    }

    private String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static Object getJdbcObject(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        if (obj != null && obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ObjectResultSetExtractor
    implements ResultSetExtractor {
        private final Class requiredType;

        public ObjectResultSetExtractor(Class requiredType) {
            this.requiredType = requiredType;
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (!rs.next()) {
                throw new IncorrectResultSizeDataAccessException("Expected single row but found none", 1, 0);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int nrOfColumns = rsmd.getColumnCount();
            if (nrOfColumns != 1) {
                throw new IncorrectResultSizeDataAccessException("Expected single column but found " + nrOfColumns, 1, nrOfColumns);
            }
            Object result = JdbcTemplate.getJdbcObject(rs, 1);
            if (rs.next()) {
                throw new IncorrectResultSizeDataAccessException("Expected single row but found more than one", 1, -1);
            }
            if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
                if ((class$java$lang$String == null ? (class$java$lang$String = JdbcTemplate.class$("java.lang.String")) : class$java$lang$String).equals(this.requiredType)) {
                    result = result.toString();
                } else if ((class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.requiredType) && (class$java$lang$Number == null ? (class$java$lang$Number = JdbcTemplate.class$("java.lang.Number")) : class$java$lang$Number).isInstance(result)) {
                    try {
                        result = NumberUtils.convertNumberToTargetClass((Number)((Number)result), (Class)this.requiredType);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new TypeMismatchDataAccessException(ex.getMessage());
                    }
                } else {
                    throw new TypeMismatchDataAccessException("Result object with column type '" + rsmd.getColumnTypeName(1) + "' and value [" + result + "] is of type [" + rsmd.getColumnClassName(1) + "] and could not be converted to required type [" + this.requiredType.getName() + "]");
                }
            }
            return result;
        }
    }

    private static class ListResultSetExtractor
    implements ResultSetExtractor {
        private ListResultSetExtractor() {
        }

        public Object extractData(ResultSet rs) throws SQLException {
            ArrayList<Map> listOfRows = new ArrayList<Map>();
            ResultSetMetaData rsmd = null;
            int numberOfColumns = -1;
            while (rs.next()) {
                if (rsmd == null) {
                    rsmd = rs.getMetaData();
                    numberOfColumns = rsmd.getColumnCount();
                }
                Map mapOfColValues = CollectionFactory.createLinkedMapIfPossible((int)numberOfColumns);
                for (int i = 1; i <= numberOfColumns; ++i) {
                    Object o = JdbcTemplate.getJdbcObject(rs, i);
                    mapOfColValues.put(rsmd.getColumnName(i), o);
                }
                listOfRows.add(mapOfColValues);
            }
            return listOfRows;
        }
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            if (this.rch instanceof ResultReader) {
                return ((ResultReader)this.rch).getResults();
            }
            return null;
        }
    }

    private static class ArgTypePreparedStatementSetter
    implements PreparedStatementSetter,
    ParameterDisposer {
        private final Object[] args;
        private final int[] argTypes;

        public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
            if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
                throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
            }
            this.args = args;
            this.argTypes = argTypes;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    StatementCreatorUtils.setParameterValue(ps, i + 1, this.argTypes[i], null, this.args[i]);
                }
            }
        }

        public void cleanupParameters() {
            StatementCreatorUtils.cleanupParameters(this.args);
        }
    }

    private static class ArgPreparedStatementSetter
    implements PreparedStatementSetter,
    ParameterDisposer {
        private final Object[] args;

        public ArgPreparedStatementSetter(Object[] args) {
            this.args = args;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    StatementCreatorUtils.setParameterValue(ps, i + 1, Integer.MIN_VALUE, null, this.args[i]);
                }
            }
        }

        public void cleanupParameters() {
            StatementCreatorUtils.cleanupParameters(this.args);
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String callString) {
            this.callString = callString;
        }

        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            return con.prepareCall(this.callString);
        }

        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            this.sql = sql;
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        public String getSql() {
            return this.sql;
        }
    }
}

