/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms;

import com.opensymphony.messagework.jms.JmsTemplateAware;
import com.opensymphony.messagework.jms.messagefactory.MapMessageFactory;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;

public class ActionMessageSender
implements JmsTemplateAware {
    private JmsTemplate jmsTemplate;
    private Destination destination;
    private MapMessageFactory messageFactory = new MapMessageFactory();
    private String namespace;

    public ActionMessageSender(JmsTemplate jmsTemplate, Destination destination) {
        this.jmsTemplate = jmsTemplate;
        this.destination = destination;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setReplyTo(Destination replyTo) {
        this.messageFactory.setReplyTo(replyTo);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void sendActionMessage(String actionName, Map params) {
        this.messageFactory.setActionName(actionName);
        this.messageFactory.setMessageValue(params);
        if (this.namespace != null) {
            this.messageFactory.setNamespace(this.namespace);
        }
        this.jmsTemplate.send(this.destination, (MessageCreator)this.messageFactory);
    }

    public Message sendActionMessageAndGetResponse(String actionName, Map params) {
        return this.sendActionMessageAndGetResponse(actionName, params, -1);
    }

    public Message sendActionMessageAndGetResponse(String actionName, Map params, final int receiveTimeout) {
        this.messageFactory.setActionName(actionName);
        this.messageFactory.setMessageValue(params);
        if (this.namespace != null) {
            this.messageFactory.setNamespace(this.namespace);
        }
        return (Message)this.jmsTemplate.execute(new SessionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInJms(Session session) throws JMSException {
                QueueSession queueSession = (QueueSession)session;
                Message message = ActionMessageSender.this.messageFactory.createMessage((Session)queueSession);
                TemporaryQueue responseQueue = queueSession.createTemporaryQueue();
                message.setJMSReplyTo((Destination)responseQueue);
                QueueReceiver consumer = queueSession.createReceiver((Queue)responseQueue);
                try {
                    QueueSender producer = queueSession.createSender((Queue)ActionMessageSender.this.destination);
                    if (ActionMessageSender.this.jmsTemplate.isExplicitQosEnabled()) {
                        producer.send(message, ActionMessageSender.this.jmsTemplate.getDeliveryMode(), ActionMessageSender.this.jmsTemplate.getPriority(), ActionMessageSender.this.jmsTemplate.getTimeToLive());
                    } else {
                        producer.send(message);
                    }
                    Message message2 = message = receiveTimeout >= 0 ? consumer.receive((long)receiveTimeout) : consumer.receive();
                    if (session.getTransacted()) {
                        session.commit();
                    } else if (message != null && session.getAcknowledgeMode() == 2) {
                        message.acknowledge();
                    }
                    Message message3 = message;
                    return message3;
                }
                finally {
                    JmsUtils.closeMessageConsumer((MessageConsumer)consumer);
                }
            }
        }, true);
    }
}

