/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;

abstract class AbstractVisitor {
    private final SessionImpl session;

    AbstractVisitor(SessionImpl session) {
        this.session = session;
    }

    void processValues(Object[] values, Type[] types) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            this.processValue(values[i], types[i]);
        }
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        if (component != null) {
            this.processValues(componentType.getPropertyValues(component, this.session), componentType.getSubtypes());
        }
        return null;
    }

    final Object processValue(Object value, Type type) throws HibernateException {
        if (type.isPersistentCollectionType()) {
            return this.processCollection(value, (PersistentCollectionType)type);
        }
        if (type.isEntityType()) {
            return this.processEntity(value, (EntityType)type);
        }
        if (type.isComponentType()) {
            return this.processComponent(value, (AbstractComponentType)type);
        }
        return null;
    }

    void process(Object object, ClassPersister persister) throws HibernateException {
        this.processValues(persister.getPropertyValues(object), persister.getPropertyTypes());
    }

    Object processCollection(Object collection, PersistentCollectionType type) throws HibernateException {
        return null;
    }

    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        return null;
    }

    final SessionImpl getSession() {
        return this.session;
    }
}

