/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.RelationalModel;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.util.StringHelper;

public class Index
implements RelationalModel {
    private Table table;
    private ArrayList columns = new ArrayList();
    private String name;

    public String sqlCreateString(Dialect dialect, Mapping mapping) throws HibernateException {
        StringBuffer buf = new StringBuffer("create index ").append(dialect.qualifyIndexName() ? this.name : StringHelper.unqualify(this.name)).append(" on ").append(this.table.getQualifiedName(dialect)).append(" (");
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(((Column)iter.next()).getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public String sqlConstraintString(Dialect dialect) {
        StringBuffer buf = new StringBuffer(" index (");
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(((Column)iter.next()).getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append(")").toString();
    }

    public String sqlDropString(Dialect dialect) {
        return "drop index " + StringHelper.qualify(this.table.getQualifiedName(dialect), this.name);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Iterator extraColumns) {
        while (extraColumns.hasNext()) {
            this.addColumn((Column)extraColumns.next());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

