/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.jsp.JspWriter;

public class FastByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private LinkedList buffers;
    private byte[] buffer;
    private boolean closed;
    private int blockSize;
    private int index;
    private int size;

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int aSize) {
        this.blockSize = aSize;
        this.buffer = new byte[this.blockSize];
    }

    public int getSize() {
        return this.size + this.index;
    }

    public void close() {
        this.closed = true;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.getSize()];
        int pos = 0;
        if (this.buffers != null) {
            Iterator iter = this.buffers.iterator();
            while (iter.hasNext()) {
                byte[] bytes = (byte[])iter.next();
                System.arraycopy(bytes, 0, data, pos, this.blockSize);
                pos += this.blockSize;
            }
        }
        System.arraycopy(this.buffer, 0, data, pos, this.index);
        return data;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public void write(int datum) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index == this.blockSize) {
            this.addBuffer();
        }
        this.buffer[this.index++] = (byte)datum;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.index + length > this.blockSize) {
            int copyLength;
            do {
                if (this.index == this.blockSize) {
                    this.addBuffer();
                }
                if (length < (copyLength = this.blockSize - this.index)) {
                    copyLength = length;
                }
                System.arraycopy(data, offset, this.buffer, this.index, copyLength);
                offset += copyLength;
                this.index += copyLength;
            } while ((length -= copyLength) > 0);
        } else {
            System.arraycopy(data, offset, this.buffer, this.index, length);
            this.index += length;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.buffers != null) {
            Iterator iter = this.buffers.iterator();
            while (iter.hasNext()) {
                byte[] bytes = (byte[])iter.next();
                out.write(bytes, 0, this.blockSize);
            }
        }
        out.write(this.buffer, 0, this.index);
    }

    public void writeTo(RandomAccessFile out) throws IOException {
        if (this.buffers != null) {
            Iterator iter = this.buffers.iterator();
            while (iter.hasNext()) {
                byte[] bytes = (byte[])iter.next();
                out.write(bytes, 0, this.blockSize);
            }
        }
        out.write(this.buffer, 0, this.index);
    }

    public void writeTo(JspWriter out, String encoding) throws IOException {
        if (this.buffers != null) {
            Iterator iter = this.buffers.iterator();
            while (iter.hasNext()) {
                byte[] bytes = (byte[])iter.next();
                if (encoding != null) {
                    out.write(new String(bytes, encoding));
                    continue;
                }
                out.write(new String(bytes));
            }
        }
        if (encoding != null) {
            out.write(new String(this.buffer, 0, this.index, encoding));
        } else {
            out.write(new String(this.buffer, 0, this.index));
        }
    }

    protected void addBuffer() {
        if (this.buffers == null) {
            this.buffers = new LinkedList();
        }
        this.buffers.addLast(this.buffer);
        this.buffer = new byte[this.blockSize];
        this.size += this.index;
        this.index = 0;
    }
}

