/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms.result;

import com.opensymphony.messagework.jms.MessageActionContext;
import com.opensymphony.messagework.jms.messagefactory.MapMessageFactory;
import com.opensymphony.messagework.jms.result.AbstractMessageResult;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionInvocation;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class ActionMessageResult
extends AbstractMessageResult {
    private String namespace;
    private String actionName;

    public ActionMessageResult() {
        this.messageFactory = new MapMessageFactory();
    }

    public void execute(ActionInvocation invocation) throws Exception {
        if (!TextUtils.stringSet((String)this.actionName)) {
            throw new IllegalArgumentException("The action name must be set for the ActionMessageResult.");
        }
        Message message = MessageActionContext.getMessage();
        this.messageFactory.setParentMessage(message);
        if (TextUtils.stringSet((String)this.namespace)) {
            this.messageFactory.setNamespace(this.namespace);
        }
        this.messageFactory.setActionName(this.actionName);
        super.execute(invocation);
    }

    protected void initializeMessageFactory() {
    }

    public Destination getDestination() throws JMSException {
        return MessageActionContext.getMessage().getJMSDestination();
    }

    public void setMessageFactoryName(String messageFactoryName) {
        throw new IllegalArgumentException("The ActionMessageResult must use the default MapMessageFactory");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }
}

