/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.impl.JndiRefDataSourceBase;
import com.mchange.v2.sql.SqlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

final class JndiRefForwardingConnectionPoolDataSource
extends JndiRefDataSourceBase
implements ConnectionPoolDataSource,
Serializable,
Referenceable {
    transient ConnectionPoolDataSource cachedInner;

    JndiRefForwardingConnectionPoolDataSource() {
        VetoableChangeListener l = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Object val = evt.getNewValue();
                if ("jndiName".equals(evt.getPropertyName()) && !(val instanceof Name) && !(val instanceof String)) {
                    throw new PropertyVetoException("jndiName must be a String or a javax.naming.Name", evt);
                }
            }
        };
        this.addVetoableChangeListener(l);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JndiRefForwardingConnectionPoolDataSource.this.cachedInner = null;
            }
        };
        this.addPropertyChangeListener(pcl);
    }

    private ConnectionPoolDataSource dereference() throws SQLException {
        Object jndiName = this.getJndiName();
        Hashtable jndiEnv = this.getJndiEnv();
        try {
            InitialContext ctx = jndiEnv != null ? new InitialContext(jndiEnv) : new InitialContext();
            if (jndiName instanceof String) {
                return (ConnectionPoolDataSource)ctx.lookup((String)jndiName);
            }
            if (jndiName instanceof Name) {
                return (ConnectionPoolDataSource)ctx.lookup((Name)jndiName);
            }
            throw new SQLException("Could not find ConnectionPoolDataSource with JNDI name: " + jndiName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    private synchronized ConnectionPoolDataSource inner() throws SQLException {
        if (this.cachedInner != null) {
            return this.cachedInner;
        }
        ConnectionPoolDataSource out = this.dereference();
        if (this.isCaching()) {
            this.cachedInner = out;
        }
        return out;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.inner().getPooledConnection();
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.inner().getPooledConnection(user, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.inner().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.inner().setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.inner().setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.inner().getLoginTimeout();
    }
}

