/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.filter;

import javax.jms.Destination;
import org.codehaus.activemq.filter.DestinationFilter;
import org.codehaus.activemq.filter.DestinationPath;

public class PrefixDestinationFilter
extends DestinationFilter {
    private String[] prefixes;

    public PrefixDestinationFilter(String[] prefixes) {
        this.prefixes = prefixes;
    }

    public boolean matches(Destination destination) {
        int length;
        String[] path = DestinationPath.getDestinationPaths(destination);
        if (path.length >= (length = this.prefixes.length)) {
            int size = length - 1;
            for (int i = 0; i < size; ++i) {
                if (this.prefixes[i].equals(path[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return DestinationPath.toString(this.prefixes);
    }

    public String toString() {
        return super.toString() + "[destination: " + this.getText() + "]";
    }

    public boolean isWildcard() {
        return true;
    }
}

