/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbm;

import java.io.IOException;
import javax.jms.JMSException;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.codehaus.activemq.AlreadyClosedException;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.SubscriberEntry;
import org.codehaus.activemq.service.Subscription;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.jdbm.JdbmMessageStore;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class JdbmTopicMessageStore
extends JdbmMessageStore
implements TopicMessageStore {
    private static final Integer ONE = new Integer(1);
    private BTree ackDatabase;
    private BTree messageCounts;
    private BTree subscriberDetails;

    public JdbmTopicMessageStore(BTree messageTable, BTree orderedIndex, BTree ackDatabase, BTree subscriberDetails, BTree messageCounts) {
        super(messageTable, orderedIndex);
        this.ackDatabase = ackDatabase;
        this.subscriberDetails = subscriberDetails;
        this.messageCounts = messageCounts;
    }

    public synchronized void incrementMessageCount(MessageIdentity messageId) throws JMSException {
        try {
            Integer number = (Integer)this.getMessageCounts().find((Object)messageId);
            number = number == null ? ONE : new Integer(number + 1);
            this.getMessageCounts().insert((Object)messageId, (Object)number, true);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to increment messageCount for  messageID: " + messageId + ". Reason: " + e, e);
        }
    }

    public synchronized void decrementMessageCountAndMaybeDelete(MessageIdentity messageIdentity, MessageAck ack) throws JMSException {
        try {
            Integer number = (Integer)this.getMessageCounts().find((Object)messageIdentity);
            if (number == null || number <= 1) {
                this.removeMessage(messageIdentity, ack);
                if (number != null) {
                    this.getMessageCounts().remove((Object)messageIdentity);
                }
            } else {
                this.getMessageCounts().insert((Object)messageIdentity, (Object)new Integer(number - 1), true);
                number = ONE;
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to increment messageCount for  messageID: " + messageIdentity + ". Reason: " + e, e);
        }
    }

    public synchronized void setLastAcknowledgedMessageIdentity(Subscription subscription, MessageIdentity messageIdentity) throws JMSException {
        String key = subscription.getPersistentKey();
        try {
            this.getAckDatabase().insert((Object)key, (Object)messageIdentity, true);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to set ack messageID: " + messageIdentity + " for consumerId: " + key + ". Reason: " + e, e);
        }
    }

    public synchronized void recoverSubscription(Subscription subscription, MessageIdentity lastDispatchedMessage) throws JMSException {
        try {
            MessageIdentity lastAcked = this.getLastAcknowledgedMessageIdentity(subscription);
            if (lastAcked == null) {
                this.setLastAcknowledgedMessageIdentity(subscription, lastDispatchedMessage);
                return;
            }
            Object lastAckedSequenceNumber = lastAcked.getSequenceNumber();
            Tuple tuple = this.getOrderedIndex().findGreaterOrEqual(lastAckedSequenceNumber);
            TupleBrowser iter = this.getOrderedIndex().browse();
            while (iter.getNext(tuple)) {
                Long sequenceNumber = (Long)tuple.getKey();
                if (sequenceNumber.compareTo(lastAckedSequenceNumber) <= 0) continue;
                ActiveMQMessage message = null;
                message = this.getMessageBySequenceNumber(sequenceNumber);
                if (message == null) continue;
                subscription.addMessage(this.getContainer(), message);
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to recover subscription: " + subscription + ". Reason: " + e, e);
        }
    }

    public synchronized MessageIdentity getLastestMessageIdentity() throws JMSException {
        return new MessageIdentity(null, new Long(this.getLastSequenceNumber()));
    }

    public SubscriberEntry getSubscriberEntry(ConsumerInfo info) throws JMSException {
        String key = info.getConsumerKey();
        try {
            return (SubscriberEntry)this.subscriberDetails.find((Object)key);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to lookup subscription for info: " + info + ". Reason: " + e, e);
        }
    }

    public void setSubscriberEntry(ConsumerInfo info, SubscriberEntry subscriberEntry) throws JMSException {
        String key = info.getConsumerKey();
        try {
            this.subscriberDetails.insert((Object)key, (Object)subscriberEntry, true);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to lookup subscription for info: " + info + ". Reason: " + e, e);
        }
    }

    public synchronized void stop() throws JMSException {
        JMSException firstException = this.closeTable(this.ackDatabase, null);
        firstException = this.closeTable(this.messageCounts, firstException);
        this.ackDatabase = null;
        this.messageCounts = null;
        super.stop();
        if (firstException != null) {
            throw firstException;
        }
    }

    protected BTree getMessageCounts() throws AlreadyClosedException {
        if (this.messageCounts == null) {
            throw new AlreadyClosedException("JDBM TopicMessageStore");
        }
        return this.messageCounts;
    }

    protected BTree getAckDatabase() throws AlreadyClosedException {
        if (this.ackDatabase == null) {
            throw new AlreadyClosedException("JDBM TopicMessageStore");
        }
        return this.ackDatabase;
    }

    protected MessageIdentity getLastAcknowledgedMessageIdentity(Subscription subscription) throws IOException, AlreadyClosedException {
        return (MessageIdentity)this.getAckDatabase().find((Object)subscription.getPersistentKey());
    }
}

