/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.ember;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.net.URI;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportServerChannelSupport;
import org.codehaus.activemq.transport.ember.EmberTransportChannel;
import org.codehaus.activemq.util.JMSExceptionHelper;
import pyrasun.eio.EIOGlobalContext;
import pyrasun.eio.services.EmberServiceController;
import pyrasun.eio.services.EmberServiceException;
import pyrasun.eio.services.bytearray.ByteArrayServerClient;
import pyrasun.eio.services.bytearray.ByteArrayServerClientListener;
import pyrasun.eio.services.bytearray.ByteArrayServerListener;

public class EmberTransportServerChannel
extends TransportServerChannelSupport
implements ByteArrayServerListener,
ByteArrayServerClientListener {
    private static final Log log = LogFactory.getLog((Class)EmberTransportServerChannel.class);
    private WireFormat wireFormat;
    private EIOGlobalContext context;
    private EmberServiceController controller;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;

    public EmberTransportServerChannel(WireFormat wireFormat, URI bindAddr, EIOGlobalContext context, EmberServiceController controller) {
        super(bindAddr);
        this.wireFormat = wireFormat;
        this.context = context;
        this.controller = controller;
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
    }

    public void start() throws JMSException {
        super.start();
        if (this.started.commit(false, true)) {
            log.info((Object)("EmberTransportServerChannel at: " + this.getUrl()));
            try {
                this.context.start();
                this.controller.startAll();
            }
            catch (EmberServiceException e) {
                JMSException jmsEx = new JMSException("Could not start EmberIOController: " + (Object)((Object)e));
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
        }
    }

    public void stop() throws JMSException {
        if (this.closed.commit(false, true)) {
            try {
                this.controller.stopAll();
                this.context.stop();
            }
            catch (EmberServiceException e) {
                throw JMSExceptionHelper.newJMSException("Failed to stop: " + (Object)((Object)e), (Exception)((Object)e));
            }
        }
    }

    public String toString() {
        return "EmberTransportServerChannel@" + this.getUrl();
    }

    protected void handleException(ByteArrayServerClient client, JMSException e) {
        log.error((Object)("Could not create new TransportChannel for client: " + client), (Throwable)e);
    }

    public void newClient(ByteArrayServerClient client) {
        log.trace((Object)"New client received!");
        this.addClient(new EmberTransportChannel(this.wireFormat, null, null, client));
    }

    public void clientClosed(ByteArrayServerClient client) {
        log.info((Object)("Client has disconnected: " + client));
    }

    public void newMessage(ByteArrayServerClient byteArrayServerClient, Object msg) {
        log.warn((Object)("New message received!: " + msg));
    }
}

