/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.jgroups;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.transport.TransportChannelSupport;
import org.codehaus.activemq.util.JMSExceptionHelper;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;
import org.jgroups.TimeoutException;

public class JGroupsTransportChannel
extends TransportChannelSupport
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)JGroupsTransportChannel.class);
    private Channel channel;
    private Address localAddress = null;
    private WireFormat wireFormat;
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private Object outboundLock;
    private Executor executor;
    private Thread thread;
    private boolean useAsyncSend = false;

    public JGroupsTransportChannel(WireFormat wireFormat, Channel channel, Executor executor) {
        this.wireFormat = wireFormat;
        this.channel = channel;
        this.executor = executor;
        this.localAddress = channel.getLocalAddress();
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.outboundLock = new Object();
        if (this.useAsyncSend) {
            executor = new PooledExecutor((EDU.oswego.cs.dl.util.concurrent.Channel)new BoundedBuffer(1000), 1);
        }
    }

    public String toString() {
        return "JGroupsTransportChannel: " + this.channel;
    }

    public void stop() {
        if (this.closed.commit(false, true)) {
            super.stop();
            try {
                this.stopExecutor(this.executor);
                this.channel.disconnect();
                this.channel.close();
            }
            catch (Exception e) {
                log.warn((Object)("Caught while closing: " + e + ". Now Closed"), (Throwable)e);
            }
        }
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.thread = new Thread((Runnable)this, this.toString());
            if (this.isServerSide()) {
                this.thread.setDaemon(true);
            }
            this.thread.start();
        }
    }

    public void asyncSend(final Packet packet) throws JMSException {
        if (this.executor != null) {
            try {
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            JGroupsTransportChannel.this.writePacket(packet);
                        }
                        catch (JMSException e) {
                            JGroupsTransportChannel.this.onAsyncException(e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                log.info((Object)("Caught: " + e), (Throwable)e);
            }
        } else {
            this.writePacket(packet);
        }
    }

    public boolean isMulticast() {
        return true;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.wireFormat.canProcessWireFormatVersion(version);
    }

    public int getCurrentWireFormatVersion() {
        return this.wireFormat.getCurrentWireFormatVersion();
    }

    public void run() {
        log.trace((Object)"JGroups consumer thread starting");
        while (!this.closed.get()) {
            try {
                byte[] data;
                Packet packet;
                Message message;
                Object value = this.channel.receive(0L);
                if (!(value instanceof Message) || this.localAddress.equals((message = (Message)value).getSrc()) || (packet = this.wireFormat.fromBytes(data = message.getBuffer())) == null) continue;
                this.doConsumePacket(packet);
            }
            catch (IOException e) {
                this.doClose(e);
            }
            catch (ChannelClosedException e) {
                this.stop();
            }
            catch (ChannelNotConnectedException e) {
                this.doClose((Exception)((Object)e));
            }
            catch (TimeoutException timeoutException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePacket(Packet packet) throws JMSException {
        try {
            Object object = this.outboundLock;
            synchronized (object) {
                Address dest = null;
                Message message = new Message(dest, this.localAddress, this.wireFormat.toBytes(packet));
                this.channel.send(message);
            }
        }
        catch (ChannelException e) {
            throw JMSExceptionHelper.newJMSException("writePacket failed: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("writePacket failed: " + e, e);
        }
    }

    private void doClose(Exception ex) {
        if (!this.closed.get()) {
            this.onAsyncException(JMSExceptionHelper.newJMSException("Error reading socket: " + ex, ex));
            this.stop();
        }
    }

    public void forceDisconnect() {
        throw new RuntimeException("Not yet Implemented.");
    }
}

