/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms.messagefactory;

import com.opensymphony.messagework.jms.messagefactory.MessageFactory;
import com.opensymphony.messagework.jms.util.MessageUtil;
import com.opensymphony.xwork.ActionContext;
import java.util.Locale;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public abstract class AbstractMessageFactory
implements MessageFactory {
    private Message parentMessage;
    private String namespace;
    private String actionName;
    private Locale locale;
    private Destination replyTo;
    private String correlationId;
    Object messageValue = null;

    public final Message createMessage(Session session) throws JMSException {
        Message message = this.buildMessage(session);
        if (this.namespace != null) {
            MessageUtil.setNamespace(message, this.namespace);
        }
        if (this.actionName != null) {
            MessageUtil.setActionName(message, this.actionName);
        }
        if (this.locale != null) {
            MessageUtil.setLocale(message, this.locale);
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        if (this.correlationId != null) {
            message.setJMSCorrelationID(this.correlationId);
        }
        MessageUtil.setSession(message, ActionContext.getContext().getSession());
        if (this.parentMessage != null) {
            Map sessionMap;
            Locale inheritedLocale;
            String inheritedNamesapce;
            message.setJMSCorrelationID(this.parentMessage.getJMSCorrelationID());
            if (this.replyTo == null) {
                message.setJMSReplyTo(this.parentMessage.getJMSReplyTo());
            }
            if (this.namespace == null && (inheritedNamesapce = MessageUtil.getNamespace(this.parentMessage)) != null) {
                MessageUtil.setNamespace(message, inheritedNamesapce);
            }
            if (this.locale == null && (inheritedLocale = (Locale)message.getObjectProperty("messagework_locale")) != null) {
                MessageUtil.setLocale(message, inheritedLocale);
            }
            if ((sessionMap = MessageUtil.getSession(this.parentMessage)) != null) {
                MessageUtil.setSession(message, sessionMap);
            }
        }
        return message;
    }

    public void setParentMessage(Message parentMessage) {
        this.parentMessage = parentMessage;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setMessageValue(Object messageValue) {
        this.messageValue = messageValue;
    }

    protected abstract Message buildMessage(Session var1) throws JMSException;
}

