/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.URL;
import org.hsqldb.DataFileCache;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.LockFile;
import org.hsqldb.Log;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Logger {
    Log lLog;
    LockFile lf;

    Logger() {
    }

    void openLog(Database database) throws HsqlException {
        String string = database.getPath();
        if (database.isFilesInJar()) {
            this.checkFilesInJar(string);
        }
        if (!database.isFilesReadOnly()) {
            this.acquireLock(string);
        }
        this.lLog = new Log(database, string);
        this.lLog.open();
    }

    boolean closeLog(int n) {
        if (this.lLog == null) {
            return true;
        }
        try {
            this.lLog.stop();
            switch (n) {
                case -1: {
                    this.lLog.shutdown();
                    break;
                }
                case 0: {
                    this.lLog.close(false, true);
                    break;
                }
                case 1: 
                case 2: {
                    this.lLog.close(true, true);
                }
            }
        }
        catch (Throwable throwable) {
            this.lLog = null;
            return false;
        }
        this.lLog = null;
        return true;
    }

    boolean hasLog() {
        return this.lLog != null;
    }

    DataFileCache getCache() throws HsqlException {
        if (this.lLog != null) {
            return this.lLog.getCache();
        }
        return null;
    }

    void logConnectUser(Session session) throws HsqlException {
        if (this.lLog != null) {
            this.writeToLog(session, session.getUser().getConnectStatement());
        }
    }

    void writeToLog(Session session, String string) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeStatement(session, string);
        }
    }

    void writeInsertStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeInsertStatement(session, table, objectArray);
        }
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeDeleteStatement(session, table, objectArray);
        }
    }

    void writeSequenceStatement(Session session, NumberSequence numberSequence) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeSequenceStatement(session, numberSequence);
        }
    }

    void writeCommit() throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeCommit();
        }
    }

    void checkpoint(boolean bl) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.checkpoint(bl);
        }
    }

    void setLogSize(int n) {
        if (this.lLog != null) {
            this.lLog.setLogSize(n);
        }
    }

    void setScriptType(int n) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.setScriptType(n);
        }
    }

    void setWriteDelay(int n) {
        if (this.lLog != null) {
            this.lLog.setWriteDelay(n);
        }
    }

    DataFileCache openTextCache(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        return this.lLog.openTextCache(table, string, bl, bl2);
    }

    void closeTextCache(Table table) throws HsqlException {
        this.lLog.closeTextCache(table);
    }

    void acquireLock(String string) throws HsqlException {
        if (this.lf != null) {
            return;
        }
        this.lf = LockFile.newLockFileLock(string + ".lck");
    }

    void releaseLock() {
        block3: {
            try {
                if (this.lf != null) {
                    this.lf.tryRelease();
                }
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(exception.toString());
            }
        }
        this.lf = null;
    }

    private void checkFilesInJar(String string) throws HsqlException {
        if (string == null) {
            throw Trace.error(29, 161);
        }
        String string2 = string + ".script";
        URL uRL = this.getClass().getResource(string2);
        if (uRL == null) {
            throw Trace.error(29, 162, string2);
        }
        if (!"jar".equalsIgnoreCase(uRL.getProtocol())) {
            throw Trace.error(33, 163, uRL.getProtocol());
        }
    }
}

