/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESFactory;
import com.caucho.es.ESNull;
import com.caucho.es.ESNullException;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefined;
import com.caucho.es.ESUndefinedException;
import com.caucho.util.IntMap;
import java.util.HashMap;
import java.util.Iterator;

public class ESBase {
    private static ESFactory factory;
    String className;
    ESBase prototype;
    public static ESBase esBase;
    public static ESBase esNull;
    public static ESBase esUndefined;
    public static ESBase esEmpty;
    static final int NONE = 0;
    static final int STRING = 1;
    static final int NUMBER = 2;
    public static final int READ_ONLY = 1;
    public static final int DONT_DELETE = 2;
    public static final int DONT_ENUM = 4;
    static final int WATCH = 8;

    static void init(ESFactory factory) {
        if (esBase != null) {
            return;
        }
        ESBase.esBase.prototype = esBase = new ESBase(null);
        ESBase.esBase.className = "base";
        ESBase.factory = factory;
        if (factory != null) {
            esNull = factory.createNull();
            esUndefined = factory.createUndefined();
            esEmpty = factory.createUndefined();
        } else {
            esNull = new ESNull();
            esUndefined = new ESUndefined();
            esEmpty = new ESUndefined();
        }
    }

    protected ESBase() {
    }

    ESBase(ESBase prototype) {
        if (prototype == null) {
            prototype = esBase;
        }
        this.prototype = prototype;
    }

    public ESBase typeof() throws ESException {
        throw new ESException("no typeof");
    }

    public Class getJavaType() {
        return Void.TYPE;
    }

    public ESBase getProperty(ESString key) throws Throwable {
        return esEmpty;
    }

    boolean canPut(ESString name) {
        return true;
    }

    public void setProperty(ESString key, ESBase value) throws Throwable {
    }

    public ESBase delete(ESString key) throws Throwable {
        return ESBoolean.TRUE;
    }

    public ESBase toPrimitive(int type) throws Throwable {
        return this;
    }

    public ESBase toPrimitive() throws Throwable {
        return this.toPrimitive(0);
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean toBoolean() {
        return false;
    }

    public boolean isNum() {
        return false;
    }

    public double toNum() throws Throwable {
        throw new ESException("no number: " + this.getClass().getName());
    }

    public boolean isString() {
        return false;
    }

    public ESString toStr() throws Throwable {
        throw new ESException("no string: " + this.getClass().getName());
    }

    public ESBase valueOf() throws Throwable {
        return this.toPrimitive(0);
    }

    public ESString toSource(IntMap map, boolean isLoopPass) throws Throwable {
        if (isLoopPass) {
            return null;
        }
        return this.toStr();
    }

    public ESObject toObject() throws ESException {
        throw new ESNullException(this.className + " has no properties");
    }

    public Object toJavaObject() throws ESException {
        return null;
    }

    Object copy(HashMap refs) {
        return this;
    }

    public ESBase call(Call eval, int length) throws Throwable {
        throw new ESNullException(this.toStr() + " is not a function");
    }

    public ESBase call(Call eval, int length, ESString key) throws Throwable {
        ESBase call = this.hasProperty(key);
        if (call != null) {
            eval.callee = call;
            return call.call(eval, length);
        }
        if (this.prototype != null && this.prototype != this) {
            return this.prototype.call(eval, length, key);
        }
        throw new ESUndefinedException("undefined call `" + key + "'");
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        throw new ESNullException(this.toStr() + " is not a constructor");
    }

    public Iterator keys() throws Throwable {
        return this.toObject().keys();
    }

    String getClassName() {
        return this.className;
    }

    public ESBase hasProperty(ESString key) throws Throwable {
        ESBase value = this.getProperty(key);
        return value == esEmpty ? null : value;
    }

    ESBase hasProperty(int i) throws Throwable {
        return this.hasProperty(ESString.create(i));
    }

    public ESBase getProperty(String key) throws Throwable {
        return this.getProperty(ESString.create(key));
    }

    ESBase getProperty(int i) throws Throwable {
        return this.getProperty(ESString.create(i));
    }

    public void setProperty(String key, ESBase value) throws Throwable {
        this.setProperty(ESString.create(key), value);
    }

    public void setProperty(int i, ESBase value) throws Throwable {
        this.setProperty(ESString.create(i), value);
    }

    ESBase delete(String key) throws Throwable {
        return this.delete(ESString.create(key));
    }

    ESBase delete(int i) throws Throwable {
        return this.delete(ESString.create(i));
    }

    public ESBase plus(ESBase b) throws Throwable {
        ESBase primA = this.toPrimitive(0);
        ESBase primB = b.toPrimitive(0);
        if (primA instanceof ESString || primB instanceof ESString) {
            return ESString.create(primA.toStr().toString() + primB.toStr().toString());
        }
        return ESNumber.create(primA.toNum() + primB.toNum());
    }

    public boolean lessThan(ESBase ob, boolean neg) throws Throwable {
        ESBase a = this.toPrimitive(0);
        ESBase b = ob.toPrimitive(0);
        if (a instanceof ESString && b instanceof ESString) {
            return ((ESString)a).compareTo((ESString)b) < 0 != neg;
        }
        double da = a.toNum();
        double db = b.toNum();
        if (Double.isNaN(da) || Double.isNaN(db)) {
            return false;
        }
        return da < db != neg;
    }

    public boolean greaterThan(ESBase ob, boolean neg) throws Throwable {
        return ob.lessThan(this, neg);
    }

    public int toInt32() throws Throwable {
        double value = this.toNum();
        if (Double.isInfinite(value)) {
            return 0;
        }
        return (int)((long)value & 0xFFFFFFFFL);
    }

    public String toString() {
        try {
            return this.toStr().toString();
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
            return "";
        }
    }

    public String toJavaString() throws Throwable {
        return this.toStr().toString();
    }

    public boolean ecmaEquals(ESBase b) throws Throwable {
        return this == b;
    }
}

