/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.ErrorParser;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

class JavacErrorParser
extends ErrorParser {
    private CharBuffer token = new CharBuffer();
    private CharBuffer buf = new CharBuffer();
    private ByteToChar lineBuf = ByteToChar.create();

    public JavacErrorParser() throws UnsupportedEncodingException {
        this.lineBuf.setEncoding(System.getProperty("file.encoding"));
    }

    String parseErrors(InputStream is, LineMap lineMap) throws IOException {
        CharBuffer result = new CharBuffer();
        int ch = is.read();
        while (ch > 0) {
            this.lineBuf.clear();
            while (ch > 0 && ch != 10) {
                this.lineBuf.addByte((byte)ch);
                ch = is.read();
            }
            this.lineBuf.addChar('\n');
            String lineString = this.lineBuf.getConvertedString();
            StringCharCursor cursor = new StringCharCursor(lineString);
            String line = this.parseLine(cursor, lineMap);
            if (line == null) {
                result.append(lineString);
            } else {
                result.append(line);
            }
            ch = is.read();
        }
        return result.toString();
    }

    String parseLine(CharCursor is, LineMap lineMap) throws IOException {
        char ch = is.read();
        this.buf.clear();
        String filename = null;
        int line = 0;
        this.token.clear();
        block0: while (true) {
            if (ch == '\uffff') break;
            while (ch == ':') {
                line = 0;
                ch = is.read();
                while (ch >= '0' && ch <= '9') {
                    line = 10 * line + ch - 48;
                    ch = is.read();
                }
                if (ch == ':' && line > 0) {
                    filename = this.token.toString();
                    break block0;
                }
                this.token.append(':');
                if (line <= 0) continue;
                this.token.append(line);
            }
            if (ch != '\uffff') {
                this.token.append(ch);
            }
            ch = is.read();
        }
        if (filename == null) {
            return null;
        }
        boolean column = false;
        while (true) {
            if (ch == '\uffff' || ch == ' ') break;
            ch = is.read();
        }
        while (ch == ' ') {
            ch = is.read();
        }
        this.buf.clear();
        while (true) {
            if (ch == '\uffff') break;
            this.buf.append(ch);
            ch = is.read();
        }
        String message = this.buf.toString();
        if (lineMap != null) {
            return lineMap.convertError(filename, line, 0, message);
        }
        return filename + ":" + line + ": " + message;
    }
}

