/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.util.CharBuffer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class LineMap
implements Serializable {
    private String dstFilename;
    private String srcFilename;
    private String lastSrcFilename;
    private ArrayList lines = new ArrayList();

    public LineMap() {
    }

    public LineMap(String dstFilename, String srcFilename) {
        int tail = dstFilename.lastIndexOf(47);
        this.dstFilename = tail < 0 ? dstFilename : dstFilename.substring(tail + 1);
        this.srcFilename = srcFilename;
        this.lastSrcFilename = srcFilename;
    }

    public LineMap(String dstFilename) {
        int tail = dstFilename.lastIndexOf(47);
        this.dstFilename = tail < 0 ? dstFilename : dstFilename.substring(tail + 1);
    }

    public String getDestFilename() {
        return this.dstFilename;
    }

    public boolean add(String srcFilename, int srcLine, int dstLine) {
        this.lastSrcFilename = srcFilename;
        if (this.lines.size() > 0) {
            Line last = (Line)this.lines.get(this.lines.size() - 1);
            if (last.srcFilename == srcFilename || last.srcFilename != null && last.srcFilename.equals(srcFilename)) {
                if (last.srcLine - srcLine == last.destLine - dstLine) {
                    return false;
                }
                if (last.destLine == dstLine) {
                    last.srcLine = srcLine;
                    return true;
                }
            }
        }
        this.lines.add(new Line(srcFilename, srcLine, dstLine));
        return true;
    }

    public void add(int srcLine, int dstLine) {
        this.add(this.lastSrcFilename, srcLine, dstLine);
    }

    public Iterator iterator() {
        return this.lines.iterator();
    }

    public Line getLine(int line) {
        Line bestMap = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            Line map = (Line)this.lines.get(i);
            if (map.destLine > line) break;
            bestMap = map;
        }
        return bestMap;
    }

    public String convertError(String filename, int line, int column, String message) {
        String srcFilename = null;
        int destLine = 0;
        int srcLine = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            Line map = (Line)this.lines.get(i);
            if (filename != null && !filename.endsWith(this.dstFilename)) continue;
            if (map.destLine > line) break;
            srcFilename = map.srcFilename;
            destLine = map.destLine;
            srcLine = map.srcLine;
        }
        if (srcFilename != null) {
            return srcFilename + ":" + (srcLine + line - destLine) + ": " + message;
        }
        return filename + ":" + line + ": " + message;
    }

    public String convertLine(String filename, int line) {
        Line bestLine = this.getLine(line);
        if (bestLine != null) {
            return bestLine.getSourceFilename() + ":" + bestLine.getSourceLine(line);
        }
        return filename + ":" + line;
    }

    public void printStackTrace(Throwable e, OutputStream os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = this.filter(array);
        if (os != null) {
            byte[] b = cb.toString().getBytes();
            try {
                os.write(b, 0, b.length);
            }
            catch (IOException e1) {}
        } else {
            System.out.println(cb);
        }
    }

    public void printStackTrace(Throwable e, PrintWriter os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = this.filter(array);
        if (os != null) {
            os.print(cb.toString());
        } else {
            System.out.println(cb);
        }
    }

    private CharBuffer filter(char[] array) {
        CharBuffer buf = new CharBuffer();
        CharBuffer fun = new CharBuffer();
        CharBuffer file = new CharBuffer();
        int i = 0;
        while (i < array.length) {
            int end;
            fun.clear();
            file.clear();
            int start = i;
            for (end = i; end < array.length && array[end] != '\n'; ++end) {
            }
            while (i < end && Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            if (!fun.endsWith("at")) {
                for (i = start; i < end; ++i) {
                    buf.append(array[i]);
                }
                i = end + 1;
                buf.append('\n');
                continue;
            }
            while (i < end && Character.isWhitespace(array[i])) {
                ++i;
            }
            fun.clear();
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != '(') {
                fun.append(array[i]);
                ++i;
            }
            if (i < end && array[i] == '(') {
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != ':' && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            int line = -1;
            if (i < end && array[i] == ':') {
                line = 0;
                ++i;
                while (i < end && array[i] >= '0' && array[i] <= '9') {
                    line = 10 * line + array[i] - 48;
                    ++i;
                }
            }
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != ':' && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            buf.append("\tat ");
            buf.append(fun);
            buf.append("(");
            String dstFile = file.toString();
            if (dstFile.equals(this.dstFilename)) {
                this.convertError(buf, line);
            } else {
                buf.append(file);
                if (line > 0) {
                    buf.append(":");
                    buf.append(line);
                }
            }
            buf.append(array, i, end - i);
            buf.append('\n');
            i = end + 1;
        }
        return buf;
    }

    private void convertError(CharBuffer buf, int line) {
        String srcFilename = null;
        int destLine = 0;
        int srcLine = 0;
        int srcTailLine = Integer.MAX_VALUE;
        for (int i = 0; i < this.lines.size(); ++i) {
            Line map = (Line)this.lines.get(i);
            if (map.destLine > line) {
                if (!map.srcFilename.equals(srcFilename) || map.srcLine - srcLine >= line - destLine) break;
                line = destLine;
                break;
            }
            srcFilename = map.srcFilename;
            destLine = map.destLine;
            srcLine = map.srcLine;
        }
        if (srcFilename == null) {
            srcFilename = ((Line)this.lines.get((int)0)).srcFilename;
        }
        buf.append(srcFilename);
        if (line >= 0) {
            buf.append(":");
            buf.append(srcLine + (line - destLine));
        }
    }

    public static class Line
    implements Serializable {
        String srcFilename;
        int srcLine;
        int destLine;

        public Line() {
        }

        Line(String srcFilename, int srcLine, int destLine) {
            this.srcFilename = srcFilename;
            this.srcLine = srcLine;
            this.destLine = destLine;
        }

        public String getSourceFilename() {
            return this.srcFilename;
        }

        public int getSourceLine() {
            return this.srcLine;
        }

        public int getSourceLine(int destLine) {
            return this.srcLine + (destLine - this.destLine);
        }

        public int getDestLine() {
            return this.destLine;
        }

        public String toString() {
            return "[Line " + this.srcFilename + ":" + this.srcLine + " -> " + this.destLine + "]";
        }
    }
}

