/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.LineMap;
import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspParser;
import com.caucho.jsp.JspServletConfig;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.QJspException;
import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.SingleThreadWrapperPage;
import com.caucho.jsp.Taglib;
import com.caucho.jsp.WrapperPage;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.JspFactory;

public class JspManager
extends PageManager {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp/servlet");
    private static int count;
    private boolean precompile;
    private boolean recycleTags;
    private boolean isVelocity;
    private boolean isEL;
    private boolean isFastJstl;
    private HashMap tldMap;

    public JspManager(ServletContext context) throws RegistryException {
        super(context);
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new QJspFactory());
        }
        CauchoApplication app = this.getApplication();
        RegistryNode node = app.getRegistry();
        this.precompile = Registry.getBoolean("/caucho.com/jsp/precompile", true);
        if (node != null) {
            this.precompile = node.getBoolean("/jsp/precompile", this.precompile);
        }
        this.recycleTags = Registry.getBoolean("/caucho.com/jsp/recycle-tags", true);
        if (node != null) {
            this.recycleTags = node.getBoolean("/jsp/recycle-tags", this.recycleTags);
        }
        this.isVelocity = Registry.getBoolean("/caucho.com/jsp/velocity", false);
        if (node != null) {
            this.isVelocity = node.getBoolean("/jsp/velocity", this.isVelocity);
        }
        this.isEL = Registry.getBoolean("/caucho.com/jsp/el", false);
        if (node != null) {
            this.isEL = node.getBoolean("/jsp/el", this.isEL);
        }
        this.isFastJstl = Registry.getBoolean("/caucho.com/jsp/fast-jstl", true);
        if (node != null) {
            this.isFastJstl = node.getBoolean("/jsp/fast-jstl", this.isFastJstl);
        }
    }

    public boolean getPrecompile() {
        return this.precompile;
    }

    public boolean getRecycleTags() {
        return this.recycleTags;
    }

    public boolean isFastJstl() {
        return this.isFastJstl;
    }

    Page createPage(Path path, String uri, String className, String uriPwd, CauchoRequest req) throws Exception {
        Page page = null;
        try {
            CauchoApplication app = req.getCauchoApplication();
            if ((this.precompile || this.autoCompile) && this.preloadIsValid(className, app.getClassLoader(), app.getAppDir())) {
                page = this.loadClass(className, req, null);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (page != null) {
            if (dbg.canWrite()) {
                dbg.log("loading pre-compiled page for " + uri);
            }
            return page;
        }
        if (path == null || !path.canRead() || path.isDirectory() || !this.autoCompile) {
            return null;
        }
        JspParser parser = new JspParser();
        parser.setJspManager(this);
        parser.setClassDir(this.getClassDir());
        parser.setAppDir(this.getApplication().getAppDir());
        parser.setVelocity(this.isVelocity);
        parser.setEL(this.isEL);
        parser.setTldMap(this.getTldMap());
        return parser.parse(path, uri, className, uriPwd, req, this.getApplication());
    }

    HashMap getTldMap() throws QJspException, IOException {
        if (this.tldMap == null) {
            this.tldMap = Taglib.loadAllTlds(this.getApplication(), this.isFastJstl);
        }
        return this.tldMap;
    }

    void killPage(CauchoRequest request, CauchoResponse response, Page page) {
    }

    boolean preloadIsValid(String className, ClassLoader parentLoader, Path appDir) throws Exception {
        String fullClassName = className;
        Path classPath = this.getClassDir().lookup(fullClassName.replace('.', '/') + ".class");
        SimpleClassLoader loader = SimpleClassLoader.create(parentLoader, this.getClassDir(), null);
        Class cl = null;
        try {
            cl = CauchoSystem.loadClass(fullClassName, false, loader);
        }
        catch (Throwable e) {
            if (this.autoCompile) {
                try {
                    classPath.remove();
                }
                catch (IOException e1) {
                    dbg.log(e1);
                }
            }
            return false;
        }
        HttpJspPage jspPage = (HttpJspPage)cl.newInstance();
        if (jspPage instanceof CauchoPage) {
            CauchoPage cPage = (CauchoPage)jspPage;
            LineMap lineMap = new LineMap();
            cPage.init(lineMap, appDir);
            if (this.autoCompile && cPage._caucho_isModified()) {
                return false;
            }
        }
        return true;
    }

    Page loadClass(String className, CauchoRequest req, LineMap lineMap) throws Exception {
        String fullClassName = className;
        Path classPath = this.getClassDir().lookup(fullClassName.replace('.', '/') + ".class");
        CauchoApplication application = req.getCauchoApplication();
        SimpleClassLoader jspLoader = SimpleClassLoader.create(application.getClassLoader(), this.getClassDir(), null);
        Class cl = null;
        try {
            cl = CauchoSystem.loadClass(fullClassName, false, jspLoader);
        }
        catch (Throwable e) {
            if (this.autoCompile) {
                try {
                    classPath.remove();
                }
                catch (IOException e1) {
                    dbg.log(e1);
                }
            }
            throw new ServletException(e);
        }
        HttpJspPage jspPage = (HttpJspPage)cl.newInstance();
        if (jspPage instanceof CauchoPage) {
            CauchoPage cPage = (CauchoPage)jspPage;
            cPage.init(lineMap, application.getAppDir());
        }
        if (!this.autoCompile && jspPage instanceof Page) {
            Page page = (Page)jspPage;
            page._caucho_clearDepends();
        }
        ServletConfig config = null;
        if (req != null) {
            config = (ServletConfig)req.getAttribute("caucho.jsp.servlet-config");
        }
        if (config == null) {
            config = new JspServletConfig(application, null, req.getPageServletPath());
        }
        jspPage.init(config);
        Page page = jspPage instanceof Page ? (Page)jspPage : (jspPage instanceof SingleThreadModel ? new SingleThreadWrapperPage(jspPage) : new WrapperPage(jspPage));
        page._caucho_setJspManager(this);
        return page;
    }

    void unload(Page page) {
    }
}

