/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspParser;
import com.caucho.jsp.QJspException;
import com.caucho.server.http.CauchoApplication;
import com.caucho.util.CauchoSystem;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.xml.sax.SAXException;

class Taglib
extends TagLibraryInfo {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp/taglib");
    static L10N L = new L10N("com/caucho/jsp/messages");
    static IntMap taglibElements = new IntMap();
    static IntMap tagElements;
    static IntMap variableElements;
    static IntMap validatorElements;
    JspParser parser;
    String name;
    ClassLoader loader;
    RegistryNode taglib;
    TagLibraryValidator validator;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Taglib(JspParser parser, CauchoApplication application, String prefix, String uri, String location) throws QJspException {
        super(prefix, uri);
        this.parser = parser;
        this.loader = application.getClassLoader();
        if (uri.equals("jsp")) {
            return;
        }
        try {
            InputStream is = null;
            Path path = location.indexOf(58) >= 0 && location.indexOf(58) < location.indexOf(47) ? application.getAppDir().lookup(location) : (!location.startsWith("/") ? application.getAppDir().lookup("WEB-INF/" + location) : application.getAppDir().lookup("." + location));
            path.setUserPath(location);
            if (location.endsWith(".jar")) {
                path = this.findJar(application.getAppDir(), location);
                if (path == null || !path.exists()) throw parser.error(L.l("Can't find taglib `{0}'.  A taglib uri ending in *.jar must point to an actual jar or match a taglib-uri in a taglib map.", location));
                JarPath jar = new JarPath(path);
                if (jar.lookup("META-INF/taglib.tld").exists()) {
                    is = jar.lookup("META-INF/taglib.tld").openRead();
                } else {
                    if (!jar.lookup("meta-inf/taglib.tld").exists()) throw parser.error(L.l("can't find META-INF/taglib.tld in `{0}'", location));
                    is = jar.lookup("meta-inf/taglib.tld").openRead();
                }
            } else {
                if (is == null && path.exists()) {
                    is = path.openRead();
                }
                if (is == null) {
                    is = application.getResourceAsStream(location);
                }
                if (is == null) {
                    is = this.loader.getResourceAsStream(location);
                }
                if (is == null) {
                    is = application.getResourceAsStream("WEB-INF/taglib.tld");
                }
                if (is == null) {
                    is = this.loader.getResourceAsStream("taglib.tld");
                }
            }
            if (is == null) {
                throw parser.error(L.l("can't find taglib descriptor `{0}'", location));
            }
            if (is instanceof ReadStream) {
                this.name = ((ReadStream)is).getPath().getUserPath();
            }
            Registry registry = null;
            if (is != null) {
                if (is instanceof ReadStream) {
                    registry = Registry.parse((ReadStream)is);
                    is.close();
                } else {
                    ReadStream rs = VfsStream.openRead(is);
                    registry = Registry.parse(rs);
                    rs.close();
                    is.close();
                }
            }
            if (registry != null) {
                this.taglib = registry.getTop().lookup("taglib");
            }
            this.fillTagLibraryInfo();
            return;
        }
        catch (JspParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QJspException(e);
        }
    }

    Taglib(JspParser parser, CauchoApplication app, String prefix, String uri, RegistryNode taglib) throws QJspException {
        super(prefix, uri);
        this.parser = parser;
        this.loader = app.getClassLoader();
        this.taglib = taglib;
        this.name = taglib.getFilename();
        try {
            this.fillTagLibraryInfo();
        }
        catch (JspParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QJspException(e);
        }
    }

    static HashMap loadAllTlds(CauchoApplication app, boolean isFastJstl) throws QJspException, IOException {
        HashMap tldMap = new HashMap();
        Path appDir = app.getAppDir();
        MergePath mergeClassPath = new MergePath();
        mergeClassPath.addClassPath();
        Taglib.loadTlds(app, tldMap, app.getAppDir().lookup("WEB-INF"));
        ArrayList jars = mergeClassPath.getMergePaths();
        for (int i = 0; i < jars.size(); ++i) {
            Path jar = (Path)jars.get(i);
            if (!(jar instanceof JarPath)) continue;
            JarPath jarPath = (JarPath)jar;
            Taglib.loadJarTlds(tldMap, jarPath.getContainer());
        }
        Path path = mergeClassPath.lookup("com/caucho/jstl");
        String[] list = path.list();
        for (int i = 0; i < list.length; ++i) {
            Path subPath = path.lookup(list[i]);
            if (subPath.canRead() && list[i].equals("fmt.tld")) {
                Taglib.parseTld(tldMap, subPath, isFastJstl);
                continue;
            }
            if (!list[i].endsWith(".tld")) continue;
            Taglib.parseTld(tldMap, subPath, false);
        }
        return tldMap;
    }

    static void loadTlds(CauchoApplication app, HashMap tldMap, Path mergePath) throws QJspException, IOException {
        String[] fileNames = mergePath.list();
        for (int i = 0; i < fileNames.length; ++i) {
            String name = fileNames[i];
            Path subPath = mergePath.lookup(name);
            if (subPath.isDirectory()) {
                Taglib.loadTlds(app, tldMap, subPath);
                continue;
            }
            ArrayList files = mergePath.getResources(name);
            for (int j = 0; j < files.size(); ++j) {
                Path path = (Path)files.get(j);
                if (name.startsWith(".") || path.isDirectory() || !name.endsWith(".tld")) continue;
                Taglib.parseTld(tldMap, path, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadJarTlds(HashMap tldMap, Path path) throws QJspException, IOException {
        if (!path.canRead()) {
            return;
        }
        try {
            JarPath jarPath = new JarPath(path);
            String nativePath = path.getNativePath();
            ZipFile zFile = nativePath.endsWith(".jar") ? new JarFile(nativePath) : new ZipFile(nativePath);
            if (zFile != null) {
                Enumeration<? extends ZipEntry> e = zFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".tld")) continue;
                    InputStream is = zFile.getInputStream(entry);
                    ReadStream rs = Vfs.openRead(is);
                    rs.setPath(path.lookup(name));
                    try {
                        Taglib.parseTld(tldMap, rs, false);
                    }
                    finally {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            dbg.log(e);
        }
    }

    static void parseTld(HashMap tldMap, Path path, boolean force) throws QJspException, IOException {
        if (!path.canRead()) {
            return;
        }
        ReadStream is = path.openRead();
        Taglib.parseTld(tldMap, is, force);
    }

    static void parseTld(HashMap tldMap, ReadStream is, boolean force) throws QJspException, IOException {
        String uri;
        Registry registry = null;
        RegistryNode taglib = null;
        try {
            registry = Registry.parse(is);
        }
        catch (SAXException e) {
            dbg.log(e);
            throw new IOExceptionWrapper(e);
        }
        finally {
            is.close();
        }
        if (registry != null) {
            taglib = registry.getTop().lookup("taglib");
        }
        if (taglib != null && (uri = taglib.getString("uri", null)) != null && (tldMap.get(uri) == null || force)) {
            tldMap.put(uri, taglib);
        }
    }

    String getName() {
        return this.name;
    }

    private Path findJar(Path appDir, String location) {
        String sub;
        Path path = location.startsWith("/") ? appDir.lookup("." + location) : appDir.lookup(location);
        if (path.exists()) {
            return path;
        }
        String classPath = ((DynamicClassLoader)this.loader).getClassPath();
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while ((tail = classPath.indexOf(sep, head)) >= 0) {
            sub = classPath.substring(head, tail);
            path = Vfs.lookup(sub);
            if (sub.endsWith(location) && path.exists()) {
                return path;
            }
            head = tail + 1;
        }
        if (head >= classPath.length()) {
            return null;
        }
        sub = classPath.substring(head);
        path = Vfs.lookup(sub);
        if (sub.endsWith(location) && path.exists()) {
            return path;
        }
        return null;
    }

    private void fillTagLibraryInfo() throws Exception {
        if (this.taglib == null) {
            this.tags = new TagInfo[0];
            return;
        }
        this.tlibversion = this.taglib.getString("tlibversion", null);
        this.tlibversion = this.taglib.getString("tlib-version", this.tlibversion);
        this.jspversion = this.taglib.getString("jspversion", null);
        this.jspversion = this.taglib.getString("jsp-version", this.jspversion);
        this.shortname = this.taglib.getString("shortname", null);
        this.shortname = this.taglib.getString("short-name", this.shortname);
        this.urn = this.taglib.getString("uri", null);
        this.info = this.taglib.getString("info", null);
        this.validateConfig(this.taglib, taglibElements);
        ArrayList<TagInfo> tagList = new ArrayList<TagInfo>();
        Iterator iter = this.taglib.iterator();
        while (iter.hasNext()) {
            RegistryNode tag = (RegistryNode)iter.next();
            if (tag.getName().equals("tag")) {
                TagInfo tagInfo = this.fillTag(tag);
                tagList.add(tagInfo);
                continue;
            }
            if (!tag.getName().equals("validator")) continue;
            this.fillValidator(tag);
        }
        this.tags = new TagInfo[tagList.size()];
        tagList.toArray(this.tags);
    }

    TagInfo fillTag(RegistryNode tag) throws IOException, JspParseException, ClassNotFoundException {
        BeanInfo tagBeanInfo;
        TagExtraInfo tei;
        String infoString;
        String bodyContent;
        String teiName;
        String tagClass;
        String tagName;
        block7: {
            tagName = tag.getString("name", null);
            tagClass = tag.getString("tagclass", null);
            tagClass = tag.getString("tag-class", tagClass);
            teiName = tag.getString("teiclass", null);
            teiName = tag.getString("tei-class", teiName);
            bodyContent = tag.getString("bodycontent", null);
            bodyContent = tag.getString("body-content", bodyContent);
            infoString = tag.getString("info", null);
            tei = null;
            this.validateConfig(tag, tagElements);
            if (tagName == null) {
                throw Taglib.error(tag, L.l("{0} expects a `{1}' attribute", (Object)"tag", "name"));
            }
            if (tagClass == null) {
                throw Taglib.error(tag, L.l("{0} expects a `{1}' attribute", (Object)"tag", "tagclass"));
            }
            if (dbg.canWrite()) {
                dbg.log("tag: " + tagName + " class:" + tagClass + " tei:" + teiName + " bodycontent:" + bodyContent);
            }
            tagBeanInfo = null;
            try {
                Class tagCl = CauchoSystem.loadClass(tagClass, false, this.loader);
                tagBeanInfo = Introspector.getBeanInfo(tagCl);
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block7;
                dbg.log(e);
            }
        }
        if (teiName != null) {
            tei = (TagExtraInfo)Beans.instantiate(this.loader, teiName);
        }
        String displayName = tag.getString("display-name", null);
        String smallIcon = tag.getString("small-icon", null);
        String largeIcon = tag.getString("large-icon", null);
        TagAttributeInfo[] attrs = this.fillTagAttrs(tag, tagBeanInfo, tagClass);
        TagVariableInfo[] vars = this.fillTagVars(tag, tagBeanInfo, tagClass);
        TagInfo tagInfo = new TagInfo(tagName, tagClass, bodyContent, infoString, (TagLibraryInfo)this, tei, attrs, displayName, smallIcon, largeIcon, vars);
        if (tei != null) {
            tei.setTagInfo(tagInfo);
        }
        return tagInfo;
    }

    TagAttributeInfo[] fillTagAttrs(RegistryNode tag, BeanInfo info, String tagClassName) throws IOException, JspParseException {
        ArrayList<TagAttributeInfo> attrList = new ArrayList<TagAttributeInfo>();
        PropertyDescriptor[] props = null;
        if (info != null) {
            props = info.getPropertyDescriptors();
        }
        Iterator iter = tag.select("attribute");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            String name = node.getString("name", null);
            boolean required = node.getBoolean("required", false);
            boolean rtvalue = node.getBoolean("rtexprvalue", true);
            String typeName = null;
            if (name == null) {
                throw Taglib.error(tag, L.l("{0} expects a `{1}' attribute", (Object)"attribute", "name"));
            }
            for (int i = 0; props != null && i < props.length; ++i) {
                if (!props[i].getName().equals(name)) continue;
                Class<?> cl = props[i].getPropertyType();
                typeName = cl.getName();
                break;
            }
            if (name == null) continue;
            TagAttributeInfo attr = new TagAttributeInfo(name, required, typeName, rtvalue);
            attrList.add(attr);
        }
        if (attrList.size() == 0) {
            return null;
        }
        TagAttributeInfo[] attrs = new TagAttributeInfo[attrList.size()];
        attrList.toArray(attrs);
        return attrs;
    }

    /*
     * WARNING - void declaration
     */
    TagVariableInfo[] fillTagVars(RegistryNode tag, BeanInfo info, String tagClassName) throws IOException, JspParseException {
        ArrayList<TagVariableInfo> varList = new ArrayList<TagVariableInfo>();
        PropertyDescriptor[] props = null;
        if (info != null) {
            props = info.getPropertyDescriptors();
        }
        Iterator iter = tag.select("variable");
        while (iter.hasNext()) {
            void var14_14;
            int scope;
            RegistryNode node = (RegistryNode)iter.next();
            String nameGiven = node.getString("name-given", null);
            String nameFromAttribute = node.getString("name-from-attribute", null);
            String variableClass = node.getString("variable-class", "java.lang.String");
            boolean declare = node.getBoolean("declare", true);
            String scopeName = node.getString("scope", "NESTED");
            if (nameGiven == null && nameFromAttribute == null) {
                throw Taglib.error(tag, L.l("{0} expects a `{1}' or a `{2}' attribute", "variable", "name-given", "name-from-attribute"));
            }
            String name = nameGiven;
            if (scopeName.equals("NESTED")) {
                scope = VariableInfo.NESTED;
            } else if (scopeName.equals("AT_BEGIN")) {
                scope = VariableInfo.AT_BEGIN;
            } else if (scopeName.equals("AT_END")) {
                scope = VariableInfo.AT_END;
            } else {
                throw Taglib.error(tag, L.l("{0} expects a valid scope at `{1}'", (Object)name, scopeName));
            }
            TagVariableInfo var = new TagVariableInfo(nameGiven, nameFromAttribute, variableClass, declare, (int)var14_14);
            varList.add(var);
        }
        if (varList.size() == 0) {
            return null;
        }
        TagVariableInfo[] vars = new TagVariableInfo[varList.size()];
        varList.toArray(vars);
        return vars;
    }

    void fillValidator(RegistryNode node) throws IOException, JspParseException, ClassNotFoundException {
        String className = Taglib.getRequiredString(node, "validator-class");
        HashMap attributes = new HashMap();
        Iterator iter = node.select("init-param");
        while (iter.hasNext()) {
            RegistryNode initNode = (RegistryNode)iter.next();
            this.fillParam(initNode, attributes);
        }
        try {
            Class cl = CauchoSystem.loadClass(className, false, this.loader);
            this.validator = (TagLibraryValidator)cl.newInstance();
            this.validator.setInitParameters(attributes);
        }
        catch (Exception e) {
            throw Taglib.error(node, e.toString());
        }
    }

    private void fillParam(RegistryNode node, HashMap attributes) {
        Iterator subIter = node.iterator();
        while (subIter.hasNext()) {
            RegistryNode subnode = (RegistryNode)subIter.next();
            if (subnode.getName().equals("param-name")) {
                String initName = subnode.getValue();
                String initValue = node.getString("param-value", null);
                attributes.put(initName, initValue == null ? "" : initValue);
                continue;
            }
            if (subnode.getName().equals("param-value") || subnode.getName().equals("description")) continue;
            attributes.put(subnode.getName(), subnode.getValue());
        }
    }

    TagLibraryValidator getValidator() throws JspParseException {
        return this.validator;
    }

    Class getClass(String tagName) throws Exception {
        String className;
        TagInfo info = this.getTag(tagName);
        String string = className = info == null ? null : info.getTagClassName();
        if (className != null) {
            return CauchoSystem.loadClass(className, false, this.loader);
        }
        return null;
    }

    ArrayList getSingleTagClassNames() {
        ArrayList<String> singleTags = new ArrayList<String>();
        TagInfo[] tags = this.getTags();
        for (int i = 0; tags != null && i < tags.length; ++i) {
            String name = tags[i].getTagClassName();
            if (name == null || name.indexOf(46) >= 0) continue;
            singleTags.add(name);
        }
        return singleTags;
    }

    TagExtraInfo getTagExtraInfo(String tagName) {
        TagInfo info = this.getTag(tagName);
        return info != null ? info.getTagExtraInfo() : null;
    }

    public TagInfo getTag(String name) {
        if (this.tags == null) {
            return null;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].getTagName().equals(name)) continue;
            return this.tags[i];
        }
        return null;
    }

    private void validateConfig(RegistryNode node, IntMap valid) throws JspParseException {
        if (node == null) {
            return;
        }
        Iterator iter = node.iterator();
        while (iter.hasNext()) {
            RegistryNode child = (RegistryNode)iter.next();
            if (valid.get(child.getName()) >= 0) continue;
            throw Taglib.error(child, L.l("unknown element `{0}' in `{1}'", (Object)child.getName(), node.getName()));
        }
    }

    static String getRequiredString(RegistryNode node, String name) throws JspParseException {
        String value = node.getString(name, null);
        if (value == null) {
            throw Taglib.error(node, L.l("expected `{0}' in {1}", (Object)name, node.getName()));
        }
        return value;
    }

    static JspParseException error(RegistryNode tag, String msg) {
        return new JspParseException(tag.getFilename() + ":" + tag.getLine() + " " + msg);
    }

    static {
        taglibElements.put("tlib-version", 1);
        taglibElements.put("jsp-version", 1);
        taglibElements.put("short-name", 1);
        taglibElements.put("uri", 1);
        taglibElements.put("display-name", 1);
        taglibElements.put("small-icon", 1);
        taglibElements.put("large-icon", 1);
        taglibElements.put("description", 1);
        taglibElements.put("validator", 1);
        taglibElements.put("listener", 1);
        taglibElements.put("tag", 1);
        taglibElements.put("tlibversion", 1);
        taglibElements.put("jspversion", 1);
        taglibElements.put("shortname", 1);
        taglibElements.put("info", 1);
        taglibElements.put("taglib-uri", 1);
        taglibElements.put("taglib-location", 1);
        tagElements = new IntMap();
        tagElements.put("name", 1);
        tagElements.put("display-name", 1);
        tagElements.put("tag-class", 1);
        tagElements.put("tei-class", 1);
        tagElements.put("body-content", 1);
        tagElements.put("small-icon", 1);
        tagElements.put("large-icon", 1);
        tagElements.put("description", 1);
        tagElements.put("variable", 1);
        tagElements.put("attribute", 1);
        tagElements.put("info", 1);
        tagElements.put("tagclass", 1);
        tagElements.put("teiclass", 1);
        tagElements.put("bodycontent", 1);
        tagElements.put("example", 1);
        variableElements = new IntMap();
        variableElements.put("name-given", 1);
        variableElements.put("name-from-attribute", 1);
        variableElements.put("variable-class", 1);
        variableElements.put("declare", 1);
        variableElements.put("scope", 1);
        variableElements.put("description", 1);
        variableElements.put("type-from-attribute", 1);
        validatorElements = new IntMap();
        validatorElements.put("validator-class", 1);
        validatorElements.put("init-param", 1);
    }
}

