/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.Node;
import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;

class RegOptim {
    RegOptim() {
    }

    static void ignoreCase(Node node) {
        while (node != null) {
            switch (node.code) {
                case 3: {
                    node.code = 25;
                    break;
                }
                case 4: {
                    node.code = 26;
                    break;
                }
                case 2: {
                    node.code = 24;
                    break;
                }
                case 7: {
                    node.code = 27;
                }
            }
            RegOptim.ignoreCase(node.branch);
            node = node.rest;
        }
    }

    static int minLength(Node node) {
        if (node == null) {
            return 0;
        }
        switch (node.code) {
            case 3: 
            case 4: 
            case 25: 
            case 26: {
                return 1 + RegOptim.minLength(node.rest);
            }
            case 2: 
            case 24: {
                return node.string.length() + RegOptim.minLength(node.rest);
            }
            case 13: 
            case 14: {
                return Math.min(RegOptim.minLength(node.branch), RegOptim.minLength(node.rest));
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                return node.min * RegOptim.minLength(node.branch) + RegOptim.minLength(node.rest);
            }
        }
        return RegOptim.minLength(node.rest);
    }

    static CharBuffer prefix(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.code) {
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return RegOptim.prefix(node.rest);
            }
            case 15: {
                return RegOptim.prefix(node.branch);
            }
            case 2: 
            case 24: {
                return node.string;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (node.min > 0) {
                    return RegOptim.prefix(node.branch);
                }
                return null;
            }
        }
        return null;
    }

    private static CharBuffer findMust(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.code) {
            case 2: {
                CharBuffer string1 = RegOptim.findMust(node.rest);
                return string1 != null ? string1 : node.string;
            }
            case 13: 
            case 14: {
                CharBuffer string1 = RegOptim.findMust(node.branch);
                CharBuffer string2 = RegOptim.findMust(node.rest);
                if (string1 != null && string2 != null && string1.equals(string2)) {
                    return string1;
                }
                return null;
            }
            case 8: 
            case 10: 
            case 11: {
                CharBuffer string1 = RegOptim.findMust(node.rest);
                if (string1 != null) {
                    return string1;
                }
                if (node.min > 0) {
                    return RegOptim.findMust(node.branch);
                }
                return null;
            }
            case 15: {
                CharBuffer string1 = RegOptim.findMust(node.rest);
                if (string1 != null) {
                    return string1;
                }
                return RegOptim.findMust(node.branch);
            }
        }
        return RegOptim.findMust(node.rest);
    }

    private static Node linkLoops(Node node, Node loop, boolean canDeriveNull) {
        if (node == null && loop != null && canDeriveNull) {
            if (loop.min > 0) {
                loop.min = 1;
            }
            return loop;
        }
        if (node == null) {
            return loop;
        }
        switch (node.code) {
            case 0: 
            case 1: {
                return RegOptim.linkLoops(node.rest, loop, canDeriveNull);
            }
            case 13: 
            case 14: {
                if (node.mark) {
                    return node;
                }
                node.mark = true;
                node.branch = RegOptim.linkLoops(node.branch, loop, canDeriveNull);
                node.rest = RegOptim.linkLoops(node.rest, loop, canDeriveNull);
                return node;
            }
            case 8: 
            case 10: 
            case 11: {
                if (node.mark) {
                    if (canDeriveNull && node.min > 0) {
                        node.min = 1;
                    }
                    return node;
                }
                node.mark = true;
                node.branch = RegOptim.linkLoops(node.branch, node, true);
                node.rest = RegOptim.linkLoops(node.rest, loop, canDeriveNull);
                Node init = new Node(9);
                init.rest = node;
                return init;
            }
            case 2: 
            case 3: 
            case 4: 
            case 24: 
            case 25: 
            case 26: {
                node.rest = RegOptim.linkLoops(node.rest, loop, false);
                return node;
            }
        }
        node.rest = RegOptim.linkLoops(node.rest, loop, canDeriveNull);
        return node;
    }

    static Node linkLoops(Node node) {
        return RegOptim.linkLoops(node, null, true);
    }

    static void eliminateBacktrack(Node node, Node rest) {
        if (node == null) {
            return;
        }
        switch (node.code) {
            case 10: {
                RegOptim.eliminateBacktrack(node.branch, node.rest);
                RegOptim.eliminateBacktrack(node.rest, rest);
                if (RegOptim.firstset(node.branch, null) && node.min > 0) {
                    node.min = 1;
                }
                return;
            }
            case 8: {
                RegOptim.eliminateBacktrack(node.branch, node.rest);
                RegOptim.eliminateBacktrack(node.rest, rest);
                RegexpSet left = new RegexpSet();
                if (RegOptim.firstset(node.branch, left) && node.min > 0) {
                    node.min = 0;
                }
                RegexpSet right = new RegexpSet();
                boolean emptyLast = false;
                if (RegOptim.firstset(node.rest, right)) {
                    emptyLast = true;
                    RegOptim.firstset(rest, right);
                }
                if (!emptyLast) {
                    if (right.mergeOverlap(left)) {
                        node.code = 11;
                        node.set = left;
                    } else {
                        left.difference(right);
                        node.set = left;
                    }
                }
                return;
            }
            case 13: 
            case 14: {
                RegexpSet right;
                RegOptim.eliminateBacktrack(node.branch, rest);
                RegOptim.eliminateBacktrack(node.rest, rest);
                boolean emptyFirst = false;
                RegexpSet left = new RegexpSet();
                if (RegOptim.firstset(node.branch, left)) {
                    emptyFirst = RegOptim.firstset(rest, left);
                }
                if (RegOptim.firstset(node.rest, right = new RegexpSet())) {
                    RegOptim.firstset(rest, right);
                }
                if (!emptyFirst && right.mergeOverlap(left)) {
                    node.code = 14;
                    node.set = left;
                }
                return;
            }
            case 15: 
            case 16: {
                RegOptim.eliminateBacktrack(node.branch, rest);
                RegOptim.eliminateBacktrack(node.rest, rest);
                return;
            }
        }
        RegOptim.eliminateBacktrack(node.rest, rest);
    }

    private static boolean firstset(Node node, RegexpSet set) {
        if (node == null) {
            return true;
        }
        switch (node.code) {
            case 2: {
                char ch = node.string.charAt(0);
                if (set != null) {
                    set.setRange(ch, ch);
                }
                return false;
            }
            case 3: {
                if (set != null) {
                    set.mergeOr(node.set);
                }
                return false;
            }
            case 4: {
                if (set != null) {
                    set.mergeOrInv(node.set);
                }
                return false;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (RegOptim.firstset(node.branch, set)) {
                    if (node.min > 0) {
                        node.min = 1;
                    }
                    return RegOptim.firstset(node.rest, set);
                }
                if (node.min == 0) {
                    boolean isFirst = RegOptim.firstset(node.rest, set);
                    return isFirst;
                }
                return false;
            }
            case 13: 
            case 14: {
                if (RegOptim.firstset(node.branch, set)) {
                    RegOptim.firstset(node.rest, set);
                    return true;
                }
                return RegOptim.firstset(node.rest, set);
            }
            case 15: {
                RegexpSet lookahead = new RegexpSet();
                boolean result = RegOptim.firstset(node.rest, set);
                if (set != null && RegOptim.firstset(node.branch, lookahead)) {
                    set.mergeOr(lookahead);
                } else {
                    set.mergeOverlap(lookahead);
                }
                return result;
            }
        }
        return RegOptim.firstset(node.rest, set);
    }

    static Node appendLexemeValue(Node node, int lexeme) {
        if (node == null || node.code == 0 || node.code == 28) {
            node = new Node(28, lexeme);
            node.rest = null;
            return node;
        }
        node.rest = RegOptim.appendLexemeValue(node.rest, lexeme);
        if (node.code == 13) {
            node.branch = RegOptim.appendLexemeValue(node.branch, lexeme);
        }
        return node;
    }

    static Node appendLexeme(Node parent, Node child, int lexeme) {
        child = RegOptim.appendLexemeValue(child, lexeme);
        if (parent == null) {
            return child;
        }
        parent = new Node(13, parent);
        parent.rest = child;
        return parent;
    }
}

