/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.util.CpuUsage;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;

public class ServerStat {
    private static WriteStream dbg = LogStream.open("/caucho.com/tcp-server");
    private CpuUsage baseUsage = CpuUsage.create();
    private long baseStats;
    private long baseActiveThreads;
    private CpuUsage cpuUsage = CpuUsage.create();
    private long stats;
    private long activeThreads;
    private boolean isInit;

    ServerStat() {
        this.cpuUsage.clear();
    }

    void update(CpuUsage usage, long stats, long activeThreads) {
        if (!this.isInit) {
            this.isInit = true;
            this.baseUsage.copy(usage);
        }
        this.cpuUsage.clear();
        this.cpuUsage.add(this.baseUsage, usage);
        this.stats = stats - this.baseStats;
        this.activeThreads = activeThreads - this.baseActiveThreads;
        this.baseUsage.copy(usage);
        this.baseStats = stats;
        this.baseActiveThreads = activeThreads;
    }

    public long getTime() {
        return this.cpuUsage.getTime();
    }

    public long getInterval() {
        return this.cpuUsage.getInterval();
    }

    public long getUserTime() {
        return this.cpuUsage.getUserTime();
    }

    public long getSystemTime() {
        return this.cpuUsage.getSystemTime();
    }

    public long getCpuTime() {
        return this.cpuUsage.getUserTime() + this.cpuUsage.getSystemTime();
    }

    public long getIntervalTime() {
        return this.cpuUsage.getInterval();
    }

    public double getCpuUsage() {
        return (double)this.getCpuTime() / (double)(this.getIntervalTime() + 1L);
    }

    public double getActiveThreads() {
        if (this.stats == 0L) {
            return this.activeThreads;
        }
        return (double)this.activeThreads / (double)this.stats;
    }
}

