/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;

public class InvocationKey {
    private CharSegment host;
    private int port;
    private byte[] uri;
    private int uriLength;
    private boolean isSubrequest;

    public InvocationKey() {
    }

    InvocationKey(CharSegment host, int port, byte[] uri, int uriLength, boolean isSubrequest) {
        if (host != null) {
            CharBuffer cb = CharBuffer.allocate();
            cb.append(host);
            this.host = cb;
        }
        this.port = port;
        this.uri = new byte[uriLength];
        System.arraycopy(uri, 0, this.uri, 0, uriLength);
        this.uriLength = uriLength;
        this.isSubrequest = isSubrequest;
    }

    public void init(CharSegment host, int port, byte[] uri, int uriLength, boolean isSubrequest) {
        this.host = host;
        this.port = port;
        this.uri = uri;
        this.uriLength = uriLength;
        this.isSubrequest = isSubrequest;
    }

    public CharSegment getHost() {
        return this.host;
    }

    public void setHost(CharBuffer host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public byte[] getUriBuffer() {
        return this.uri;
    }

    public int getUriLength() {
        return this.uriLength;
    }

    public boolean isSubrequest() {
        return this.isSubrequest;
    }

    public int hashCode() {
        int hash = this.port + (this.isSubrequest ? 31 : 91);
        byte[] uri = this.uri;
        int length = this.uriLength;
        for (int i = length - 1; i >= 0; --i) {
            hash = 65521 * hash + uri[i];
        }
        if (this.host != null) {
            hash = 65521 * hash + this.host.hashCode();
        }
        return hash;
    }

    public boolean equals(Object b) {
        if (!(b instanceof InvocationKey)) {
            return false;
        }
        InvocationKey test = (InvocationKey)b;
        if (this.port != test.port) {
            return false;
        }
        if (this.isSubrequest != test.isSubrequest) {
            return false;
        }
        int length = this.uriLength;
        if (length != test.uriLength) {
            return false;
        }
        byte[] uriA = this.uri;
        byte[] uriB = test.uri;
        for (int i = length - 1; i >= 0; --i) {
            if (uriA[i] == uriB[i]) continue;
            return false;
        }
        if (this.host == null) {
            return test.host == null;
        }
        return this.host.equals(test.host);
    }

    public String toString() {
        String tail;
        String string = tail = this.isSubrequest ? " subrequest]" : "]";
        if (this.host == null) {
            return "[InvocationKey " + new String(this.uri, 0, this.uriLength) + tail;
        }
        return "[InvocationKey " + this.host + ":" + this.port + " " + new String(this.uri, 0, this.uriLength) + tail;
    }
}

