/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.http.distribution.DistributionServer;
import com.caucho.http.distribution.ObjectBacking;
import com.caucho.http.session.SessionImpl;
import com.caucho.http.session.SessionManager;
import com.caucho.server.Connection;
import com.caucho.server.http.BasicPrincipal;
import com.caucho.server.http.Request;
import com.caucho.server.http.RunnerResponse;
import com.caucho.server.http.ServletServer;
import com.caucho.util.Alarm;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletInputStream;

public class RunnerRequest
extends Request {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/srun");
    public static final int CSE_NULL = 63;
    public static final int CSE_PATH_INFO = 98;
    public static final int CSE_PROTOCOL = 99;
    public static final int CSE_METHOD = 100;
    public static final int CSE_QUERY_STRING = 101;
    public static final int CSE_SERVER_NAME = 102;
    public static final int CSE_SERVER_PORT = 103;
    public static final int CSE_REMOTE_HOST = 104;
    public static final int CSE_REMOTE_ADDR = 105;
    public static final int CSE_REMOTE_PORT = 106;
    public static final int CSE_REAL_PATH = 107;
    public static final int CSE_SCRIPT_FILENAME = 108;
    public static final int CSE_REMOTE_USER = 109;
    public static final int CSE_AUTH_TYPE = 110;
    public static final int CSE_URI = 111;
    public static final int CSE_CONTENT_LENGTH = 112;
    public static final int CSE_CONTENT_TYPE = 113;
    public static final int CSE_IS_SECURE = 114;
    public static final int CSE_SESSION_GROUP = 115;
    public static final int CSE_CLIENT_CERT = 116;
    public static final int CSE_SERVER_TYPE = 117;
    public static final int CSE_STATUS = 83;
    public static final int CSE_SEND_HEADER = 71;
    public static final int CSE_HEADER = 72;
    public static final int CSE_VALUE = 86;
    public static final int CSE_DATA = 68;
    public static final int CSE_FLUSH = 70;
    public static final int CSE_KEEPALIVE = 75;
    public static final int CSE_ACK = 65;
    public static final int CSE_END = 90;
    public static final int CSE_CLOSE = 88;
    public static final int CSE_QUERY = 81;
    public static final int CSE_PING = 80;
    public static final int CSE_SAVE_SESSION = 66;
    public static final int CSE_LOAD_SESSION = 67;
    public static final int CSE_SESSION_DATA = 69;
    public static final int CSE_KILL_SESSION = 73;
    public static final int CSE_SESSION_SRUN = 74;
    public static final int CSE_DUMP_SESSION = 76;
    private CharBuffer method;
    private CharBuffer host;
    private int port;
    private ByteBuffer uri;
    private CharBuffer protocol;
    private int version;
    private CharBuffer remoteAddr;
    private CharBuffer remoteHost;
    private CharBuffer serverName;
    private CharBuffer serverPort;
    private ByteBuffer clientCert;
    private CharBuffer[] headerKeys;
    private CharBuffer[] headerValues;
    private int headerSize;
    private byte[] lengthBuf;
    private int serverType;
    private ReadStream rawRead;
    private WriteStream rawWrite;
    private ReadStream filterRead;
    private WriteStream filterWrite;
    private ServletFilter filter;
    private int pendingData;
    private WriteStream _sessionWriter = new WriteStream();
    private CharBuffer cb1;
    private CharBuffer cb2;
    private boolean keepalive;
    private boolean hasRequest;
    private int srunIndex;

    RunnerRequest(ServletServer server) {
        super(server);
        this.response = new RunnerResponse(this);
        this.response.setIgnoreClientDisconnect(server.getIgnoreClientDisconnect());
        this.uri = new ByteBuffer();
        this.method = new CharBuffer();
        this.host = new CharBuffer();
        this.protocol = new CharBuffer();
        this.headerKeys = new CharBuffer[32];
        this.headerValues = new CharBuffer[32];
        for (int i = 0; i < this.headerKeys.length; ++i) {
            this.headerKeys[i] = new CharBuffer();
            this.headerValues[i] = new CharBuffer();
        }
        this.remoteHost = new CharBuffer();
        this.remoteAddr = new CharBuffer();
        this.serverName = new CharBuffer();
        this.serverPort = new CharBuffer();
        this.clientCert = new ByteBuffer();
        this.cb1 = new CharBuffer();
        this.cb2 = new CharBuffer();
        this.lengthBuf = new byte[16];
        this.filterRead = new ReadStream();
        this.filterRead.setReuseBuffer(true);
        this.filterWrite = new WriteStream();
        this.filterWrite.setReuseBuffer(true);
        this.filter = new ServletFilter();
    }

    public void handleConnection(Connection conn) throws IOException {
        this.setConnection(conn);
        ReadStream rawRead = conn.getReadStream();
        WriteStream rawWrite = conn.getWriteStream();
        if (dbg.canWrite()) {
            dbg.println(this.dbgId() + "start connection");
        }
        while (this.handleRequest(rawRead, rawWrite)) {
            if (!dbg.canWrite()) continue;
            dbg.println(this.dbgId() + "keepalive connection");
        }
        if (dbg.canWrite()) {
            dbg.println(this.dbgId() + "close connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean handleRequest(ReadStream rawRead, WriteStream rawWrite) throws IOException {
        block68: {
            block67: {
                block66: {
                    block56: {
                        block65: {
                            block64: {
                                block63: {
                                    block55: {
                                        this.rawStream = null;
                                        this.rawRead = rawRead;
                                        this.rawWrite = rawWrite;
                                        if (RunnerRequest.dbg.canWrite()) {
                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] start request");
                                        }
                                        this.filter.init(this, rawRead, rawWrite);
                                        this.filterWrite.init(this.filter);
                                        this.filterWrite.setWritePrefix(4);
                                        this.filterRead.init(this.filter, null);
                                        this.rawStream = this.filterRead;
                                        this.response.init(this.filterWrite);
                                        this.serverType = 0;
                                        hasRequest = false;
                                        try {
                                            block51: {
                                                this.start(this.filterRead);
                                                try {
                                                    if (this.scanHeaders()) break block51;
                                                    this.keepalive = false;
                                                    var4_4 = false;
                                                }
                                                catch (InterruptedIOException e) {
                                                    block54: {
                                                        block53: {
                                                            block52: {
                                                                this.keepalive = false;
                                                                RunnerRequest.dbg.log("interrupted keepalive");
                                                                var5_24 = false;
                                                                var8_10 = null;
                                                                if (!hasRequest) {
                                                                    this.response.headersWritten = true;
                                                                }
                                                                try {
                                                                    this.response.finish(false);
                                                                }
                                                                catch (ClientDisconnectException e) {
                                                                    throw e;
                                                                }
                                                                catch (Exception e) {
                                                                    this.keepalive = false;
                                                                    if (!RunnerRequest.dbg.canWrite()) break block52;
                                                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                                    RunnerRequest.dbg.log(e);
                                                                }
                                                            }
                                                            try {
                                                                this.filterWrite.setDisableClose(false);
                                                                this.filterWrite.close();
                                                            }
                                                            catch (ClientDisconnectException e) {
                                                                this.keepalive = false;
                                                                if (RunnerRequest.dbg.canWrite() == false) throw e;
                                                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                                throw e;
                                                            }
                                                            catch (Exception e) {
                                                                this.keepalive = false;
                                                                if (!RunnerRequest.dbg.canWrite()) break block53;
                                                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                                RunnerRequest.dbg.log(e);
                                                            }
                                                        }
                                                        try {
                                                            this.filterRead.setDisableClose(false);
                                                            this.filterRead.close();
                                                        }
                                                        catch (ClientDisconnectException e) {
                                                            throw e;
                                                        }
                                                        catch (Exception e) {
                                                            this.keepalive = false;
                                                            if (!RunnerRequest.dbg.canWrite()) break block54;
                                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                            RunnerRequest.dbg.log(e);
                                                        }
                                                    }
                                                    if (RunnerRequest.dbg.canWrite() == false) return var5_24;
                                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
                                                    return var5_24;
                                                }
                                                var8_9 = null;
                                                if (hasRequest) break block55;
                                                this.response.headersWritten = true;
                                                break block55;
                                            }
                                            if (this.isSecure) {
                                                this.getClientCertificate();
                                            }
                                            hasRequest = true;
                                            this.setStartDate();
                                            this.filter.setPending(this.pendingData);
                                            try {
                                                if (this.method.getLength() == 0) {
                                                    throw new RuntimeException("HTTP protocol exception");
                                                }
                                                this.invocationKey.init(this.getHost(), this.getServerPort(), this.uri.getBuffer(), this.uri.getLength(), false);
                                                invocation = this.server.getInvocation(this.invocationKey, true, true, true, false);
                                                invocation.service(this, this.response);
                                                break block56;
                                            }
                                            catch (ClientDisconnectException e) {
                                                throw e;
                                            }
                                            catch (Throwable e) {
                                                try {
                                                    this.sendServletError(e);
                                                    break block56;
                                                }
                                                catch (ClientDisconnectException e1) {
                                                    throw e1;
                                                }
                                                catch (Exception e1) {
                                                    block59: {
                                                        block58: {
                                                            block57: {
                                                                RunnerRequest.dbg.log(e1);
                                                                var6_27 = false;
                                                                var8_11 = null;
                                                                if (!hasRequest) {
                                                                    this.response.headersWritten = true;
                                                                }
                                                                ** try [egrp 4[TRYBLOCK] [10, 11 : 359->370)] { 
lbl103:
                                                                // 1 sources

                                                                this.response.finish(false);
                                                                break block57;
lbl105:
                                                                // 1 sources

                                                                catch (ClientDisconnectException e) {
                                                                    throw e;
                                                                }
lbl107:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    this.keepalive = false;
                                                                    if (!RunnerRequest.dbg.canWrite()) break block57;
                                                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                                    RunnerRequest.dbg.log(e);
                                                                }
                                                            }
                                                            ** try [egrp 5[TRYBLOCK] [12, 13 : 440->458)] { 
lbl114:
                                                            // 1 sources

                                                            this.filterWrite.setDisableClose(false);
                                                            this.filterWrite.close();
                                                            break block58;
lbl117:
                                                            // 1 sources

                                                            catch (ClientDisconnectException e) {
                                                                this.keepalive = false;
                                                                if (RunnerRequest.dbg.canWrite() == false) throw e;
                                                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                                throw e;
                                                            }
lbl122:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                this.keepalive = false;
                                                                if (!RunnerRequest.dbg.canWrite()) break block58;
                                                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                                RunnerRequest.dbg.log(e);
                                                            }
                                                        }
                                                        ** try [egrp 6[TRYBLOCK] [14, 15 : 583->601)] { 
lbl129:
                                                        // 1 sources

                                                        this.filterRead.setDisableClose(false);
                                                        this.filterRead.close();
                                                        break block59;
lbl132:
                                                        // 1 sources

                                                        catch (ClientDisconnectException e) {
                                                            throw e;
                                                        }
lbl134:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            this.keepalive = false;
                                                            if (!RunnerRequest.dbg.canWrite()) break block59;
                                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                            RunnerRequest.dbg.log(e);
                                                        }
                                                    }
                                                    if (RunnerRequest.dbg.canWrite() == false) return var6_27;
                                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
                                                    return var6_27;
                                                }
                                            }
                                        }
                                        catch (Throwable var7_28) {
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        var8_13 = null;
                                                        if (!hasRequest) {
                                                            this.response.headersWritten = true;
                                                        }
                                                        ** try [egrp 4[TRYBLOCK] [10, 11 : 359->370)] { 
lbl149:
                                                        // 1 sources

                                                        this.response.finish(false);
                                                        break block60;
lbl151:
                                                        // 1 sources

                                                        catch (ClientDisconnectException e) {
                                                            throw e;
                                                        }
lbl153:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            this.keepalive = false;
                                                            if (!RunnerRequest.dbg.canWrite()) break block60;
                                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                            RunnerRequest.dbg.log(e);
                                                        }
                                                    }
                                                    ** try [egrp 5[TRYBLOCK] [12, 13 : 440->458)] { 
lbl160:
                                                    // 1 sources

                                                    this.filterWrite.setDisableClose(false);
                                                    this.filterWrite.close();
                                                    break block61;
lbl163:
                                                    // 1 sources

                                                    catch (ClientDisconnectException e) {
                                                        this.keepalive = false;
                                                        if (RunnerRequest.dbg.canWrite() == false) throw e;
                                                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                        throw e;
                                                    }
lbl168:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        this.keepalive = false;
                                                        if (!RunnerRequest.dbg.canWrite()) break block61;
                                                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                        RunnerRequest.dbg.log(e);
                                                    }
                                                }
                                                ** try [egrp 6[TRYBLOCK] [14, 15 : 583->601)] { 
lbl175:
                                                // 1 sources

                                                this.filterRead.setDisableClose(false);
                                                this.filterRead.close();
                                                break block62;
lbl178:
                                                // 1 sources

                                                catch (ClientDisconnectException e) {
                                                    throw e;
                                                }
lbl180:
                                                // 1 sources

                                                catch (Exception e) {
                                                    this.keepalive = false;
                                                    if (!RunnerRequest.dbg.canWrite()) break block62;
                                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                                    RunnerRequest.dbg.log(e);
                                                }
                                            }
                                            if (RunnerRequest.dbg.canWrite() == false) throw var7_28;
                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
                                            throw var7_28;
                                        }
                                    }
                                    ** try [egrp 4[TRYBLOCK] [10, 11 : 359->370)] { 
lbl191:
                                    // 1 sources

                                    this.response.finish(false);
                                    break block63;
lbl193:
                                    // 1 sources

                                    catch (ClientDisconnectException e) {
                                        throw e;
                                    }
lbl195:
                                    // 1 sources

                                    catch (Exception e) {
                                        this.keepalive = false;
                                        if (!RunnerRequest.dbg.canWrite()) break block63;
                                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                        RunnerRequest.dbg.log(e);
                                    }
                                }
                                ** try [egrp 5[TRYBLOCK] [12, 13 : 440->458)] { 
lbl202:
                                // 1 sources

                                this.filterWrite.setDisableClose(false);
                                this.filterWrite.close();
                                break block64;
lbl205:
                                // 1 sources

                                catch (ClientDisconnectException e) {
                                    this.keepalive = false;
                                    if (RunnerRequest.dbg.canWrite() == false) throw e;
                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                    throw e;
                                }
lbl210:
                                // 1 sources

                                catch (Exception e) {
                                    this.keepalive = false;
                                    if (!RunnerRequest.dbg.canWrite()) break block64;
                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                    RunnerRequest.dbg.log(e);
                                }
                            }
                            ** try [egrp 6[TRYBLOCK] [14, 15 : 583->601)] { 
lbl217:
                            // 1 sources

                            this.filterRead.setDisableClose(false);
                            this.filterRead.close();
                            break block65;
lbl220:
                            // 1 sources

                            catch (ClientDisconnectException e) {
                                throw e;
                            }
lbl222:
                            // 1 sources

                            catch (Exception e) {
                                this.keepalive = false;
                                if (!RunnerRequest.dbg.canWrite()) break block65;
                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                                RunnerRequest.dbg.log(e);
                            }
                        }
                        if (RunnerRequest.dbg.canWrite() == false) return var4_4;
                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
                        return var4_4;
                    }
                    var8_12 = null;
                    if (!hasRequest) {
                        this.response.headersWritten = true;
                    }
                    ** try [egrp 4[TRYBLOCK] [10, 11 : 359->370)] { 
lbl236:
                    // 1 sources

                    this.response.finish(false);
                    break block66;
lbl238:
                    // 1 sources

                    catch (ClientDisconnectException e) {
                        throw e;
                    }
lbl240:
                    // 1 sources

                    catch (Exception e) {
                        this.keepalive = false;
                        if (!RunnerRequest.dbg.canWrite()) break block66;
                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                        RunnerRequest.dbg.log(e);
                    }
                }
                ** try [egrp 5[TRYBLOCK] [12, 13 : 440->458)] { 
lbl247:
                // 1 sources

                this.filterWrite.setDisableClose(false);
                this.filterWrite.close();
                break block67;
lbl250:
                // 1 sources

                catch (ClientDisconnectException e) {
                    this.keepalive = false;
                    if (RunnerRequest.dbg.canWrite() == false) throw e;
                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                    throw e;
                }
lbl255:
                // 1 sources

                catch (Exception e) {
                    this.keepalive = false;
                    if (!RunnerRequest.dbg.canWrite()) break block67;
                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                    RunnerRequest.dbg.log(e);
                }
            }
            ** try [egrp 6[TRYBLOCK] [14, 15 : 583->601)] { 
lbl262:
            // 1 sources

            this.filterRead.setDisableClose(false);
            this.filterRead.close();
            break block68;
lbl265:
            // 1 sources

            catch (ClientDisconnectException e) {
                throw e;
            }
lbl267:
            // 1 sources

            catch (Exception e) {
                this.keepalive = false;
                if (!RunnerRequest.dbg.canWrite()) break block68;
                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + e);
                RunnerRequest.dbg.log(e);
            }
        }
        if (RunnerRequest.dbg.canWrite() == false) return this.keepalive;
        RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
        return this.keepalive;
    }

    private void getClientCertificate() {
        String keySize;
        String cipher = this.getHeader("SSL_CIPHER");
        if (cipher == null) {
            cipher = this.getHeader("HTTPS_CIPHER");
        }
        if (cipher != null) {
            this.setAttribute("javax.servlet.request.cipher_suite", cipher);
        }
        if ((keySize = this.getHeader("SSL_CIPHER_USEKEYSIZE")) == null) {
            keySize = this.getHeader("SSL_SECRETKEYSIZE");
        }
        if (keySize != null) {
            this.setAttribute("javax.servlet.request.key_size", keySize);
        }
        if (this.clientCert.size() == 0) {
            return;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = this.clientCert.createInputStream();
            Certificate cert = cf.generateCertificate(is);
            is.close();
            this.setAttribute("javax.servlet.request.X509Certificate", cert);
            this.setAttribute("com.caucho.servlet.login.name", ((X509Certificate)cert).getSubjectDN());
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    protected boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    protected void start(ReadStream s) throws IOException {
        super.start(s);
        this.method.clear();
        this.protocol.clear();
        this.version = 0;
        this.uri.clear();
        this.host.clear();
        this.port = 0;
        this.headerSize = 0;
        this.remoteHost.clear();
        this.remoteAddr.clear();
        this.serverName.clear();
        this.serverPort.clear();
        this.clientCert.clear();
        this.pendingData = 0;
        this.keepalive = true;
    }

    private boolean scanHeaders() throws IOException {
        boolean hasURI = false;
        block28: while (this.rawRead.readAll(this.lengthBuf, 0, 4) == 4) {
            this.conn.setAccessTime(Alarm.getCurrentTime());
            int code = this.lengthBuf[0] & 0xFF;
            int len = ((this.lengthBuf[1] & 0xFF) << 16) + ((this.lengthBuf[2] & 0xFF) << 8) + (this.lengthBuf[3] & 0xFF);
            switch (code) {
                case 107: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    code = this.rawRead.read();
                    if (code != 86) {
                        throw new IOException("protocol expected CSE_VALUE");
                    }
                    this.cb2.clear();
                    this.rawRead.readAll(this.cb2, this.readLength());
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " " + this.cb1.toString() + "->" + this.cb2.toString());
                    break;
                }
                case 104: {
                    this.rawRead.readAll(this.remoteHost, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " " + this.remoteHost);
                    break;
                }
                case 105: {
                    this.rawRead.readAll(this.remoteAddr, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " " + this.remoteAddr);
                    break;
                }
                case 102: {
                    this.rawRead.readAll(this.serverName, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " server-host: " + this.serverName);
                    break;
                }
                case 103: {
                    this.rawRead.readAll(this.serverPort, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " server-port: " + this.serverPort);
                    break;
                }
                case 100: {
                    this.rawRead.readAll(this.method, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " method: " + this.method);
                    break;
                }
                case 111: {
                    hasURI = true;
                    this.uri.setLength(len);
                    this.rawRead.readAll(this.uri.getBuffer(), 0, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " uri: " + this.uri);
                    break;
                }
                case 101: {
                    if (len <= 0) continue block28;
                    this.uri.add(63);
                    this.uri.ensureCapacity(this.uri.getLength() + len);
                    this.rawRead.readAll(this.uri.getBuffer(), this.uri.getLength(), len);
                    this.uri.setLength(this.uri.getLength() + len);
                    break;
                }
                case 99: {
                    char ch;
                    this.rawRead.readAll(this.protocol, len);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " protocol: " + this.protocol);
                    }
                    for (int i = 0; i < len; ++i) {
                        ch = this.protocol.charAt(i);
                        if (ch >= '0' && ch <= '9') {
                            this.version = 16 * this.version + ch - 48;
                            continue;
                        }
                        if (ch != '.') continue;
                        this.version = 16 * this.version;
                    }
                    continue block28;
                }
                case 72: {
                    if (this.headerSize >= this.headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this.headerKeys[this.headerSize].clear();
                    this.headerValues[this.headerSize].clear();
                    this.rawRead.readAll(this.headerKeys[this.headerSize], len);
                    code = this.rawRead.read();
                    if (code != 86) {
                        throw new IOException("protocol expected CSE_VALUE");
                    }
                    this.rawRead.readAll(this.headerValues[this.headerSize], this.readLength());
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " " + this.headerKeys[this.headerSize] + "=" + this.headerValues[this.headerSize]);
                    }
                    ++this.headerSize;
                    break;
                }
                case 112: {
                    if (this.headerSize >= this.headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this.headerKeys[this.headerSize].clear();
                    this.headerKeys[this.headerSize].append("Content-Length");
                    this.headerValues[this.headerSize].clear();
                    this.rawRead.readAll(this.headerValues[this.headerSize], len);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " content-length=" + this.headerValues[this.headerSize]);
                    }
                    ++this.headerSize;
                    break;
                }
                case 113: {
                    if (this.headerSize >= this.headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this.headerKeys[this.headerSize].clear();
                    this.headerKeys[this.headerSize].append("Content-Type");
                    this.headerValues[this.headerSize].clear();
                    this.rawRead.readAll(this.headerValues[this.headerSize], len);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " content-type=" + this.headerValues[this.headerSize]);
                    }
                    ++this.headerSize;
                    break;
                }
                case 115: {
                    char ch;
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " session_group=" + this.cb1);
                    }
                    this.sessionGroup = 0;
                    for (int i = 0; i < len; ++i) {
                        ch = this.cb1.charAt(i);
                        if (ch < '0' || ch > '9') continue;
                        this.sessionGroup = 10 * this.sessionGroup + ch - 48;
                    }
                    continue block28;
                }
                case 114: {
                    this.isSecure = true;
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + "secure");
                    }
                    this.rawRead.skip(len);
                    break;
                }
                case 116: {
                    this.clientCert.clear();
                    this.clientCert.setLength(len);
                    this.rawRead.readAll(this.clientCert.getBuffer(), 0, len);
                    if (!dbg.canWrite()) continue block28;
                    dbg.log(this.dbgId() + (char)code + " cert=" + this.clientCert + " len:" + len);
                    break;
                }
                case 117: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " server=" + this.cb1);
                    }
                    if (this.cb1.length() <= 0) continue block28;
                    this.serverType = this.cb1.charAt(0);
                    break;
                }
                case 109: {
                    this.cb.clear();
                    this.rawRead.readAll(this.cb, len);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " " + this.cb);
                    }
                    this.setAttribute("com.caucho.servlet.login.name", new BasicPrincipal(this.cb.toString()));
                    break;
                }
                case 68: {
                    this.pendingData = len;
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " post-data: " + len);
                    }
                    return hasURI;
                }
                case 80: {
                    this.rawWrite.write(90);
                    this.rawWrite.write(0);
                    this.rawWrite.write(0);
                    this.rawWrite.write(0);
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " ping: " + len);
                    }
                    return false;
                }
                case 74: {
                    char ch;
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] srun: " + len);
                    }
                    this.srunIndex = 0;
                    for (int i = 0; i < len; ++i) {
                        ch = this.cb1.charAt(i);
                        if (ch < '0' || ch > '9') continue;
                        this.srunIndex = 10 * this.srunIndex + ch - 48;
                    }
                    DistributionServer distServer = this.server.getDistributionServer(this.srunIndex);
                    if (distServer == null) continue block28;
                    distServer.wake();
                    break;
                }
                case 66: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (this.saveSession(this.cb1)) continue block28;
                    this.keepalive = false;
                    return false;
                }
                case 67: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (this.loadSession(this.cb1)) continue block28;
                    this.keepalive = false;
                    return false;
                }
                case 76: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (this.dumpSession(this.cb1)) continue block28;
                    this.keepalive = false;
                    return false;
                }
                case 73: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, len);
                    if (this.killSession(this.cb1)) continue block28;
                    this.keepalive = false;
                    return false;
                }
                case 90: {
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " " + len);
                    }
                    return hasURI;
                }
                case 88: {
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + "close");
                    }
                    this.filter.setClientClosed(true);
                    this.keepalive = false;
                    return false;
                }
                default: {
                    if (dbg.canWrite()) {
                        dbg.log(this.dbgId() + (char)code + " " + len);
                    }
                    this.rawRead.skip(len);
                }
            }
        }
        this.filter.setClientClosed(true);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveSession(CharBuffer cb) throws IOException {
        String objectId;
        int p = cb.lastIndexOf(';');
        if (p < 0) {
            return false;
        }
        String distributionId = cb.substring(0, p);
        ObjectBacking backing = this.server.getDistributedObjectBacking(distributionId, objectId = cb.substring(p + 1));
        if (backing == null) {
            return false;
        }
        SessionImpl session = (SessionImpl)backing.getObject();
        if (session != null) {
            if (backing.canLog()) {
                backing.log(this.dbgId() + "remote-save replace session " + cb);
            }
            SessionImpl sessionImpl = session;
            synchronized (sessionImpl) {
                session.passivate();
                session.setUpdateCount(0);
                session.setNeedsLoad(true);
            }
        }
        TempStream ts = new TempStream(null);
        this._sessionWriter.init(ts);
        boolean debug = backing.canLog();
        if (debug) {
            backing.log(this.dbgId() + "save session: " + cb + " " + backing);
        }
        boolean isClosed = true;
        try {
            block17: while (this.rawRead.readAll(this.lengthBuf, 0, 4) == 4) {
                int code = this.lengthBuf[0] & 0xFF;
                int len = ((this.lengthBuf[1] & 0xFF) << 16) + ((this.lengthBuf[2] & 0xFF) << 8) + (this.lengthBuf[3] & 0xFF);
                switch (code) {
                    case 69: {
                        if (debug) {
                            backing.log(this.dbgId() + "sesson data: " + len);
                        }
                        this._sessionWriter.writeStream(this.rawRead, len);
                        continue block17;
                    }
                    case 88: {
                        isClosed = true;
                        break;
                    }
                    case 90: {
                        this.lengthBuf[0] = 90;
                        this.lengthBuf[1] = 0;
                        this.lengthBuf[2] = 0;
                        this.lengthBuf[3] = 0;
                        this.rawWrite.write(this.lengthBuf, 0, 4);
                        isClosed = false;
                        break;
                    }
                    default: {
                        isClosed = true;
                        break;
                    }
                }
                break;
            }
        }
        finally {
            this._sessionWriter.close();
        }
        ObjectBacking objectBacking = backing;
        synchronized (objectBacking) {
            WriteStream os = null;
            try {
                os = backing.openWrite();
                ReadStream rs = ts.openRead(true);
                os.writeStream(rs);
                rs.close();
            }
            finally {
                os.close();
                ts.destroy();
            }
        }
        return !isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSession(CharBuffer cb) throws IOException {
        boolean bl;
        String objectId;
        int p = cb.lastIndexOf(';');
        if (p < 0) {
            return false;
        }
        String distributionId = cb.substring(0, p);
        ObjectBacking backing = this.server.getDistributedObjectBacking(distributionId, objectId = cb.substring(p + 1));
        if (backing == null) {
            return false;
        }
        TempStream ts = new TempStream(null);
        this._sessionWriter.init(ts);
        ReadStream is = null;
        try {
            ObjectBacking objectBacking = backing;
            synchronized (objectBacking) {
                is = backing.openRead();
                this._sessionWriter.writeStream(is);
            }
        }
        catch (IOException e) {
            if (backing.canLog()) {
                backing.log(this.dbgId() + "load no session: " + backing.getPath());
            }
            this.lengthBuf[0] = 90;
            this.lengthBuf[1] = 0;
            this.lengthBuf[2] = 0;
            this.lengthBuf[3] = 0;
            this.rawWrite.write(this.lengthBuf, 0, 4);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this._sessionWriter.close();
        is = ts.openRead(true);
        TempBuffer tb = TempBuffer.allocate();
        try {
            int len;
            byte[] buffer = tb.getBuffer();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                this.lengthBuf[0] = 69;
                this.lengthBuf[1] = (byte)(len >> 16);
                this.lengthBuf[2] = (byte)(len >> 8);
                this.lengthBuf[3] = (byte)len;
                this.rawWrite.write(this.lengthBuf, 0, 4);
                this.rawWrite.write(buffer, 0, len);
            }
            if (backing.canLog()) {
                backing.log(this.dbgId() + "load session: " + cb.toString() + " " + backing.getPath());
            }
            bl = true;
            Object var13_16 = null;
            this.lengthBuf[0] = 90;
            this.lengthBuf[1] = 0;
            this.lengthBuf[2] = 0;
            this.lengthBuf[3] = 0;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.lengthBuf[0] = 90;
            this.lengthBuf[1] = 0;
            this.lengthBuf[2] = 0;
            this.lengthBuf[3] = 0;
            this.rawWrite.write(this.lengthBuf, 0, 4);
            TempBuffer.free(tb);
            is.close();
            throw throwable;
        }
        this.rawWrite.write(this.lengthBuf, 0, 4);
        TempBuffer.free(tb);
        is.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dumpSession(CharBuffer cb) throws IOException {
        SessionManager manager;
        String runId = cb.toString();
        if (dbg.canWrite()) {
            dbg.log("session dump " + runId + " for " + this.srunIndex);
        }
        if ((manager = (SessionManager)this.server.getDistributedObjectContext(runId)) == null) {
            return false;
        }
        int callerSrunIndex = this.srunIndex;
        WriteStream dbg = manager.getDebug();
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        Iterator iter = manager.getSessionPaths(callerSrunIndex);
        while (iter.hasNext()) {
            Path sessionPath = (Path)iter.next();
            ReadStream is = null;
            try {
                is = sessionPath.openRead();
            }
            catch (IOException e) {
                continue;
            }
            try {
                int len;
                String sessionId = sessionPath.getTail();
                this.writeString(76, sessionId);
                while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                    this.lengthBuf[0] = 69;
                    this.lengthBuf[1] = (byte)(len >> 16);
                    this.lengthBuf[2] = (byte)(len >> 8);
                    this.lengthBuf[3] = (byte)len;
                    this.rawWrite.write(this.lengthBuf, 0, 4);
                    this.rawWrite.write(buffer, 0, len);
                }
                if (!dbg.canWrite()) continue;
                dbg.log("[" + this.server.getServerId() + ", " + this.conn.getId() + "] dump session: " + cb.toString() + " " + sessionPath);
            }
            finally {
                is.close();
            }
        }
        TempBuffer.free(tb);
        this.lengthBuf[0] = 90;
        this.lengthBuf[1] = 0;
        this.lengthBuf[2] = 0;
        this.lengthBuf[3] = 0;
        this.rawWrite.write(this.lengthBuf, 0, 4);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killSession(CharBuffer cb) throws IOException {
        ObjectBacking backing;
        block8: {
            String objectId;
            int p = cb.lastIndexOf(';');
            if (p < 0) {
                return false;
            }
            String distributionId = cb.substring(0, p);
            backing = this.server.getDistributedObjectBacking(distributionId, objectId = cb.substring(p + 1));
            if (backing == null) {
                return false;
            }
            try {
                SessionImpl session = (SessionImpl)backing.getObject();
                if (session == null) break block8;
                SessionImpl sessionImpl = session;
                synchronized (sessionImpl) {
                    if (session.canLog()) {
                        session.log("[" + this.server.getServerId() + ", " + this.conn.getId() + "] remote invalidate session " + cb);
                    }
                    session.getManager().removeSession(session);
                    session.invalidateLocal();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        backing.remove();
        this.lengthBuf[0] = 90;
        this.lengthBuf[1] = 0;
        this.lengthBuf[2] = 0;
        this.lengthBuf[3] = 0;
        this.rawWrite.write(this.lengthBuf, 0, 4);
        return true;
    }

    private void resizeHeaders() {
        int i;
        CharBuffer[] newKeys = new CharBuffer[this.headerSize * 2];
        CharBuffer[] newValues = new CharBuffer[this.headerSize * 2];
        for (i = 0; i < this.headerSize; ++i) {
            newKeys[i] = this.headerKeys[i];
            newValues[i] = this.headerValues[i];
        }
        for (i = this.headerSize; i < newKeys.length; ++i) {
            newKeys[i] = new CharBuffer();
            newValues[i] = new CharBuffer();
        }
        this.headerKeys = newKeys;
        this.headerValues = newValues;
    }

    private int readLength() throws IOException {
        return (this.rawRead.read() << 16) + (this.rawRead.read() << 8) + this.rawRead.read();
    }

    public CharSegment getMethodBuffer() {
        return this.method;
    }

    CharBuffer getHost() {
        if (this.host.length() > 0) {
            return this.host;
        }
        this.host.append(this.serverName);
        this.host.toLowerCase();
        return this.host;
    }

    public byte[] getUriBuffer() {
        return this.uri.getBuffer();
    }

    public int getUriLength() {
        return this.uri.getLength();
    }

    public CharSegment getProtocolBuffer() {
        return this.protocol;
    }

    int getVersion() {
        return this.version;
    }

    public CharSegment getHeaderBuffer(String key) {
        for (int i = 0; i < this.headerSize; ++i) {
            CharBuffer test = this.headerKeys[i];
            if (!test.equalsIgnoreCase(key)) continue;
            return this.headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        for (int i = 0; i < this.headerSize; ++i) {
            int j;
            CharBuffer test = this.headerKeys[i];
            if (test.length() != length) continue;
            char[] keyBuf = test.getBuffer();
            for (j = 0; j < length; ++j) {
                char a = buf[j];
                char b = keyBuf[j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j != length) continue;
            return this.headerValues[i];
        }
        return null;
    }

    public void setHeader(String key, String value) {
        if (this.headerSize >= this.headerKeys.length) {
            this.resizeHeaders();
        }
        this.headerKeys[this.headerSize].clear();
        this.headerKeys[this.headerSize].append(key);
        this.headerValues[this.headerSize].clear();
        this.headerValues[this.headerSize].append(value);
        ++this.headerSize;
    }

    public void getHeaderBuffers(ArrayList values, String key) {
        this.cb.clear();
        this.cb.append(key);
        int size = this.headerSize;
        for (int i = 0; i < size; ++i) {
            CharBuffer test = this.headerKeys[i];
            if (!test.equalsIgnoreCase(this.cb)) continue;
            values.add(this.headerValues[i]);
        }
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            names.add(this.headerKeys[i].toString());
        }
        return Collections.enumeration(names);
    }

    public String getRequestURI() {
        if (this.serverType == 82) {
            return super.getRequestURI();
        }
        String rawURI = super.getRequestURI();
        CharBuffer cb = CharBuffer.allocate();
        block3: for (int i = 0; i < rawURI.length(); ++i) {
            char ch = rawURI.charAt(i);
            switch (ch) {
                case ' ': 
                case '?': {
                    this.addHex(cb, ch);
                    continue block3;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.close();
    }

    private void addHex(CharBuffer cb, int ch) {
        cb.append('%');
        int d = ch >> 4 & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
        d = ch & 0xF;
        if (d < 10) {
            cb.append((char)(48 + d));
        } else {
            cb.append((char)(97 + d - 10));
        }
    }

    public String getServerName() {
        CharBuffer host = this.getHost();
        if (host == null) {
            InetAddress addr = this.conn.getRemoteAddress();
            return addr.getHostName();
        }
        int p = host.indexOf(':');
        if (p >= 0) {
            return host.substring(0, p);
        }
        return host.toString();
    }

    public int getServerPort() {
        int len = this.serverPort.length();
        int port = 0;
        for (int i = 0; i < len; ++i) {
            char ch = this.serverPort.charAt(i);
            port = 10 * port + ch - 48;
        }
        return port;
    }

    public String getRemoteAddr() {
        return this.remoteAddr.toString();
    }

    public void getRemoteAddr(CharBuffer cb) {
        cb.append(this.remoteAddr);
    }

    public String getRemoteHost() {
        return this.remoteHost.toString();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.hasInputStream) {
            return this.is;
        }
        this.hasInputStream = true;
        this.filterStream.init(this.filter, null);
        this.is.init(this.filterStream);
        String charEncoding = this.getCharacterEncoding();
        String javaEncoding = Encoding.getJavaName(charEncoding);
        this.rawStream.setEncoding(javaEncoding);
        return this.is;
    }

    void writeStatus(CharBuffer message) throws IOException {
        this.writeString(83, message);
    }

    void sendHeader() throws IOException {
        this.writeString(71, "");
    }

    void writeHeader(String key, String value) throws IOException {
        this.writeString(72, key);
        this.writeString(86, value);
    }

    void writeHeader(String key, CharBuffer value) throws IOException {
        this.writeString(72, key);
        this.writeString(86, value);
    }

    void writeString(int code, String value) throws IOException {
        int len = value.length();
        this.lengthBuf[0] = (byte)code;
        this.lengthBuf[1] = (byte)(len >> 16);
        this.lengthBuf[2] = (byte)(len >> 8);
        this.lengthBuf[3] = (byte)len;
        this.rawWrite.write(this.lengthBuf, 0, 4);
        this.rawWrite.print(value);
        if (dbg.canWrite()) {
            dbg.log(this.dbgId() + (char)code + " " + value);
        }
    }

    void writeString(int code, CharBuffer cb) throws IOException {
        int len = cb.length();
        this.lengthBuf[0] = (byte)code;
        this.lengthBuf[1] = (byte)(len >> 16);
        this.lengthBuf[2] = (byte)(len >> 8);
        this.lengthBuf[3] = (byte)len;
        this.rawWrite.write(this.lengthBuf, 0, 4);
        this.rawWrite.print(cb.getBuffer(), 0, len);
        if (dbg.canWrite()) {
            dbg.log(this.dbgId() + (char)code + " " + cb);
        }
    }

    String dbgId() {
        return "[" + this.server.getServerId() + ", " + this.conn.getId() + "] ";
    }

    static class ServletFilter
    extends StreamImpl {
        RunnerRequest request;
        ReadStream nextRead;
        WriteStream nextWrite;
        byte[] buffer = new byte[16];
        byte[] _skip = new byte[256];
        int pendingData;
        boolean isFirst = true;
        boolean isClosed;
        boolean isClientClosed;

        ServletFilter() {
        }

        void init(RunnerRequest request, ReadStream nextRead, WriteStream nextWrite) {
            this.request = request;
            this.nextRead = nextRead;
            this.nextWrite = nextWrite;
            this.pendingData = 0;
            this.isClosed = false;
            this.isClientClosed = false;
            this.isFirst = true;
        }

        void setPending(int pendingData) {
            this.pendingData = pendingData;
        }

        void setClientClosed(boolean isClientClosed) {
            this.isClientClosed = isClientClosed;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() {
            return this.pendingData;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            if (this.pendingData <= 0) {
                return -1;
            }
            int sublen = this.pendingData;
            if (length < sublen) {
                sublen = length;
            }
            int readLen = this.nextRead.read(buf, offset, sublen);
            this.pendingData -= readLen;
            while (this.pendingData == 0) {
                if (!this.isFirst) {
                    this.buffer[0] = 65;
                    this.buffer[1] = 0;
                    this.buffer[2] = 0;
                    this.buffer[3] = 0;
                    this.nextWrite.write(this.buffer, 0, 4);
                    if (dbg.canWrite()) {
                        dbg.log(this.request.dbgId() + "ack");
                    }
                }
                this.isFirst = false;
                int code = this.nextRead.read();
                int len = (this.nextRead.read() << 16) + (this.nextRead.read() << 8) + this.nextRead.read();
                if (code == 68) {
                    if (dbg.canWrite()) {
                        dbg.log(this.request.dbgId() + "D " + len);
                    }
                    this.pendingData = len;
                    continue;
                }
                if (code == 90) {
                    if (dbg.canWrite()) {
                        dbg.log(this.request.dbgId() + "Z");
                    }
                    return readLen;
                }
                if (code == 88) {
                    if (dbg.canWrite()) {
                        dbg.log(this.request.dbgId() + "X");
                    }
                    this.request.keepalive = false;
                    return readLen;
                }
                this.request.keepalive = false;
                return readLen;
            }
            return readLen;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            length -= 4;
            if (dbg.canWrite()) {
                dbg.log(this.request.dbgId() + "d " + length);
            }
            buf[0] = 68;
            buf[1] = (byte)(length >> 16);
            buf[2] = (byte)(length >> 8);
            buf[3] = (byte)length;
            this.nextWrite.write(buf, offset, length + 4);
        }

        public void flush() throws IOException {
            if (dbg.canWrite()) {
                dbg.log(this.request.dbgId() + "F flush");
            }
            this.buffer[0] = 70;
            this.buffer[1] = 0;
            this.buffer[2] = 0;
            this.buffer[3] = 0;
            this.nextWrite.write(this.buffer, 0, 4);
            this.nextWrite.flush();
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            while (this.pendingData > 0 && this.read(this._skip, 0, this._skip.length) > 0) {
            }
            if (!this.isClientClosed) {
                this.buffer[1] = 0;
                this.buffer[2] = 0;
                this.buffer[3] = 0;
                if (!this.request.keepalive || !this.request.conn.allocateKeepalive()) {
                    this.request.keepalive = false;
                }
                if (dbg.canWrite()) {
                    dbg.log(this.request.dbgId() + (this.request.keepalive ? "Z" : "X"));
                }
                this.buffer[0] = (byte)(this.request.keepalive ? 90 : 88);
                this.nextWrite.write(this.buffer, 0, 4);
            }
            if (this.request.keepalive) {
                this.nextWrite.flush();
            } else {
                this.nextWrite.close();
            }
        }
    }
}

