/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharSegment;
import com.caucho.util.FreeList;
import java.io.InputStream;

public final class CharBuffer
extends CharSegment {
    private static FreeList freeList = new FreeList(128);
    private int capacity;

    public CharBuffer() {
        this.capacity = 16;
        this.buffer = new char[this.capacity];
        this.length = 0;
    }

    public CharBuffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (capacity < 16) {
            capacity = 16;
        }
        this.capacity = capacity;
        this.buffer = new char[capacity];
        this.length = 0;
    }

    public CharBuffer(String string) {
        this.capacity = string.length();
        if (this.capacity < 16) {
            this.capacity = 16;
        }
        this.buffer = new char[this.capacity];
        this.length = string.length();
        string.getChars(0, this.length, this.buffer, 0);
    }

    public CharBuffer(String string, int offset, int length) {
        this.capacity = length;
        if (this.capacity < 16) {
            this.capacity = 16;
        }
        this.buffer = new char[this.capacity];
        string.getChars(offset, length, this.buffer, 0);
    }

    public static CharBuffer allocate() {
        CharBuffer cb = (CharBuffer)freeList.allocate();
        if (cb != null) {
            cb.length = 0;
            return cb;
        }
        return new CharBuffer();
    }

    public void free() {
        if (this.capacity <= 256) {
            freeList.free(this);
        }
    }

    public int length() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int capacity() {
        return this.capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this.capacity) {
            return;
        }
        int oldCapacity = this.capacity;
        if (minimumCapacity > 4096) {
            this.capacity = 4096 * ((minimumCapacity + 4095) / 4096);
        } else {
            while (this.capacity < minimumCapacity) {
                this.capacity *= 2;
            }
        }
        char[] chars = new char[this.capacity];
        System.arraycopy(this.buffer, 0, chars, 0, oldCapacity);
        this.buffer = chars;
    }

    public final void clear() {
        this.length = 0;
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("illegal argument");
        }
        if (newLength > this.capacity) {
            this.ensureCapacity(newLength);
        }
        this.length = newLength;
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[i];
    }

    public char getLastChar() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.length - 1];
    }

    public final char[] getBuffer() {
        return this.buffer;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = this.buffer[srcBegin++];
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer[index] = ch;
    }

    public CharBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public CharBuffer append(CharBuffer cb) {
        return this.append(cb.buffer, 0, cb.length);
    }

    public CharBuffer append(String string) {
        int len;
        if (string == null) {
            string = "null";
        }
        if ((len = string.length()) + this.length >= this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        string.getChars(0, len, this.buffer, this.length);
        this.length += len;
        return this;
    }

    public CharBuffer append(String string, int offset, int len) {
        if (len + this.length >= this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        string.getChars(offset, offset + len, this.buffer, this.length);
        this.length += len;
        return this;
    }

    public CharBuffer append(char[] buffer) {
        return this.append(buffer, 0, buffer.length);
    }

    public CharBuffer append(char[] buffer, int offset, int length) {
        if (this.length + length > this.capacity) {
            this.ensureCapacity(this.length + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.length, length);
        this.length += length;
        return this;
    }

    public final CharBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public final CharBuffer append(char ch) {
        if (this.length >= this.capacity) {
            this.ensureCapacity(this.length + 1);
        }
        this.buffer[this.length++] = ch;
        return this;
    }

    public CharBuffer append(int i) {
        if (this.length + 16 >= this.capacity) {
            this.ensureCapacity(this.length + 16);
        }
        if (i < 0) {
            this.buffer[this.length++] = 45;
            i = -i;
        } else if (i == 0) {
            this.buffer[this.length++] = 48;
            return this;
        }
        int start = this.length;
        while (i > 0) {
            this.buffer[this.length++] = (char)(i % 10 + 48);
            i /= 10;
        }
        for (int j = (this.length - start) / 2; j > 0; --j) {
            char temp = this.buffer[this.length - j];
            this.buffer[this.length - j] = this.buffer[start + j - 1];
            this.buffer[start + j - 1] = temp;
        }
        return this;
    }

    public CharBuffer append(long i) {
        if (this.length + 32 >= this.capacity) {
            this.ensureCapacity(this.length + 32);
        }
        if (i < 0L) {
            this.buffer[this.length++] = 45;
            i = -i;
        } else if (i == 0L) {
            this.buffer[this.length++] = 48;
            return this;
        }
        int start = this.length;
        while (i > 0L) {
            this.buffer[this.length++] = (char)(i % 10L + 48L);
            i /= 10L;
        }
        for (int j = (this.length - start) / 2; j > 0; --j) {
            char temp = this.buffer[this.length - j];
            this.buffer[this.length - j] = this.buffer[start + j - 1];
            this.buffer[start + j - 1] = temp;
        }
        return this;
    }

    public CharBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public CharBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final CharBuffer append(byte[] buf, int offset, int len) {
        if (this.length + len >= this.capacity) {
            this.ensureCapacity(this.length + len);
        }
        while (len > 0) {
            this.buffer[this.length++] = (char)buf[offset++];
            --len;
        }
        return this;
    }

    public CharBuffer delete(int start, int end) {
        if (start < 0 || start > end || start > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (end > this.length) {
            end = this.length;
        }
        int tail = this.length - end;
        for (int i = 0; i < tail; ++i) {
            this.buffer[start + i] = this.buffer[end + i];
        }
        this.length -= end - start;
        return this;
    }

    public CharBuffer deleteCharAt(int index) {
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (index == this.length) {
            return this;
        }
        int tail = this.length - index + 1;
        for (int i = 0; i < tail; ++i) {
            this.buffer[index + i] = this.buffer[index + i + 1];
        }
        --this.length;
        return this;
    }

    public CharBuffer replace(int start, int end, String string) {
        if (start < 0 || start > end || start > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = string.length();
        if (len + this.length - (end - start) > this.capacity) {
            this.ensureCapacity(len + this.length - (end - start));
        }
        if (len < end - start) {
            int tail = this.length - end;
            for (int i = 0; i < tail; ++i) {
                this.buffer[start + len + i] = this.buffer[end + i];
            }
        } else {
            int tail = this.length - end;
            for (int i = tail - 1; i >= 0; --i) {
                this.buffer[end + i] = this.buffer[start + len + i];
            }
        }
        string.getChars(0, len, this.buffer, start);
        this.length += len - (end - start);
        return this;
    }

    public CharBuffer replace(int start, int end, char[] buffer, int offset, int len) {
        if (start < 0 || start > end || start > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len + this.length - (end - start) > this.capacity) {
            this.ensureCapacity(len + this.length - (end - start));
        }
        if (len < end - start) {
            int tail = this.length - end;
            for (int i = 0; i < tail; ++i) {
                this.buffer[start + len + i] = this.buffer[end + i];
            }
        } else {
            int tail = this.length - end;
            for (int i = tail - 1; i >= 0; --i) {
                this.buffer[end + i] = this.buffer[start + len + i];
            }
        }
        System.arraycopy(buffer, offset, this.buffer, start, len);
        this.length += len - (end - start);
        return this;
    }

    public String substring(int start) {
        if (start > this.length || start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, start, this.length - start);
    }

    public String substring(int start, int end) {
        if (start > this.length || start < 0 || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, start, end - start);
    }

    public CharBuffer insert(int index, String string) {
        if (string == null) {
            string = "null";
        }
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = string.length();
        if (this.length + len > this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        int tail = this.length - index;
        for (int i = tail - 1; i >= 0; --i) {
            this.buffer[index + len + i] = this.buffer[index + i];
        }
        string.getChars(0, len, this.buffer, index);
        this.length += len;
        return this;
    }

    public CharBuffer insert(int index, char[] buffer, int offset, int len) {
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (len + this.length > this.capacity) {
            this.ensureCapacity(len + this.length);
        }
        int tail = this.length - index;
        for (int i = tail - 1; i >= 0; --i) {
            this.buffer[index + len + i] = this.buffer[index + i];
        }
        System.arraycopy(buffer, offset, this.buffer, index, len);
        this.length += len;
        return this;
    }

    public CharBuffer insert(int offset, Object o) {
        return this.insert(offset, String.valueOf(o));
    }

    public CharBuffer insert(int offset, char ch) {
        return this.insert(offset, String.valueOf(ch));
    }

    public CharBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public CharBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public CharBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public CharBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(char ch, int start) {
        if (start < 0) {
            start = 0;
        }
        while (start < this.length) {
            if (this.buffer[start] == ch) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int lastIndexOf(char ch, int start) {
        if (start >= this.length) {
            start = this.length - 1;
        }
        while (start >= 0) {
            if (this.buffer[start] == ch) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.length - 1);
    }

    public Object clone() {
        CharBuffer newBuffer = new CharBuffer();
        newBuffer.setLength(this.length);
        System.arraycopy(this.buffer, 0, newBuffer.buffer, 0, this.length);
        return newBuffer;
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public String close() {
        String string = new String(this.buffer, 0, this.length);
        this.free();
        return string;
    }

    public InputStream getInputStream() {
        return new CBInputStream();
    }

    class CBInputStream
    extends InputStream {
        int index = 0;

        CBInputStream() {
        }

        public int read() {
            if (this.index >= CharBuffer.this.length) {
                return -1;
            }
            return CharBuffer.this.buffer[this.index++];
        }
    }
}

