/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class QDate {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY_OF_MONTH = 2;
    public static final int DAY = 3;
    public static final int DAY_OF_WEEK = 4;
    public static final int HOUR = 5;
    public static final int MINUTE = 6;
    public static final int SECOND = 7;
    public static final int MILLISECOND = 8;
    public static final int TIME = 9;
    public static final int TIME_ZONE = 10;
    static final long MS_PER_DAY = 86400000L;
    static final long MS_PER_EON = 12622780800000L;
    static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static String[] dayNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static String stdZoneName;
    static String dstZoneName;
    private static QDate globalDate;
    private String zoneName;
    private TimeZone localTimeZone;
    private TimeZone utcTimeZone;
    private DateFormat dateFormat;
    private Date date;
    private long eonYear;
    private long time;
    private long days;
    private long year;
    private int dayOfYear;
    private long month;
    private long dayOfMonth;
    private long hour;
    private long minute;
    private long second;
    private long ms;
    private boolean isLeapYear;
    private long timeOfDay;
    private long zoneOffset;
    private long lastTime;
    private String lastDate;
    private static String[] shortWeekday;
    private static String[] longWeekday;
    private static String[] shortMonth;
    private static String[] longMonth;

    public QDate() {
        if (stdZoneName == null) {
            SimpleDateFormat zoneFormatter = new SimpleDateFormat("z");
            GregorianCalendar calendar = new GregorianCalendar(1970, 12, 23);
            stdZoneName = zoneFormatter.format(calendar.getTime());
            calendar = new GregorianCalendar(1970, 6, 23);
            dstZoneName = zoneFormatter.format(calendar.getTime());
        }
        this.localTimeZone = TimeZone.getDefault();
        this.utcTimeZone = TimeZone.getTimeZone("UTC");
    }

    public TimeZone getLocalTimeZone() {
        return this.localTimeZone;
    }

    private boolean isLeapYear(long year) {
        return year % 4L == 0L && (year % 100L != 0L || year % 400L == 0L);
    }

    private long divFloor(long n, long d) {
        if (n > 0L) {
            return n / d;
        }
        return (n - d + 1L) / d;
    }

    private void calculateYear() {
        long n1;
        long n4;
        long n400;
        long n100;
        long days = this.days;
        days += 134774L;
        if ((n100 = this.divFloor(days -= (n400 = this.divFloor(days, 146097L)) * 146097L, 36524L)) == 4L) {
            n100 = 3L;
        }
        if ((n4 = this.divFloor(days -= n100 * 36524L, 1461L)) == 25L) {
            n4 = 24L;
        }
        if ((n1 = this.divFloor(days -= n4 * 1461L, 365L)) == 4L) {
            n1 = 3L;
        }
        this.year = 400L * n400 + 100L * n100 + 4L * n4 + n1 + 1601L;
        this.dayOfYear = (int)(days - 365L * n1);
        this.isLeapYear = this.isLeapYear(this.year);
    }

    private void calculateMonth() {
        this.dayOfMonth = this.dayOfYear;
        this.month = 0L;
        while (this.month < 12L) {
            if (this.month == 1L && this.isLeapYear) {
                if (this.dayOfMonth < 29L) {
                    return;
                }
                this.dayOfMonth -= 29L;
            } else {
                if (this.dayOfMonth < (long)DAYS_IN_MONTH[(int)this.month]) {
                    return;
                }
                this.dayOfMonth -= (long)DAYS_IN_MONTH[(int)this.month];
            }
            ++this.month;
        }
    }

    private void calculateSplit(long time) {
        this.time = time;
        this.days = this.divFloor(time, 86400000L);
        this.timeOfDay = time - 86400000L * this.days;
        this.calculateYear();
        this.calculateMonth();
        this.hour = this.timeOfDay / 3600000L;
        this.minute = this.timeOfDay / 60000L % 60L;
        this.second = this.timeOfDay / 1000L % 60L;
        this.ms = this.timeOfDay % 1000L;
    }

    private long yearToDay(long year) {
        if (year > 0L) {
            return 365L * (year -= 1601L) + year / 4L - year / 100L + year / 400L - 134774L;
        }
        year = 2000L - year;
        return 10957L - (365L * year + year / 4L - year / 100L + year / 400L);
    }

    private long monthToDay(long month, boolean isLeapYear) {
        long day = 0L;
        for (int i = 0; (long)i < month && i < 12; ++i) {
            day += (long)DAYS_IN_MONTH[i];
            if (i != 1 || !isLeapYear) continue;
            ++day;
        }
        return day;
    }

    private long calculateJoin() {
        this.year += this.divFloor(this.month, 12L);
        this.month -= 12L * this.divFloor(this.month, 12L);
        this.time = 86400000L * (this.yearToDay(this.year) + this.monthToDay(this.month, this.isLeapYear(this.year)) + this.dayOfMonth);
        this.time += this.ms + 1000L * (this.second + 60L * (this.minute + 60L * this.hour));
        return this.time;
    }

    public String printDate() {
        if (this.lastDate != null && this.lastTime == this.time) {
            return this.lastDate;
        }
        CharBuffer cb = CharBuffer.allocate();
        this.printDate(cb);
        this.lastDate = cb.close();
        this.lastTime = this.time;
        return this.lastDate;
    }

    public void printDate(CharBuffer cb) {
        cb.append(dayNames[(int)(this.days % 7L + 11L) % 7]);
        cb.append(", ");
        cb.append((this.dayOfMonth + 1L) / 10L);
        cb.append((this.dayOfMonth + 1L) % 10L);
        cb.append(" ");
        cb.append(monthNames[(int)this.month]);
        cb.append(" ");
        cb.append(this.year);
        cb.append(" ");
        cb.append(this.timeOfDay / 36000000L % 10L);
        cb.append(this.timeOfDay / 3600000L % 10L);
        cb.append(":");
        cb.append(this.timeOfDay / 600000L % 6L);
        cb.append(this.timeOfDay / 60000L % 10L);
        cb.append(":");
        cb.append(this.timeOfDay / 10000L % 6L);
        cb.append(this.timeOfDay / 1000L % 10L);
        if (this.zoneName == null) {
            cb.append(" GMT");
            return;
        }
        long offset = this.zoneOffset;
        if (offset < 0L) {
            cb.append(" -");
            offset = -offset;
        } else {
            cb.append(" +");
        }
        cb.append(offset / 36000000L % 10L);
        cb.append(offset / 3600000L % 10L);
        cb.append(offset / 600000L % 6L);
        cb.append(offset / 60000L % 10L);
        cb.append(" (");
        cb.append(this.zoneName);
        cb.append(")");
    }

    public void printDate(WriteStream os) throws IOException {
        os.print(dayNames[(int)(this.days % 7L + 11L) % 7]);
        os.write(44);
        os.write(32);
        os.print((this.dayOfMonth + 1L) / 10L);
        os.print((this.dayOfMonth + 1L) % 10L);
        os.write(32);
        os.print(monthNames[(int)this.month]);
        os.write(32);
        os.print(this.year);
        os.write(32);
        os.print(this.timeOfDay / 36000000L % 10L);
        os.print(this.timeOfDay / 3600000L % 10L);
        os.write(58);
        os.print(this.timeOfDay / 600000L % 6L);
        os.print(this.timeOfDay / 60000L % 10L);
        os.write(58);
        os.print(this.timeOfDay / 10000L % 6L);
        os.print(this.timeOfDay / 1000L % 10L);
        if (this.zoneName == null) {
            os.print(" GMT");
            return;
        }
        long offset = this.zoneOffset;
        if (offset < 0L) {
            os.write(32);
            os.write(45);
            offset = -offset;
        } else {
            os.write(32);
            os.write(43);
        }
        os.print(offset / 36000000L % 10L);
        os.print(offset / 3600000L % 10L);
        os.print(offset / 600000L % 6L);
        os.print(offset / 60000L % 10L);
        os.write(32);
        os.write(40);
        os.print(this.zoneName);
        os.write(41);
    }

    public String printISO8601() {
        CharBuffer cb = new CharBuffer();
        if (this.year > 0L) {
            cb.append(this.year / 1000L % 10L);
            cb.append(this.year / 100L % 10L);
            cb.append(this.year / 10L % 10L);
            cb.append(this.year % 10L);
            cb.append((this.month + 1L) / 10L % 10L);
            cb.append((this.month + 1L) % 10L);
            cb.append((this.dayOfMonth + 1L) / 10L % 10L);
            cb.append((this.dayOfMonth + 1L) % 10L);
        }
        if (this.timeOfDay != 0L || this.year <= 0L) {
            long time = this.timeOfDay / 1000L;
            cb.append("T");
            cb.append(time / 36000L % 10L);
            cb.append(time / 3600L % 10L);
            if (time % 3600L != 0L) {
                cb.append(time / 600L % 6L);
                cb.append(time / 60L % 10L);
                if (time % 60L != 0L) {
                    cb.append(time / 10L % 6L);
                    cb.append(time / 1L % 10L);
                }
            }
        }
        if (this.zoneName == null) {
            cb.append("Z");
            return cb.toString();
        }
        return cb.toString();
    }

    public String printISO8601Date() {
        CharBuffer cb = new CharBuffer();
        if (this.year > 0L) {
            cb.append(this.year / 1000L % 10L);
            cb.append(this.year / 100L % 10L);
            cb.append(this.year / 10L % 10L);
            cb.append(this.year % 10L);
            cb.append('-');
            cb.append((this.month + 1L) / 10L % 10L);
            cb.append((this.month + 1L) % 10L);
            cb.append('-');
            cb.append((this.dayOfMonth + 1L) / 10L % 10L);
            cb.append((this.dayOfMonth + 1L) % 10L);
        }
        return cb.toString();
    }

    public static synchronized String format(long time, String format) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(time, false);
        return globalDate.format(CharBuffer.allocate(), format).close();
    }

    public static synchronized String format(long time) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(time, false);
        return globalDate.printDate();
    }

    public static synchronized String formatLocal(long time, String format) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(time, true);
        return globalDate.format(CharBuffer.allocate(), format).close();
    }

    public static synchronized String formatLocal(long time) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(time, true);
        return globalDate.printDate();
    }

    public static synchronized CharBuffer formatLocal(CharBuffer cb, long time, String format) {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        globalDate.calculate(time, true);
        return globalDate.format(cb, format);
    }

    public static QDate getGlobalDate() {
        if (globalDate == null) {
            globalDate = new QDate();
        }
        return globalDate;
    }

    public String format(String format) {
        CharBuffer cb = new CharBuffer();
        return this.format(cb, format).close();
    }

    public CharBuffer format(CharBuffer cb, String format) {
        int length = format.length();
        block22: for (int i = 0; i < length; ++i) {
            char ch = format.charAt(i);
            if (ch != '%') {
                cb.append(ch);
                continue;
            }
            switch (format.charAt(++i)) {
                case 'a': {
                    cb.append(shortWeekday[this.getDayOfWeek()]);
                    continue block22;
                }
                case 'A': {
                    cb.append(longWeekday[this.getDayOfWeek()]);
                    continue block22;
                }
                case 'b': {
                    cb.append(shortMonth[(int)this.month]);
                    continue block22;
                }
                case 'B': {
                    cb.append(longMonth[(int)this.month]);
                    continue block22;
                }
                case 'c': {
                    cb.append(this.printLocaleDate());
                    continue block22;
                }
                case 'd': {
                    cb.append((this.dayOfMonth + 1L) / 10L);
                    cb.append((this.dayOfMonth + 1L) % 10L);
                    continue block22;
                }
                case 'H': {
                    int hour = (int)(this.timeOfDay / 3600000L) % 24;
                    cb.append(hour / 10);
                    cb.append(hour % 10);
                    continue block22;
                }
                case 'I': {
                    int hour = (int)(this.timeOfDay / 3600000L) % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    cb.append(hour / 10);
                    cb.append(hour % 10);
                    continue block22;
                }
                case 'j': {
                    cb.append((this.dayOfYear + 1) / 100);
                    cb.append((this.dayOfYear + 1) / 10 % 10);
                    cb.append((this.dayOfYear + 1) % 10);
                    continue block22;
                }
                case 'm': {
                    cb.append((this.month + 1L) / 10L);
                    cb.append((this.month + 1L) % 10L);
                    continue block22;
                }
                case 'M': {
                    cb.append(this.timeOfDay / 600000L % 6L);
                    cb.append(this.timeOfDay / 60000L % 10L);
                    continue block22;
                }
                case 'p': {
                    int hour = (int)(this.timeOfDay / 3600000L) % 24;
                    if (hour < 12) {
                        cb.append("am");
                        continue block22;
                    }
                    cb.append("pm");
                    continue block22;
                }
                case 'S': {
                    cb.append(this.timeOfDay / 10000L % 6L);
                    cb.append(this.timeOfDay / 1000L % 10L);
                    continue block22;
                }
                case 's': {
                    cb.append(this.timeOfDay / 100L % 10L);
                    cb.append(this.timeOfDay / 10L % 10L);
                    cb.append(this.timeOfDay % 10L);
                    continue block22;
                }
                case 'W': {
                    int week;
                    int newYears = (int)((this.days - (long)this.dayOfYear) % 7L + 11L) % 7;
                    int normDay = this.dayOfYear - (7 - newYears) % 7;
                    int n = week = normDay < 0 ? -1 : normDay / 7;
                    if (newYears <= 3) {
                        ++week;
                    }
                    cb.append((week + 1) / 10);
                    cb.append((week + 1) % 10);
                    continue block22;
                }
                case 'w': {
                    cb.append(this.getDayOfWeek());
                    continue block22;
                }
                case 'y': {
                    cb.append(this.year / 10L % 10L);
                    cb.append(this.year % 10L);
                    continue block22;
                }
                case 'Y': {
                    cb.append(this.year / 1000L % 10L);
                    cb.append(this.year / 100L % 10L);
                    cb.append(this.year / 10L % 10L);
                    cb.append(this.year % 10L);
                    continue block22;
                }
                case 'Z': {
                    if (this.zoneName == null) {
                        cb.append("GMT");
                        continue block22;
                    }
                    cb.append(this.zoneName);
                    continue block22;
                }
                case 'z': {
                    long offset = this.zoneOffset;
                    if (offset < 0L) {
                        cb.append("-");
                        offset = -offset;
                    } else {
                        cb.append("+");
                    }
                    cb.append(offset / 36000000L % 10L);
                    cb.append(offset / 3600000L % 10L);
                    cb.append(offset / 600000L % 6L);
                    cb.append(offset / 60000L % 10L);
                    continue block22;
                }
                default: {
                    cb.append(format.charAt(i));
                }
            }
        }
        return cb;
    }

    public String printLocaleDate() {
        if (this.date == null) {
            this.date = new Date();
        }
        this.date.setTime(this.time - this.zoneOffset);
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getInstance();
        }
        return this.dateFormat.format(this.date);
    }

    public long parseDateToGMT(String string) throws Exception {
        long date = this.parseDate(string);
        return this.localToGMT(date);
    }

    public long parseDate(String string) throws Exception {
        try {
            int i = this.skipWhitespace(string, 0);
            char ch = string.charAt(i);
            if (ch >= '0' && ch <= '9' || ch == 'T' && string.charAt(i + 1) >= '0' && string.charAt(i + 1) <= '9') {
                return this.parseISO8601Date(string, i);
            }
            CharBuffer cb = new CharBuffer();
            i = this.scan(string, 0, cb, true);
            if (cb.length() == 0 || !Character.isDigit(cb.charAt(0))) {
                i = this.scan(string, i, cb, true);
            }
            this.dayOfMonth = this.parseInt(cb);
            i = this.scan(string, i, cb, true);
            String smonth = cb.toString();
            this.month = 0L;
            while (this.month < 12L && !monthNames[(int)this.month].equalsIgnoreCase(smonth)) {
                ++this.month;
            }
            if (this.month == 12L) {
                throw new Exception();
            }
            i = this.scan(string, i, cb, true);
            this.year = this.parseInt(cb);
            if (cb.length() < 3 && this.year < 50L) {
                this.year += 2000L;
            } else if (cb.length() < 3 && this.year < 100L) {
                this.year += 1900L;
            }
            i = this.scan(string, i, cb, false);
            this.timeOfDay = this.parseInt(cb) * 3600000;
            i = this.scan(string, i, cb, false);
            this.timeOfDay += (long)(this.parseInt(cb) * 60000);
            i = this.scan(string, i, cb, false);
            this.timeOfDay += (long)(this.parseInt(cb) * 1000);
            if (this.year <= 1600L) {
                --this.dayOfMonth;
            }
            long time = 86400000L * (this.yearToDay(this.year) + this.monthToDay(this.month, this.isLeapYear(this.year)) + this.dayOfMonth - 1L) + this.timeOfDay;
            try {
                i = this.scan(string, i, cb, false);
                for (int j = 0; j < cb.length(); ++j) {
                    ch = cb.charAt(j);
                    if (ch != ';' && ch != ' ') continue;
                    cb.setLength(j);
                }
                ch = cb.charAt(0);
                if (ch == '-' || ch == '+' || ch >= '0' && ch <= '9') {
                    this.zoneOffset = this.parseInt(cb);
                    this.zoneOffset = 60000L * (60L * (this.zoneOffset / 100L) + this.zoneOffset % 100L);
                    time -= this.zoneOffset;
                } else if (!cb.equalsIgnoreCase("gmt") && !cb.equalsIgnoreCase("utc")) {
                    time = this.localToGMT(time);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return time;
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    private long parseISO8601Date(String string, int pos) throws Exception {
        int length = string.length();
        int year = 0;
        char ch = string.charAt(pos);
        if ('0' <= ch && ch <= '9') {
            year = this.scanISOInt(string, pos, length, 4);
            pos += 4;
        }
        if (pos < length && string.charAt(pos) == '-') {
            ++pos;
        }
        int month = 0;
        if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
            month = this.scanISOInt(string, pos, length, 2);
            --month;
            pos += 2;
        } else if (ch == 'W') {
            return Long.MAX_VALUE;
        }
        if (pos < length && string.charAt(pos) == '-') {
            ++pos;
        }
        int day = 0;
        if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
            day = this.scanISOInt(string, pos, length, 2);
            --day;
            pos += 2;
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (pos < length && string.charAt(pos) == 'T') {
            if (++pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                hour = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
            if (pos < length && string.charAt(pos) == ':') {
                ++pos;
            }
            if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                minute = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
            if (pos < length && string.charAt(pos) == ':') {
                ++pos;
            }
            if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                second = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
        }
        long timeOfDay = 1000 * (second + 60 * (minute + 60 * hour));
        if (year <= 1600) {
            --day;
        }
        long time = 86400000L * (this.yearToDay(year) + this.monthToDay(month, this.isLeapYear(year)) + (long)day) + timeOfDay;
        if (pos >= length) {
            return this.localToGMT(time);
        }
        if (string.charAt(pos) == 'Z') {
            ++pos;
        } else if (string.charAt(pos) == '-' || string.charAt(pos) == '+') {
            int sign = 1;
            if (string.charAt(pos) == '-') {
                sign = -1;
            }
            int tzHour = this.scanISOInt(string, ++pos, length, 2);
            int tzMinute = 0;
            if ((pos += 2) < length && string.charAt(pos) == ':') {
                ++pos;
            }
            if (pos < length && '0' <= (ch = string.charAt(pos)) && ch <= '9') {
                tzMinute = this.scanISOInt(string, pos, length, 2);
                pos += 2;
            }
            time += (long)(sign * 1000 * (60 * (tzMinute + 60 * tzHour)));
        } else {
            time = this.localToGMT(time);
        }
        pos = this.skipWhitespace(string, pos);
        if (pos < length) {
            throw new Exception("extra junk at end of ISO date");
        }
        return time;
    }

    private int scanISOInt(String string, int pos, int length, int digits) throws Exception {
        int value = 0;
        for (int i = 0; i < digits; ++i) {
            char ch;
            if (pos >= length) {
                throw new Exception("expected ISO8601 digit");
            }
            if ('0' > (ch = string.charAt(pos++)) || ch > '9') {
                throw new Exception("expected ISO8601 digit");
            }
            value = 10 * value + ch - 48;
        }
        return value;
    }

    private int skipWhitespace(String string, int i) {
        char ch;
        while (i < string.length() && ((ch = string.charAt(i)) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
            ++i;
        }
        return i;
    }

    private int scan(String string, int i, CharBuffer cb, boolean dash) throws Exception {
        char ch;
        cb.setLength(0);
        while (i < string.length() && (Character.isWhitespace(ch = string.charAt(i)) || ch == ':' || dash && ch == '-')) {
            ++i;
        }
        while (!(i >= string.length() || Character.isWhitespace(ch = string.charAt(i)) || ch == ':' || dash && ch == '-')) {
            cb.append(ch);
            ++i;
        }
        if (cb.length() == 0) {
            throw new Exception();
        }
        return i;
    }

    private int parseInt(CharBuffer cb) throws Exception {
        int value = 0;
        int sign = 1;
        for (int i = 0; i < cb.length(); ++i) {
            char ch = cb.charAt(i);
            if (i == 0 && ch == '-') {
                sign = -1;
                continue;
            }
            if (i == 0 && ch == '+') continue;
            if (ch >= '0' && ch <= '9') {
                value = 10 * value + ch - 48;
                continue;
            }
            throw new Exception();
        }
        return sign * value;
    }

    private long localToGMT(long time) throws Exception {
        this.calculateSplit(time - (long)this.localTimeZone.getRawOffset());
        this.zoneOffset = this.getZoneOffset();
        this.calculateSplit(time - this.zoneOffset);
        return this.time;
    }

    private long GMTToLocal(long time) throws Exception {
        this.calculateSplit(time + (long)this.localTimeZone.getRawOffset());
        this.zoneOffset = this.getZoneOffset();
        return time + this.zoneOffset;
    }

    public long calculate(long time, boolean isLocal) {
        if (isLocal) {
            this.calculateSplit(time + (long)this.localTimeZone.getRawOffset());
            this.zoneOffset = this.getZoneOffset();
            this.calculateSplit(time + this.zoneOffset);
            this.zoneName = this.zoneOffset == (long)this.localTimeZone.getRawOffset() ? stdZoneName : dstZoneName;
        } else {
            this.zoneName = null;
            this.calculateSplit(time);
        }
        return this.time;
    }

    public long setTime(long time) {
        this.calculateSplit(time);
        return time;
    }

    public long setDate(long year, long month, long day) {
        this.calculateSplit(this.time);
        year += (long)Math.floor((double)month / 12.0);
        month = (long)((double)month - 12.0 * Math.floor((double)month / 12.0));
        this.year = year;
        this.month = month;
        this.dayOfMonth = day;
        this.calculateJoin();
        this.calculateSplit(this.time);
        return this.time;
    }

    public long setTime(long hour, long minute, long second, long ms) {
        this.calculateSplit(this.time);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.ms = ms;
        this.calculateJoin();
        this.calculateSplit(this.time);
        return this.time;
    }

    public long getTime() {
        return this.time;
    }

    public long getTimeOfDay() {
        return this.timeOfDay;
    }

    public int getHour() {
        return (int)this.hour;
    }

    public int getMinute() {
        return (int)this.minute;
    }

    public long getYear() {
        return this.year;
    }

    public int getMonth() {
        return (int)this.month;
    }

    public int getDayOfMonth() {
        return (int)this.dayOfMonth;
    }

    public int getDayOfWeek() {
        return (int)(this.days % 7L + 11L) % 7;
    }

    public long get(int field) {
        switch (field) {
            case 9: {
                return this.time;
            }
            case 0: {
                return this.year;
            }
            case 1: {
                return this.month;
            }
            case 2: {
                return this.dayOfMonth;
            }
            case 3: {
                return (this.days % 7L + 11L) % 7L;
            }
            case 4: {
                return (this.days % 7L + 11L) % 7L;
            }
            case 5: {
                return this.hour;
            }
            case 6: {
                return this.minute;
            }
            case 7: {
                return this.second;
            }
            case 8: {
                return this.ms;
            }
            case 10: {
                return this.getZoneOffset() / 1000L;
            }
        }
        return Long.MAX_VALUE;
    }

    public long set(int field, long value) {
        switch (field) {
            case 0: {
                this.year = value;
                break;
            }
            case 1: {
                this.month = value;
                break;
            }
            case 2: {
                this.dayOfMonth = value;
                break;
            }
            case 5: {
                this.hour = value;
                break;
            }
            case 6: {
                this.minute = value;
                break;
            }
            case 7: {
                this.second = value;
                break;
            }
            case 8: {
                this.ms = value;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.calculateJoin();
        this.calculateSplit(this.time);
        return this.time;
    }

    public long getZoneOffset() {
        long year = this.year;
        long off = this.localTimeZone.getOffset(1, (int)year, (int)this.month, (int)this.dayOfMonth + 1, (int)(this.days % 7L + 11L) % 7 + 1, (int)this.timeOfDay);
        return off;
    }

    private QDate(boolean dummy) {
    }

    public Object clone() {
        QDate newObj = new QDate();
        newObj.localTimeZone = this.localTimeZone;
        newObj.utcTimeZone = this.utcTimeZone;
        return newObj;
    }

    public String toString() {
        return this.printDate();
    }

    static {
        shortWeekday = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        longWeekday = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        shortMonth = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        longMonth = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    }
}

