/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.Map;

class BindPath
extends FilesystemPath {
    private Node _node;
    private Path _backing;

    BindPath(Path backing) {
        this(null, "/", null, "/", null, backing);
        this._root = this;
        if (backing instanceof FilesystemPath) {
            this._separatorChar = ((FilesystemPath)backing)._separatorChar;
        }
    }

    private BindPath(BindPath root, String userPath, Map attributes, String path, Node node, Path backing) {
        super(root, userPath, path);
        if (backing == null) {
            throw new IllegalArgumentException("backing must not be null");
        }
        if (node == null) {
            node = new Node("", backing);
        }
        if (backing == null) {
            backing = node._backing;
        }
        this._node = node;
        this._backing = backing;
        if (backing instanceof FilesystemPath) {
            this._separatorChar = ((FilesystemPath)backing)._separatorChar;
        }
    }

    protected Path fsWalk(String userPath, Map attributes, String path) {
        Node ptr = this._node;
        int offset = 0;
        while (offset + 1 < path.length()) {
            if (ptr.firstChild == null) {
                return ptr._backing.lookup(path.substring(offset), attributes);
            }
            int p = path.indexOf(this._separatorChar, offset + 1);
            String segment = p == -1 ? path.substring(offset + 1) : path.substring(offset + 1, p);
            Node next = ptr.findChild(segment);
            if (next == null) {
                return ptr._backing.lookup(path.substring(offset), attributes);
            }
            offset = p;
            ptr = next;
        }
        return new BindPath(this, userPath, attributes, path, this._node, null);
    }

    public String getScheme() {
        return this._root.getScheme();
    }

    public boolean exists() {
        return this._backing.exists();
    }

    public boolean isDirectory() {
        return this._backing.isDirectory();
    }

    public boolean isFile() {
        return this._backing.isFile();
    }

    public long getLength() {
        return this._backing.getLength();
    }

    public long getLastModified() {
        return this._backing.getLastModified();
    }

    public boolean canRead() {
        return this._backing.canRead();
    }

    public boolean canWrite() {
        return this._backing.canWrite();
    }

    public String[] list() throws IOException {
        String[] list = this._backing.list();
        if (this._node.firstChild == null) {
            return list;
        }
        String[] newList = new String[list.length + this._node.size()];
        int i = 0;
        Node ptr = this._node.firstChild;
        while (ptr != null) {
            newList[i++] = ptr.name;
            ptr = ptr.next;
        }
        for (int j = 0; j < list.length; ++j) {
            newList[i++] = list[j++];
        }
        return newList;
    }

    public boolean mkdir() throws IOException {
        return this._backing.mkdir();
    }

    public boolean mkdirs() throws IOException {
        return this._backing.mkdirs();
    }

    public boolean remove() throws IOException {
        return this._backing.remove();
    }

    public boolean renameTo(Path path) throws IOException {
        return this._backing.renameTo(path);
    }

    public StreamImpl openReadImpl() throws IOException {
        return this._backing.openReadImpl();
    }

    public StreamImpl openWriteImpl() throws IOException {
        return this._backing.openWriteImpl();
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        return this._backing.openReadWriteImpl();
    }

    public StreamImpl openAppendImpl() throws IOException {
        return this._backing.openAppendImpl();
    }

    void bind(String path, Path context) {
        Node ptr = this._node;
        int offset = 0;
        while (offset + 1 < path.length()) {
            int p = path.indexOf(this._separatorChar, offset + 1);
            String segment = p == -1 ? path.substring(offset + 1) : path.substring(offset + 1, p);
            Node next = ptr.findChild(segment);
            if (next != null) continue;
            next = ptr.addChild(segment, ptr._backing);
        }
        ptr._backing = context;
    }

    public int hashCode() {
        return this._backing.hashCode();
    }

    public boolean equals(Object b) {
        return this._backing.equals(b);
    }

    public String toString() {
        return this._backing.toString();
    }

    static class Node {
        Node parent;
        Node firstChild;
        Node next;
        String name;
        Path _backing;

        Node(String name, Path backing) {
            this.name = name;
            this._backing = backing;
        }

        int size() {
            int size = 0;
            Node ptr = this.firstChild;
            while (ptr != null) {
                ++size;
                ptr = ptr.next;
            }
            return size;
        }

        Node findChild(String name) {
            Node ptr = this.firstChild;
            while (ptr != null) {
                if (ptr.name.equals(name)) {
                    return ptr;
                }
                ptr = ptr.next;
            }
            return null;
        }

        Node addChild(String name, Path backing) {
            Node ptr = this.firstChild;
            while (ptr != null) {
                if (ptr.name.equals(name)) {
                    ptr._backing = backing;
                    return ptr;
                }
                ptr = ptr.next;
            }
            Node node = new Node(name, backing);
            node.next = this.firstChild;
            node.parent = this;
            this.firstChild = node;
            return node;
        }
    }
}

